/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.util.ArrayQueueOutOfOrderSequence;
import org.neo4j.kernel.impl.util.OutOfOrderSequence;

public class ArrayQueueOutOfOrderSequenceTest {
    @Test
    public void shouldExposeGapFreeSequenceSingleThreaded() throws Exception {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 10);
        this.offer((OutOfOrderSequence)sequence, 1L, 1L);
        this.assertGet((OutOfOrderSequence)sequence, 1L, 1L);
        this.offer((OutOfOrderSequence)sequence, 2L, 2L);
        this.assertGet((OutOfOrderSequence)sequence, 2L, 2L);
        Assert.assertFalse((boolean)sequence.seen(4L, 3L));
        sequence.offer(4L, 3L);
        this.assertGet((OutOfOrderSequence)sequence, 2L, 2L);
        this.offer((OutOfOrderSequence)sequence, 3L, 4L);
        this.assertGet((OutOfOrderSequence)sequence, 4L, 3L);
        this.offer((OutOfOrderSequence)sequence, 5L, 5L);
        this.assertGet((OutOfOrderSequence)sequence, 5L, 5L);
        this.offer((OutOfOrderSequence)sequence, 10L, 6L);
        this.offer((OutOfOrderSequence)sequence, 11L, 7L);
        this.offer((OutOfOrderSequence)sequence, 8L, 8L);
        this.offer((OutOfOrderSequence)sequence, 9L, 9L);
        this.offer((OutOfOrderSequence)sequence, 7L, 10L);
        this.assertGet((OutOfOrderSequence)sequence, 5L, 5L);
        this.offer((OutOfOrderSequence)sequence, 6L, 11L);
        this.assertGet((OutOfOrderSequence)sequence, 11L, 7L);
    }

    @Test
    public void shouldExtendArrayIfNeedBe() throws Exception {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5);
        this.offer((OutOfOrderSequence)sequence, 3L, 0L);
        this.offer((OutOfOrderSequence)sequence, 2L, 1L);
        this.offer((OutOfOrderSequence)sequence, 5L, 2L);
        this.offer((OutOfOrderSequence)sequence, 4L, 3L);
        this.offer((OutOfOrderSequence)sequence, 6L, 4L);
        this.offer((OutOfOrderSequence)sequence, 1L, 5L);
        this.assertGet((OutOfOrderSequence)sequence, 6L, 4L);
    }

    @Test
    public void shouldDealWithThisScenario() throws Exception {
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(0L, 5);
        Assert.assertTrue((boolean)this.offer((OutOfOrderSequence)sequence, 1L, 0L));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 3L, 0L));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 4L, 0L));
        Assert.assertTrue((boolean)this.offer((OutOfOrderSequence)sequence, 2L, 0L));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 6L, 0L));
        Assert.assertTrue((boolean)this.offer((OutOfOrderSequence)sequence, 5L, 0L));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 8L, 0L));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 9L, 0L));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 10L, 0L));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 11L, 0L));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 12L, 0L));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 13L, 0L));
        Assert.assertFalse((boolean)this.offer((OutOfOrderSequence)sequence, 14L, 0L));
        Assert.assertTrue((boolean)this.offer((OutOfOrderSequence)sequence, 7L, 0L));
        this.assertGet((OutOfOrderSequence)sequence, 14L, 0L);
    }

    @Test
    public void shouldKeepItsCoolWhenMultipleThreadsAreHammeringIt() throws Exception {
        final AtomicLong numberSource = new AtomicLong();
        ArrayQueueOutOfOrderSequence sequence = new ArrayQueueOutOfOrderSequence(numberSource.get(), 5);
        final AtomicBoolean end = new AtomicBoolean();
        final CountDownLatch startSignal = new CountDownLatch(1);
        Thread[] threads = new Thread[1];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread((OutOfOrderSequence)sequence){
                final /* synthetic */ OutOfOrderSequence val$sequence;
                {
                    this.val$sequence = outOfOrderSequence;
                }

                @Override
                public void run() {
                    ArrayQueueOutOfOrderSequenceTest.this.await(startSignal);
                    while (!end.get()) {
                        long number = numberSource.incrementAndGet();
                        ArrayQueueOutOfOrderSequenceTest.this.offer(this.val$sequence, number, number + 2L);
                    }
                }
            };
        }
        for (Thread thread : threads) {
            thread.start();
        }
        startSignal.countDown();
        while (numberSource.get() < 10000000L) {
            Thread.sleep(1L);
            Thread.yield();
        }
        end.set(true);
        for (Thread thread : threads) {
            thread.join();
        }
        long lastNumber = numberSource.get();
        this.assertGet((OutOfOrderSequence)sequence, lastNumber, lastNumber + 2L);
    }

    private boolean offer(OutOfOrderSequence sequence, long number, long meta) {
        Assert.assertFalse((boolean)sequence.seen(number, meta));
        boolean result = sequence.offer(number, meta);
        Assert.assertTrue((boolean)sequence.seen(number, meta));
        return result;
    }

    private void assertGet(OutOfOrderSequence sequence, long number, long meta) {
        long[] data = sequence.get();
        Assert.assertEquals((long)number, (long)data[0]);
        Assert.assertEquals((long)meta, (long)data[1]);
    }

    private void await(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

