/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.InOrderImpl;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.JumpingIdGeneratorFactory;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicStringStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class PropertyStoreTest {
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule(false);
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private EphemeralFileSystemAbstraction fileSystemAbstraction;
    private File path;

    @Before
    public void setup() throws IOException {
        this.fileSystemAbstraction = this.fsRule.get();
        this.path = new File("/tmp/foobar");
        this.fileSystemAbstraction.mkdir(this.path.getParentFile());
        this.fileSystemAbstraction.create(this.path);
    }

    @Test
    public void shouldWriteOutTheDynamicChainBeforeUpdatingThePropertyRecord() throws IOException {
        PageCache pageCache = (PageCache)Mockito.mock(PageCache.class);
        PagedFile storeFile = (PagedFile)Mockito.mock(PagedFile.class);
        Mockito.when((Object)pageCache.map((File)Matchers.any(File.class), Matchers.anyInt())).thenReturn((Object)storeFile);
        DynamicStringStore stringPropertyStore = (DynamicStringStore)Mockito.mock(DynamicStringStore.class);
        PageCursor cursor = (PageCursor)Mockito.mock(PageCursor.class);
        Mockito.when((Object)cursor.next()).thenReturn((Object)true);
        Mockito.when((Object)storeFile.io((long)Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)cursor);
        Mockito.when((Object)storeFile.pageSize()).thenReturn((Object)8);
        Config config = (Config)Mockito.mock(Config.class);
        Mockito.when((Object)config.get(PropertyStore.Configuration.rebuild_idgenerators_fast)).thenReturn((Object)true);
        PropertyStore store = new PropertyStore(this.path, config, (IdGeneratorFactory)new JumpingIdGeneratorFactory(1), pageCache, (FileSystemAbstraction)this.fileSystemAbstraction, StringLogger.DEV_NULL, stringPropertyStore, (PropertyKeyTokenStore)Mockito.mock(PropertyKeyTokenStore.class), (DynamicArrayStore)Mockito.mock(DynamicArrayStore.class), null, null);
        store.makeStoreOk();
        long l = store.nextId();
        PropertyRecord record = new PropertyRecord(l);
        record.setInUse(true);
        DynamicRecord dynamicRecord = this.dynamicRecord();
        PropertyBlock propertyBlock = this.propertyBlockWith(dynamicRecord);
        record.setPropertyBlock(propertyBlock);
        store.updateRecord(record);
        InOrderImpl inOrder = new InOrderImpl(Arrays.asList(stringPropertyStore, cursor));
        ((DynamicStringStore)inOrder.verify((Object)stringPropertyStore)).updateRecord(dynamicRecord);
        ((PageCursor)inOrder.verify((Object)cursor)).putByte((byte)0);
        ((PageCursor)inOrder.verify((Object)cursor, Mockito.times((int)2))).putInt(-1);
        ((PageCursor)inOrder.verify((Object)cursor)).putLong(propertyBlock.getValueBlocks()[0]);
        ((PageCursor)inOrder.verify((Object)cursor)).putLong(0L);
    }

    private DynamicRecord dynamicRecord() {
        DynamicRecord dynamicRecord = new DynamicRecord(42L);
        dynamicRecord.setType(PropertyType.STRING.intValue());
        dynamicRecord.setCreated();
        return dynamicRecord;
    }

    private PropertyBlock propertyBlockWith(DynamicRecord dynamicRecord) {
        PropertyBlock propertyBlock = new PropertyBlock();
        PropertyKeyTokenRecord key = new PropertyKeyTokenRecord(10);
        propertyBlock.setSingleBlock((long)key.getId() | (long)PropertyType.STRING.intValue() << 24 | dynamicRecord.getId() << 28);
        propertyBlock.addValueRecord(dynamicRecord);
        return propertyBlock;
    }
}

