/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.PageCacheRule;

public abstract class RecordStoreConsistentReadTest<R extends AbstractBaseRecord, S extends RecordStore<R>> {
    protected static final int ID = 1;
    @ClassRule
    public static final PageCacheRule pageCacheRule = new PageCacheRule(false);
    private FileSystemAbstraction fs;
    private AtomicBoolean nextReadIsInconsistent;

    @Before
    public void setUp() {
        this.fs = new EphemeralFileSystemAbstraction();
        this.nextReadIsInconsistent = new AtomicBoolean();
    }

    private NeoStore storeFixture() {
        PageCache pageCache = pageCacheRule.getPageCache(this.fs);
        pageCache = pageCacheRule.withInconsistentReads(pageCache, this.nextReadIsInconsistent);
        File storeDir = new File("stores");
        StringLogger logger = StringLogger.DEV_NULL;
        StoreFactory factory = new StoreFactory(this.fs, storeDir, pageCache, logger, new Monitors());
        NeoStore neoStore = factory.newNeoStore(true);
        S store = this.initialiseStore(neoStore);
        CommonAbstractStore commonAbstractStore = (CommonAbstractStore)store;
        commonAbstractStore.rebuildIdGenerator();
        return neoStore;
    }

    protected S initialiseStore(NeoStore neoStore) {
        S store = this.getStore(neoStore);
        store.updateRecord(this.createExistingRecord(false, false));
        return store;
    }

    protected abstract S getStore(NeoStore var1);

    protected abstract R createNullRecord(long var1);

    protected abstract R createExistingRecord(boolean var1, boolean var2);

    protected abstract R getLight(long var1, S var3);

    protected abstract void assertRecordsEqual(R var1, R var2);

    protected R getHeavy(S store, int id) {
        return (R)store.getRecord((long)id);
    }

    protected R getForce(S store, int id) {
        return (R)store.forceGetRecord((long)id);
    }

    @Test
    public void mustReadExistingRecord() {
        try (NeoStore neoStore = this.storeFixture();){
            S store = this.getStore(neoStore);
            R record = this.getHeavy(store, 1);
            this.assertRecordsEqual(record, this.createExistingRecord(false, false));
        }
    }

    @Test
    public void mustReadExistingLightRecord() {
        try (NeoStore neoStore = this.storeFixture();){
            S store = this.getStore(neoStore);
            R record = this.getLight(1L, store);
            this.assertRecordsEqual(record, this.createExistingRecord(false, true));
        }
    }

    @Test
    public void mustForceReadExistingRecord() {
        try (NeoStore neoStore = this.storeFixture();){
            S store = this.getStore(neoStore);
            R record = this.getForce(store, 1);
            this.assertRecordsEqual(record, this.createExistingRecord(true, false));
        }
    }

    @Test(expected=InvalidRecordException.class)
    public void readingNonExistingRecordMustThrow() {
        try (NeoStore neoStore = this.storeFixture();){
            S store = this.getStore(neoStore);
            this.getHeavy(store, 2);
        }
    }

    @Test
    public void readingNonExistingLightRecordMustReturnNull() {
        try (NeoStore neoStore = this.storeFixture();){
            S store = this.getStore(neoStore);
            R record = this.getLight(2L, store);
            Assert.assertNull(record);
        }
    }

    @Test
    public void forceReadingNonExistingRecordMustReturnEmptyRecordWithThatId() {
        try (NeoStore neoStore = this.storeFixture();){
            S store = this.getStore(neoStore);
            R record = this.getForce(store, 2);
            R nullRecord = this.createNullRecord(2L);
            this.assertRecordsEqual(record, nullRecord);
        }
    }

    @Test
    public void mustRetryInconsistentReads() {
        try (NeoStore neoStore = this.storeFixture();){
            S store = this.getStore(neoStore);
            this.nextReadIsInconsistent.set(true);
            R record = this.getHeavy(store, 1);
            this.assertRecordsEqual(record, this.createExistingRecord(false, false));
        }
    }

    @Test
    public void mustRetryInconsistentLightReads() {
        try (NeoStore neoStore = this.storeFixture();){
            S store = this.getStore(neoStore);
            this.nextReadIsInconsistent.set(true);
            R record = this.getLight(1L, store);
            this.assertRecordsEqual(record, this.createExistingRecord(false, true));
        }
    }

    @Test
    public void mustRetryInconsistentForcedReads() {
        try (NeoStore neoStore = this.storeFixture();){
            S store = this.getStore(neoStore);
            this.nextReadIsInconsistent.set(true);
            R record = this.getForce(store, 1);
            this.assertRecordsEqual(record, this.createExistingRecord(true, false));
        }
    }

    public static class PropertyStoreConsistentReadTest
    extends RecordStoreConsistentReadTest<PropertyRecord, PropertyStore> {
        @Override
        protected PropertyStore getStore(NeoStore neoStore) {
            return neoStore.getPropertyStore();
        }

        @Override
        protected PropertyRecord createNullRecord(long id) {
            PropertyRecord record = new PropertyRecord(id);
            record.setNextProp(0L);
            record.setPrevProp(0L);
            return record;
        }

        @Override
        protected PropertyRecord createExistingRecord(boolean forced, boolean light) {
            PropertyRecord record = new PropertyRecord(1L);
            record.setId(1L);
            record.setNextProp(2L);
            record.setPrevProp(4L);
            record.setInUse(true);
            PropertyBlock block = new PropertyBlock();
            DynamicRecordAllocator stringAllocator = new DynamicRecordAllocator(){

                public int dataSize() {
                    return 64;
                }

                public DynamicRecord nextUsedRecordOrNew(Iterator<DynamicRecord> recordsToUseFirst) {
                    DynamicRecord record = new DynamicRecord(7L);
                    record.setCreated();
                    record.setInUse(true);
                    return record;
                }
            };
            String value = "a string too large to fit in the property block itself";
            PropertyStore.encodeValue((PropertyBlock)block, (int)6, (Object)value, (DynamicRecordAllocator)stringAllocator, null);
            if (forced || light) {
                block.getValueRecords().clear();
            }
            record.setPropertyBlock(block);
            return record;
        }

        @Override
        protected PropertyRecord getLight(long id, PropertyStore store) {
            throw new AssumptionViolatedException("Getting a light non-existing property record will throw.");
        }

        @Override
        protected PropertyRecord getHeavy(PropertyStore store, int id) {
            PropertyRecord record = (PropertyRecord)super.getHeavy(store, id);
            this.ensureHeavy(store, record);
            return record;
        }

        private void ensureHeavy(PropertyStore store, PropertyRecord record) {
            for (PropertyBlock propertyBlock : record) {
                store.ensureHeavy(propertyBlock);
            }
        }

        @Override
        protected void assertRecordsEqual(PropertyRecord actualRecord, PropertyRecord expectedRecord) {
            Assert.assertNotNull((String)"actualRecord", (Object)actualRecord);
            Assert.assertNotNull((String)"expectedRecord", (Object)expectedRecord);
            Assert.assertThat((String)"getDeletedRecords", (Object)actualRecord.getDeletedRecords(), (Matcher)Matchers.is((Object)expectedRecord.getDeletedRecords()));
            Assert.assertThat((String)"getNextProp", (Object)actualRecord.getNextProp(), (Matcher)Matchers.is((Object)expectedRecord.getNextProp()));
            Assert.assertThat((String)"getNodeId", (Object)actualRecord.getNodeId(), (Matcher)Matchers.is((Object)expectedRecord.getNodeId()));
            Assert.assertThat((String)"getPrevProp", (Object)actualRecord.getPrevProp(), (Matcher)Matchers.is((Object)expectedRecord.getPrevProp()));
            Assert.assertThat((String)"getRelId", (Object)actualRecord.getRelId(), (Matcher)Matchers.is((Object)expectedRecord.getRelId()));
            Assert.assertThat((String)"getId", (Object)actualRecord.getId(), (Matcher)Matchers.is((Object)expectedRecord.getId()));
            Assert.assertThat((String)"getLongId", (Object)actualRecord.getLongId(), (Matcher)Matchers.is((Object)expectedRecord.getLongId()));
            List actualBlocks = IteratorUtil.asList((Iterable)actualRecord);
            List expectedBlocks = IteratorUtil.asList((Iterable)expectedRecord);
            Assert.assertThat((String)"getPropertyBlocks().size", (Object)actualBlocks.size(), (Matcher)Matchers.is((Object)expectedBlocks.size()));
            for (int i = 0; i < actualBlocks.size(); ++i) {
                PropertyBlock actualBlock = (PropertyBlock)actualBlocks.get(i);
                PropertyBlock expectedBlock = (PropertyBlock)expectedBlocks.get(i);
                this.assertPropertyBlocksEqual(i, actualBlock, expectedBlock);
            }
        }

        private void assertPropertyBlocksEqual(int index, PropertyBlock actualBlock, PropertyBlock expectedBlock) {
            Assert.assertThat((String)("[" + index + "]getKeyIndexId"), (Object)actualBlock.getKeyIndexId(), (Matcher)Matchers.is((Object)expectedBlock.getKeyIndexId()));
            Assert.assertThat((String)("[" + index + "]getSingleValueBlock"), (Object)actualBlock.getSingleValueBlock(), (Matcher)Matchers.is((Object)expectedBlock.getSingleValueBlock()));
            Assert.assertThat((String)("[" + index + "]getSingleValueByte"), (Object)actualBlock.getSingleValueByte(), (Matcher)Matchers.is((Object)expectedBlock.getSingleValueByte()));
            Assert.assertThat((String)("[" + index + "]getSingleValueInt"), (Object)actualBlock.getSingleValueInt(), (Matcher)Matchers.is((Object)expectedBlock.getSingleValueInt()));
            Assert.assertThat((String)("[" + index + "]getSingleValueLong"), (Object)actualBlock.getSingleValueLong(), (Matcher)Matchers.is((Object)expectedBlock.getSingleValueLong()));
            Assert.assertThat((String)("[" + index + "]getSingleValueShort"), (Object)actualBlock.getSingleValueShort(), (Matcher)Matchers.is((Object)expectedBlock.getSingleValueShort()));
            Assert.assertThat((String)("[" + index + "]getSize"), (Object)actualBlock.getSize(), (Matcher)Matchers.is((Object)expectedBlock.getSize()));
            Assert.assertThat((String)("[" + index + "]getType"), (Object)actualBlock.getType(), (Matcher)Matchers.is((Object)expectedBlock.getType()));
            Assert.assertThat((String)("[" + index + "]isLight"), (Object)actualBlock.isLight(), (Matcher)Matchers.is((Object)expectedBlock.isLight()));
            List actualValueRecords = actualBlock.getValueRecords();
            List expectedValueRecords = expectedBlock.getValueRecords();
            Assert.assertThat((String)("[" + index + "]getValueRecords.size"), (Object)actualValueRecords.size(), (Matcher)Matchers.is((Object)expectedValueRecords.size()));
            for (int i = 0; i < actualValueRecords.size(); ++i) {
                DynamicRecord actualValueRecord = (DynamicRecord)actualValueRecords.get(i);
                DynamicRecord expectedValueRecord = (DynamicRecord)expectedValueRecords.get(i);
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]getData"), (Object)actualValueRecord.getData(), (Matcher)Matchers.is((Object)expectedValueRecord.getData()));
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]getLength"), (Object)actualValueRecord.getLength(), (Matcher)Matchers.is((Object)expectedValueRecord.getLength()));
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]getNextBlock"), (Object)actualValueRecord.getNextBlock(), (Matcher)Matchers.is((Object)expectedValueRecord.getNextBlock()));
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]getType"), (Object)actualValueRecord.getType(), (Matcher)Matchers.is((Object)expectedValueRecord.getType()));
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]getId"), (Object)actualValueRecord.getId(), (Matcher)Matchers.is((Object)expectedValueRecord.getId()));
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]getLongId"), (Object)actualValueRecord.getLongId(), (Matcher)Matchers.is((Object)expectedValueRecord.getLongId()));
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]isLight"), (Object)actualValueRecord.isLight(), (Matcher)Matchers.is((Object)expectedValueRecord.isLight()));
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]isStartRecord"), (Object)actualValueRecord.isStartRecord(), (Matcher)Matchers.is((Object)expectedValueRecord.isStartRecord()));
                Assert.assertThat((String)("[" + index + "]getValueRecords[" + i + "]inUse"), (Object)actualValueRecord.inUse(), (Matcher)Matchers.is((Object)expectedValueRecord.inUse()));
            }
        }
    }

    public static class SchemaStoreConsistentReadTest
    extends RecordStoreConsistentReadTest<DynamicRecord, SchemaStore> {
        private static final byte[] EXISTING_RECORD_DATA = "Random bytes".getBytes();

        @Override
        protected SchemaStore getStore(NeoStore neoStore) {
            return neoStore.getSchemaStore();
        }

        @Override
        protected DynamicRecord createNullRecord(long id) {
            DynamicRecord record = new DynamicRecord(id);
            record.setNextBlock(0L);
            return record;
        }

        @Override
        protected DynamicRecord createExistingRecord(boolean forced, boolean light) {
            DynamicRecord record = new DynamicRecord(1L);
            record.setInUse(true);
            record.setStartRecord(true);
            record.setLength(EXISTING_RECORD_DATA.length);
            if (!light) {
                record.setData(EXISTING_RECORD_DATA);
            }
            return record;
        }

        @Override
        protected DynamicRecord getLight(long id, SchemaStore store) {
            throw new AssumptionViolatedException("Light loading of DynamicRecords is a little different");
        }

        @Override
        protected void assertRecordsEqual(DynamicRecord actualRecord, DynamicRecord expectedRecord) {
            Assert.assertNotNull((String)"actualRecord", (Object)actualRecord);
            Assert.assertNotNull((String)"expectedRecord", (Object)expectedRecord);
            Assert.assertThat((String)"getData", (Object)actualRecord.getData(), (Matcher)Matchers.is((Object)expectedRecord.getData()));
            Assert.assertThat((String)"getLength", (Object)actualRecord.getLength(), (Matcher)Matchers.is((Object)expectedRecord.getLength()));
            Assert.assertThat((String)"getNextBlock", (Object)actualRecord.getNextBlock(), (Matcher)Matchers.is((Object)expectedRecord.getNextBlock()));
            Assert.assertThat((String)"getType", (Object)actualRecord.getType(), (Matcher)Matchers.is((Object)expectedRecord.getType()));
            Assert.assertThat((String)"getId", (Object)actualRecord.getId(), (Matcher)Matchers.is((Object)expectedRecord.getId()));
            Assert.assertThat((String)"getLongId", (Object)actualRecord.getLongId(), (Matcher)Matchers.is((Object)expectedRecord.getLongId()));
            Assert.assertThat((String)"isLight", (Object)actualRecord.isLight(), (Matcher)Matchers.is((Object)expectedRecord.isLight()));
            Assert.assertThat((String)"isStartRecord", (Object)actualRecord.isStartRecord(), (Matcher)Matchers.is((Object)expectedRecord.isStartRecord()));
        }
    }

    public static class LabelTokenStoreConsistentReadTest
    extends RecordStoreConsistentReadTest<LabelTokenRecord, LabelTokenStore> {
        private static final int NAME_RECORD_ID = 2;
        private static final byte[] NAME_RECORD_DATA = "TheLabel".getBytes(Charset.forName("UTF-8"));

        @Override
        protected LabelTokenStore getStore(NeoStore neoStore) {
            return neoStore.getLabelTokenStore();
        }

        @Override
        protected LabelTokenStore initialiseStore(NeoStore neoStore) {
            LabelTokenStore store = this.getStore(neoStore);
            LabelTokenRecord record = this.createExistingRecord(false, false);
            DynamicRecord nameRecord = new DynamicRecord(2L);
            record.getNameRecords().clear();
            nameRecord.setData(NAME_RECORD_DATA);
            nameRecord.setInUse(true);
            record.addNameRecord(nameRecord);
            store.updateRecord((TokenRecord)record);
            return store;
        }

        @Override
        protected LabelTokenRecord createNullRecord(long id) {
            LabelTokenRecord labelTokenRecord = new LabelTokenRecord((int)id);
            labelTokenRecord.setIsLight(true);
            return labelTokenRecord;
        }

        @Override
        protected LabelTokenRecord createExistingRecord(boolean forced, boolean light) {
            LabelTokenRecord record = new LabelTokenRecord(1);
            record.setNameId(2);
            record.setInUse(true);
            record.setIsLight(forced);
            if (!forced) {
                DynamicRecord nameRecord = new DynamicRecord(2L);
                nameRecord.setLength(NAME_RECORD_DATA.length);
                nameRecord.setInUse(true);
                record.addNameRecord(nameRecord);
            }
            return record;
        }

        @Override
        protected LabelTokenRecord getLight(long id, LabelTokenStore store) {
            throw new AssumptionViolatedException("No light loading of LabelTokenRecords");
        }

        @Override
        protected void assertRecordsEqual(LabelTokenRecord actualRecord, LabelTokenRecord expectedRecord) {
            Assert.assertNotNull((String)"actualRecord", (Object)actualRecord);
            Assert.assertNotNull((String)"expectedRecord", (Object)expectedRecord);
            Assert.assertThat((String)"getNameId", (Object)actualRecord.getNameId(), (Matcher)Matchers.is((Object)expectedRecord.getNameId()));
            Assert.assertThat((String)"getId", (Object)actualRecord.getId(), (Matcher)Matchers.is((Object)expectedRecord.getId()));
            Assert.assertThat((String)"getLongId", (Object)actualRecord.getLongId(), (Matcher)Matchers.is((Object)expectedRecord.getLongId()));
            Assert.assertThat((String)"isLight", (Object)actualRecord.isLight(), (Matcher)Matchers.is((Object)expectedRecord.isLight()));
            Collection actualNameRecords = actualRecord.getNameRecords();
            Collection expectedNameRecords = expectedRecord.getNameRecords();
            Assert.assertThat((String)"getNameRecords.size", (Object)actualNameRecords.size(), (Matcher)Matchers.is((Object)expectedNameRecords.size()));
            Iterator actualNRs = actualNameRecords.iterator();
            Iterator expectedNRs = expectedNameRecords.iterator();
            int i = 0;
            while (actualNRs.hasNext() && expectedNRs.hasNext()) {
                DynamicRecord actualNameRecord = (DynamicRecord)actualNRs.next();
                DynamicRecord expectedNameRecord = (DynamicRecord)expectedNRs.next();
                Assert.assertThat((String)("[" + i + "]getData"), (Object)actualNameRecord.getData(), (Matcher)Matchers.is((Object)expectedNameRecord.getData()));
                Assert.assertThat((String)("[" + i + "]getLength"), (Object)actualNameRecord.getLength(), (Matcher)Matchers.is((Object)expectedNameRecord.getLength()));
                Assert.assertThat((String)("[" + i + "]getNextBlock"), (Object)actualNameRecord.getNextBlock(), (Matcher)Matchers.is((Object)expectedNameRecord.getNextBlock()));
                Assert.assertThat((String)("[" + i + "]getType"), (Object)actualNameRecord.getType(), (Matcher)Matchers.is((Object)expectedNameRecord.getType()));
                Assert.assertThat((String)("[" + i + "]getId"), (Object)actualNameRecord.getId(), (Matcher)Matchers.is((Object)expectedNameRecord.getId()));
                Assert.assertThat((String)("[" + i + "]getLongId"), (Object)actualNameRecord.getLongId(), (Matcher)Matchers.is((Object)expectedNameRecord.getLongId()));
                Assert.assertThat((String)("[" + i + "]isLight"), (Object)actualNameRecord.isLight(), (Matcher)Matchers.is((Object)expectedNameRecord.isLight()));
                Assert.assertThat((String)("[" + i + "]isStartRecord"), (Object)actualNameRecord.isStartRecord(), (Matcher)Matchers.is((Object)expectedNameRecord.isStartRecord()));
                Assert.assertThat((String)("[" + i + "]inUse"), (Object)actualNameRecord.inUse(), (Matcher)Matchers.is((Object)expectedNameRecord.inUse()));
                ++i;
            }
        }
    }

    public static class RelationshipStoreConsistentReadTest
    extends RecordStoreConsistentReadTest<RelationshipRecord, RelationshipStore> {
        private static final int FIRST_NODE = 2;
        private static final int SECOND_NODE = 3;
        private static final int TYPE = 4;
        private static final int FIRST_PREV_REL = 5;
        private static final int FIRST_NEXT_REL = 6;
        private static final int SECOND_PREV_REL = 7;
        private static final int SECOND_NEXT_REL = 8;

        @Override
        protected RelationshipRecord createNullRecord(long id) {
            RelationshipRecord record = new RelationshipRecord(id, false, 0L, 0L, 0, 0L, 0L, 0L, 0L, false, false);
            record.setNextProp(0L);
            return record;
        }

        @Override
        protected RelationshipRecord createExistingRecord(boolean forced, boolean light) {
            return new RelationshipRecord(1L, true, 2L, 3L, 4, 5L, 6L, 7L, 8L, true, true);
        }

        @Override
        protected RelationshipRecord getLight(long id, RelationshipStore store) {
            return store.getLightRel(id);
        }

        @Override
        protected void assertRecordsEqual(RelationshipRecord actualRecord, RelationshipRecord expectedRecord) {
            Assert.assertNotNull((String)"actualRecord", (Object)actualRecord);
            Assert.assertNotNull((String)"expectedRecord", (Object)expectedRecord);
            Assert.assertThat((String)"getFirstNextRel", (Object)actualRecord.getFirstNextRel(), (Matcher)Matchers.is((Object)expectedRecord.getFirstNextRel()));
            Assert.assertThat((String)"getFirstNode", (Object)actualRecord.getFirstNode(), (Matcher)Matchers.is((Object)expectedRecord.getFirstNode()));
            Assert.assertThat((String)"getFirstPrevRel", (Object)actualRecord.getFirstPrevRel(), (Matcher)Matchers.is((Object)expectedRecord.getFirstPrevRel()));
            Assert.assertThat((String)"getSecondNextRel", (Object)actualRecord.getSecondNextRel(), (Matcher)Matchers.is((Object)expectedRecord.getSecondNextRel()));
            Assert.assertThat((String)"getSecondNode", (Object)actualRecord.getSecondNode(), (Matcher)Matchers.is((Object)expectedRecord.getSecondNode()));
            Assert.assertThat((String)"getSecondPrevRel", (Object)actualRecord.getSecondPrevRel(), (Matcher)Matchers.is((Object)expectedRecord.getSecondPrevRel()));
            Assert.assertThat((String)"getType", (Object)actualRecord.getType(), (Matcher)Matchers.is((Object)expectedRecord.getType()));
            Assert.assertThat((String)"isFirstInFirstChain", (Object)actualRecord.isFirstInFirstChain(), (Matcher)Matchers.is((Object)expectedRecord.isFirstInFirstChain()));
            Assert.assertThat((String)"isFirstInSecondChain", (Object)actualRecord.isFirstInSecondChain(), (Matcher)Matchers.is((Object)expectedRecord.isFirstInSecondChain()));
            Assert.assertThat((String)"getId", (Object)actualRecord.getId(), (Matcher)Matchers.is((Object)expectedRecord.getId()));
            Assert.assertThat((String)"getLongId", (Object)actualRecord.getLongId(), (Matcher)Matchers.is((Object)expectedRecord.getLongId()));
            Assert.assertThat((String)"getNextProp", (Object)actualRecord.getNextProp(), (Matcher)Matchers.is((Object)expectedRecord.getNextProp()));
            Assert.assertThat((String)"inUse", (Object)actualRecord.inUse(), (Matcher)Matchers.is((Object)expectedRecord.inUse()));
        }

        @Override
        protected RelationshipStore getStore(NeoStore neoStore) {
            return neoStore.getRelationshipStore();
        }
    }
}

