/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.PageCacheRule;

public class StoreFactoryTest {
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private StoreFactory storeFactory;
    private NeoStore neoStore;

    @Before
    public void setUp() {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        Map configParams = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.neo_store.name(), "graph.db/neostore"});
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)fs);
        this.storeFactory = new StoreFactory(new Config(configParams), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), pageCache, (FileSystemAbstraction)fs, StringLogger.DEV_NULL, new Monitors());
    }

    @After
    public void tearDown() {
        if (this.neoStore != null) {
            this.neoStore.close();
        }
    }

    @Test
    public void shouldHaveSameCreationTimeAndUpgradeTimeOnStartup() throws Exception {
        this.neoStore = this.storeFactory.createNeoStore();
        Assert.assertThat((Object)this.neoStore.getUpgradeTime(), (Matcher)CoreMatchers.equalTo((Object)this.neoStore.getCreationTime()));
    }

    @Test
    public void shouldHaveSameCommittedTransactionAndUpgradeTransactionOnStartup() throws Exception {
        this.neoStore = this.storeFactory.createNeoStore();
        Assert.assertArrayEquals((long[])this.neoStore.getUpgradeTransaction(), (long[])this.neoStore.getLastCommittedTransaction());
    }

    @Test
    public void shouldHaveSpecificCountsTrackerForReadOnlyDatabase() throws IOException {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)fs);
        StoreFactory readOnlyStoreFactory = new StoreFactory(new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.read_only.name(), "true", GraphDatabaseSettings.neo_store.name(), "/tmp/graph.db/"})), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), pageCache, (FileSystemAbstraction)fs, StringLogger.DEV_NULL, new Monitors());
        this.neoStore = readOnlyStoreFactory.createNeoStore();
        long lastClosedTransactionId = this.neoStore.getLastClosedTransactionId();
        Assert.assertEquals((long)-1L, (long)this.neoStore.getCounts().rotate(lastClosedTransactionId));
    }
}

