/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.UTF8;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreVersionTrailerUtil;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;

public class StoreVersionTrailerUtilTest {
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTest(this.getClass());
    private PageCache pageCache;
    private File neoStoreFile;

    @Before
    public void setUpNeoStore() throws Exception {
        File storeDir = this.dir.directory("storeDir");
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        config = StoreFactory.configForStoreDir((Config)config, (File)storeDir);
        Monitors monitors = new Monitors();
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get());
        StoreFactory sf = new StoreFactory(config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), this.pageCache, (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, monitors);
        sf.createNeoStore().close();
        this.neoStoreFile = new File(storeDir, "neostore");
    }

    @Test
    public void testGetTrailerOffset() throws Exception {
        long trailerOffset;
        String expectedTrailer = CommonAbstractStore.buildTypeDescriptorAndVersion((String)"NeoStore");
        try (PagedFile pagedFile = this.pageCache.map(this.neoStoreFile, this.pageCache.pageSize());){
            trailerOffset = StoreVersionTrailerUtil.getTrailerOffset((PagedFile)pagedFile, (String)expectedTrailer);
        }
        int expectedOffset = NeoStore.Position.values().length * 9;
        Assert.assertEquals((long)expectedOffset, (long)trailerOffset);
    }

    @Test
    public void testReadTrailer() throws Exception {
        String trailer;
        String expectedTrailer = CommonAbstractStore.buildTypeDescriptorAndVersion((String)"NeoStore");
        try (PagedFile pagedFile = this.pageCache.map(this.neoStoreFile, this.pageCache.pageSize());){
            trailer = StoreVersionTrailerUtil.readTrailer((PagedFile)pagedFile, (String)expectedTrailer);
        }
        Assert.assertEquals((Object)expectedTrailer, (Object)trailer);
    }

    @Test
    public void testWriteTrailer() throws Exception {
        String expectedTrailer = CommonAbstractStore.buildTypeDescriptorAndVersion((String)"NeoStore");
        byte[] encocdedTrailer = UTF8.encode((String)expectedTrailer);
        try (PagedFile pagedFile = this.pageCache.map(this.neoStoreFile, this.pageCache.pageSize());){
            long trailerOffset = StoreVersionTrailerUtil.getTrailerOffset((PagedFile)pagedFile, (String)expectedTrailer);
            StoreVersionTrailerUtil.writeTrailer((PagedFile)pagedFile, (byte[])new byte[encocdedTrailer.length], (long)trailerOffset);
            Assert.assertEquals((long)-1L, (long)StoreVersionTrailerUtil.getTrailerOffset((PagedFile)pagedFile, (String)expectedTrailer));
            StoreVersionTrailerUtil.writeTrailer((PagedFile)pagedFile, (byte[])encocdedTrailer, (long)trailerOffset);
            Assert.assertEquals((long)trailerOffset, (long)StoreVersionTrailerUtil.getTrailerOffset((PagedFile)pagedFile, (String)expectedTrailer));
        }
    }
}

