/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.primitive.FunctionFromPrimitiveLongLongToPrimitiveLong;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.CombiningIterable;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.kernel.impl.transaction.state.RelationshipChainLoader;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.RelIdArray;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.NeoStoreDataSourceRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestNeoStore {
    private PropertyStore pStore;
    private RelationshipTypeTokenStore rtStore;
    private NeoStoreDataSource ds;
    private File path;
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTestWithEphemeralFS((EphemeralFileSystemAbstraction)this.fs.get(), this.getClass());
    @Rule
    public NeoStoreDataSourceRule dsRule = new NeoStoreDataSourceRule();
    private PageCache pageCache;
    private byte txCount = 0;
    private KernelTransaction tx;
    private TransactionRecordState transaction;
    private StoreReadLayer storeLayer;
    private RelationshipChainLoader relationshipLoader;
    private PropertyLoader propertyLoader;

    private File file(String name) {
        return new File(this.path, name);
    }

    @Before
    public void setUpNeoStore() throws Exception {
        this.path = this.dir.directory("dir");
        Config config = StoreFactory.configForStoreDir((Config)new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class}), (File)this.path);
        Monitors monitors = new Monitors();
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get());
        StoreFactory sf = new StoreFactory(config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(), this.pageCache, (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, monitors);
        sf.createNeoStore().close();
    }

    private Token createDummyIndex(int id, String key) {
        MyPropertyKeyToken index = new MyPropertyKeyToken(key, id);
        MyPropertyKeyToken.add(index);
        return index;
    }

    private void initializeStores(Map<String, String> additionalConfig) throws IOException {
        this.ds = this.dsRule.getDataSource(this.dir, (FileSystemAbstraction)this.fs.get(), this.pageCache, additionalConfig);
        this.ds.init();
        this.ds.start();
        NeoStore neoStore = this.ds.evaluate();
        this.pStore = neoStore.getPropertyStore();
        this.rtStore = neoStore.getRelationshipTypeTokenStore();
        this.storeLayer = this.ds.getStoreLayer();
        this.relationshipLoader = new RelationshipChainLoader(neoStore);
        this.propertyLoader = new PropertyLoader(neoStore);
    }

    private void startTx() throws TransactionFailureException {
        this.txCount = (byte)(this.txCount + 1);
        this.tx = this.ds.getKernel().newTransaction();
        this.transaction = ((KernelTransactionImplementation)this.tx).getTransactionRecordState();
    }

    private void commitTx() throws TransactionFailureException {
        this.tx.success();
        this.tx.close();
    }

    @After
    public void tearDownNeoStore() {
        for (String file : new String[]{"neo", "neo.nodestore.db", "neo.nodestore.db.labels", "neo.propertystore.db", "neo.propertystore.db.index", "neo.propertystore.db.index.keys", "neo.propertystore.db.strings", "neo.propertystore.db.arrays", "neo.relationshipstore.db", "neo.relationshiptypestore.db", "neo.relationshiptypestore.db.names", "neo.schemastore.db"}) {
            this.fs.get().deleteFile(this.file(file));
            this.fs.get().deleteFile(this.file(file + ".id"));
        }
        File file = new File(".");
        for (File nioFile : this.fs.get().listFiles(file)) {
            if (!nioFile.getName().startsWith("neostore.transaction.db")) continue;
            this.fs.get().deleteFile(nioFile);
        }
    }

    private int index(String key) {
        Iterator<Token> itr = MyPropertyKeyToken.index(key).iterator();
        if (!itr.hasNext()) {
            int id = (int)this.nextId(PropertyKeyTokenRecord.class);
            this.createDummyIndex(id, key);
            this.transaction.createPropertyKeyToken(key, id);
            return id;
        }
        return itr.next().id();
    }

    private long nextId(Class<?> clazz) {
        NeoStore neoStore = this.ds.evaluate();
        if (clazz.equals(PropertyKeyTokenRecord.class)) {
            return neoStore.getPropertyKeyTokenStore().nextId();
        }
        if (clazz.equals(RelationshipType.class)) {
            return neoStore.getRelationshipTypeTokenStore().nextId();
        }
        if (clazz.equals(Node.class)) {
            return neoStore.getNodeStore().nextId();
        }
        if (clazz.equals(Relationship.class)) {
            return neoStore.getRelationshipStore().nextId();
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    @Test
    public void testCreateNeoStore() throws Exception {
        int i;
        this.initializeStores(MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        long node1 = this.nextId(Node.class);
        this.transaction.nodeCreate(node1);
        long node2 = this.nextId(Node.class);
        this.transaction.nodeCreate(node2);
        DefinedProperty n1prop1 = this.transaction.nodeAddProperty(node1, this.index("prop1"), (Object)"string1");
        DefinedProperty n1prop2 = this.transaction.nodeAddProperty(node1, this.index("prop2"), (Object)1);
        DefinedProperty n1prop3 = this.transaction.nodeAddProperty(node1, this.index("prop3"), (Object)true);
        DefinedProperty n2prop1 = this.transaction.nodeAddProperty(node2, this.index("prop1"), (Object)"string2");
        DefinedProperty n2prop2 = this.transaction.nodeAddProperty(node2, this.index("prop2"), (Object)2);
        DefinedProperty n2prop3 = this.transaction.nodeAddProperty(node2, this.index("prop3"), (Object)false);
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName1 = "relationshiptype1";
        this.transaction.createRelationshipTypeToken(typeName1, relType1);
        int relType2 = (int)this.nextId(RelationshipType.class);
        String typeName2 = "relationshiptype2";
        this.transaction.createRelationshipTypeToken(typeName2, relType2);
        long rel1 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel1, relType1, node1, node2);
        long rel2 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel2, relType2, node2, node1);
        DefinedProperty r1prop1 = this.transaction.relAddProperty(rel1, this.index("prop1"), (Object)"string1");
        DefinedProperty r1prop2 = this.transaction.relAddProperty(rel1, this.index("prop2"), (Object)1);
        DefinedProperty r1prop3 = this.transaction.relAddProperty(rel1, this.index("prop3"), (Object)true);
        DefinedProperty r2prop1 = this.transaction.relAddProperty(rel2, this.index("prop1"), (Object)"string2");
        DefinedProperty r2prop2 = this.transaction.relAddProperty(rel2, this.index("prop2"), (Object)2);
        DefinedProperty r2prop3 = this.transaction.relAddProperty(rel2, this.index("prop3"), (Object)false);
        this.commitTx();
        this.ds.stop();
        this.initializeStores(MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        this.validateNodeRel1(node1, n1prop1, n1prop2, n1prop3, rel1, rel2, relType1, relType2);
        this.validateNodeRel2(node2, n2prop1, n2prop2, n2prop3, rel1, rel2, relType1, relType2);
        this.validateRel1(rel1, r1prop1, r1prop2, r1prop3, node1, node2, relType1);
        this.validateRel2(rel2, r2prop1, r2prop2, r2prop3, node2, node1, relType2);
        this.validateRelTypes(relType1, relType2);
        this.validateRelTypes(relType1, relType2);
        this.commitTx();
        this.ds.stop();
        this.initializeStores(MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        this.deleteRel1(rel1, r1prop1, r1prop2, r1prop3, node1, node2, relType1);
        this.deleteRel2(rel2, r2prop1, r2prop2, r2prop3, node2, node1, relType2);
        this.deleteNode1(node1, n1prop1, n1prop2, n1prop3);
        this.deleteNode2(node2, n2prop1, n2prop2, n2prop3);
        this.commitTx();
        this.ds.stop();
        this.initializeStores(MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        Assert.assertFalse((boolean)this.storeLayer.nodeExists(node1));
        Assert.assertFalse((boolean)this.storeLayer.nodeExists(node2));
        this.testGetRels(new long[]{rel1, rel2});
        long[] nodeIds = new long[10];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeCreate(nodeIds[i]);
            this.transaction.nodeAddProperty(nodeIds[i], this.index("nisse"), (Object)new Integer(10 - i));
        }
        for (i = 0; i < 2; ++i) {
            long id = this.nextId(Relationship.class);
            this.transaction.relCreate(id, relType1, nodeIds[i], nodeIds[i + 1]);
            this.transaction.relDelete(id);
        }
        for (i = 0; i < 3; ++i) {
            MutableRelationshipLoadingPosition pos = this.getPosition(nodeIds[i]);
            for (RelationshipRecord rel : this.getMore(nodeIds[i], pos)) {
                this.transaction.relDelete(rel.getId());
            }
            this.transaction.nodeDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.stop();
    }

    private MutableRelationshipLoadingPosition getPosition(long node) {
        return new MutableRelationshipLoadingPosition(this.relationshipLoader.getRelationshipChainPosition(node));
    }

    private Iterable<RelationshipRecord> getMore(long node, MutableRelationshipLoadingPosition position) {
        Pair rels = this.relationshipLoader.getMoreRelationships(node, (RelationshipLoadingPosition)position, RelIdArray.DirectionWrapper.BOTH, new int[0]);
        ArrayList list = new ArrayList();
        for (Map.Entry entry : ((Map)rels.first()).entrySet()) {
            list.add(entry.getValue());
        }
        position.setActual((RelationshipLoadingPosition)rels.other());
        return new CombiningIterable(list);
    }

    private void validateNodeRel1(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long rel1, long rel2, int relType1, int relType2) throws IOException {
        Iterable<RelationshipRecord> relData;
        Assert.assertTrue((boolean)this.storeLayer.nodeExists(node));
        ArrayMap props = new ArrayMap();
        TransactionRecordState.PropertyReceiver receiver = this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props);
        this.propertyLoader.nodeLoadProperties(node, receiver);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string1", (Object)data.value());
                this.transaction.nodeChangeProperty(node, prop1.propertyKeyId(), (Object)"-string1");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)1, (Object)data.value());
                this.transaction.nodeChangeProperty(node, prop2.propertyKeyId(), (Object)new Integer(-1));
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.transaction.nodeChangeProperty(node, prop3.propertyKeyId(), (Object)false);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = 0;
        MutableRelationshipLoadingPosition pos = this.getPosition(node);
        while ((relData = this.getMore(node, pos)).iterator().hasNext()) {
            for (RelationshipRecord rel : relData) {
                if (rel.getId() == rel1) {
                    Assert.assertEquals((long)node, (long)rel.getFirstNode());
                    Assert.assertEquals((long)relType1, (long)rel.getType());
                } else if (rel.getId() == rel2) {
                    Assert.assertEquals((long)node, (long)rel.getSecondNode());
                    Assert.assertEquals((long)relType2, (long)rel.getType());
                } else {
                    throw new IOException();
                }
                ++count;
            }
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    private TransactionRecordState.PropertyReceiver newPropertyReceiver(final ArrayMap<Integer, Pair<DefinedProperty, Long>> props) {
        return new TransactionRecordState.PropertyReceiver(){

            public void receive(DefinedProperty property, long propertyRecordId) {
                props.put((Object)property.propertyKeyId(), (Object)Pair.of((Object)property, (Object)propertyRecordId));
            }
        };
    }

    private void validateNodeRel2(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long rel1, long rel2, int relType1, int relType2) throws IOException {
        Iterable<RelationshipRecord> relData;
        Assert.assertTrue((boolean)this.storeLayer.nodeExists(node));
        ArrayMap props = new ArrayMap();
        this.propertyLoader.nodeLoadProperties(node, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string2", (Object)data.value());
                this.transaction.nodeChangeProperty(node, prop1.propertyKeyId(), (Object)"-string2");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)2, (Object)data.value());
                this.transaction.nodeChangeProperty(node, prop2.propertyKeyId(), (Object)new Integer(-2));
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.transaction.nodeChangeProperty(node, prop3.propertyKeyId(), (Object)true);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = 0;
        MutableRelationshipLoadingPosition pos = this.getPosition(node);
        while ((relData = this.getMore(node, pos)).iterator().hasNext()) {
            for (RelationshipRecord rel : relData) {
                if (rel.getId() == rel1) {
                    Assert.assertEquals((long)node, (long)rel.getSecondNode());
                    Assert.assertEquals((long)relType1, (long)rel.getType());
                } else if (rel.getId() == rel2) {
                    Assert.assertEquals((long)node, (long)rel.getFirstNode());
                    Assert.assertEquals((long)relType2, (long)rel.getType());
                } else {
                    throw new IOException();
                }
                ++count;
            }
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    private void validateRel1(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.relLoadProperties(rel, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string1", (Object)data.value());
                this.transaction.relChangeProperty(rel, prop1.propertyKeyId(), (Object)"-string1");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)1, (Object)data.value());
                this.transaction.relChangeProperty(rel, prop2.propertyKeyId(), (Object)new Integer(-1));
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.transaction.relChangeProperty(rel, prop3.propertyKeyId(), (Object)false);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
    }

    private void assertRelationshipData(long rel, final long firstNode, final long secondNode, final int relType) {
        try {
            this.storeLayer.relationshipVisit(rel, (RelationshipVisitor)new RelationshipVisitor<RuntimeException>(){

                public void visit(long relId, int type, long startNode, long endNode) {
                    Assert.assertEquals((long)firstNode, (long)startNode);
                    Assert.assertEquals((long)secondNode, (long)endNode);
                    Assert.assertEquals((long)relType, (long)type);
                }
            });
        }
        catch (EntityNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void validateRel2(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.relLoadProperties(rel, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string2", (Object)data.value());
                this.transaction.relChangeProperty(rel, prop1.propertyKeyId(), (Object)"-string2");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)2, (Object)data.value());
                this.transaction.relChangeProperty(rel, prop2.propertyKeyId(), (Object)new Integer(-2));
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.transaction.relChangeProperty(rel, prop3.propertyKeyId(), (Object)true);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
    }

    private void validateRelTypes(int relType1, int relType2) throws IOException {
        Token data = this.rtStore.getToken(relType1);
        Assert.assertEquals((long)relType1, (long)data.id());
        Assert.assertEquals((Object)"relationshiptype1", (Object)data.name());
        data = this.rtStore.getToken(relType2);
        Assert.assertEquals((long)relType2, (long)data.id());
        Assert.assertEquals((Object)"relationshiptype2", (Object)data.name());
        Token[] allData = this.rtStore.getTokens(Integer.MAX_VALUE);
        Assert.assertEquals((long)2L, (long)allData.length);
        for (int i = 0; i < 2; ++i) {
            if (allData[i].id() == relType1) {
                Assert.assertEquals((long)relType1, (long)allData[i].id());
                Assert.assertEquals((Object)"relationshiptype1", (Object)allData[i].name());
                continue;
            }
            if (allData[i].id() == relType2) {
                Assert.assertEquals((long)relType2, (long)allData[i].id());
                Assert.assertEquals((Object)"relationshiptype2", (Object)allData[i].name());
                continue;
            }
            throw new IOException();
        }
    }

    private void deleteRel1(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.relLoadProperties(rel, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string1", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-1, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.transaction.relRemoveProperty(rel, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.propertyLoader.relLoadProperties(rel, (TransactionRecordState.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
        this.transaction.relDelete(rel);
        MutableRelationshipLoadingPosition firstPos = this.getPosition(firstNode);
        Iterator<RelationshipRecord> first = this.getMore(firstNode, firstPos).iterator();
        first.next();
        MutableRelationshipLoadingPosition secondPos = this.getPosition(secondNode);
        Iterator<RelationshipRecord> second = this.getMore(secondNode, secondPos).iterator();
        second.next();
        Assert.assertTrue((boolean)first.hasNext());
        Assert.assertTrue((boolean)second.hasNext());
    }

    private void deleteRel2(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.relLoadProperties(rel, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string2", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-2, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.transaction.relRemoveProperty(rel, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.propertyLoader.relLoadProperties(rel, (TransactionRecordState.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
        this.transaction.relDelete(rel);
        MutableRelationshipLoadingPosition firstPos = this.getPosition(firstNode);
        Iterator<RelationshipRecord> first = this.getMore(firstNode, firstPos).iterator();
        MutableRelationshipLoadingPosition secondPos = this.getPosition(secondNode);
        Iterator<RelationshipRecord> second = this.getMore(secondNode, secondPos).iterator();
        Assert.assertTrue((boolean)first.hasNext());
        Assert.assertTrue((boolean)second.hasNext());
    }

    private void deleteNode1(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.nodeLoadProperties(node, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string1", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-1, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.transaction.nodeRemoveProperty(node, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.propertyLoader.nodeLoadProperties(node, (TransactionRecordState.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        MutableRelationshipLoadingPosition pos = this.getPosition(node);
        Iterator<RelationshipRecord> rels = this.getMore(node, pos).iterator();
        Assert.assertTrue((boolean)rels.hasNext());
        this.transaction.nodeDelete(node);
    }

    private void deleteNode2(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.nodeLoadProperties(node, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string2", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-2, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.transaction.nodeRemoveProperty(node, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.propertyLoader.nodeLoadProperties(node, (TransactionRecordState.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        MutableRelationshipLoadingPosition pos = this.getPosition(node);
        Iterator<RelationshipRecord> rels = this.getMore(node, pos).iterator();
        Assert.assertTrue((boolean)rels.hasNext());
        this.transaction.nodeDelete(node);
    }

    private void testGetRels(long[] relIds) {
        for (long relId : relIds) {
            Assert.assertFalse((boolean)this.storeLayer.relationshipExists(relId));
        }
    }

    @Test
    public void testRels1() throws Exception {
        int i;
        this.initializeStores(MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName = "relationshiptype1";
        this.transaction.createRelationshipTypeToken(typeName, relType1);
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeCreate(nodeIds[i]);
            this.transaction.nodeAddProperty(nodeIds[i], this.index("nisse"), (Object)new Integer(10 - i));
        }
        for (i = 0; i < 2; ++i) {
            this.transaction.relCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; i += 2) {
            MutableRelationshipLoadingPosition pos = this.getPosition(nodeIds[i]);
            for (RelationshipRecord rel : this.getMore(nodeIds[i], pos)) {
                this.transaction.relDelete(rel.getId());
            }
            this.transaction.nodeDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.stop();
    }

    @Test
    @Ignore
    public void testRels2() throws Exception {
        int i;
        this.initializeStores(MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName = "relationshiptype1";
        this.transaction.createRelationshipTypeToken(typeName, relType1);
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeCreate(nodeIds[i]);
            this.transaction.nodeAddProperty(nodeIds[i], this.index("nisse"), (Object)new Integer(10 - i));
        }
        for (i = 0; i < 2; ++i) {
            this.transaction.relCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.transaction.relCreate(this.nextId(Relationship.class), relType1, nodeIds[0], nodeIds[2]);
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; ++i) {
            MutableRelationshipLoadingPosition pos = this.getPosition(nodeIds[i]);
            for (RelationshipRecord rel : this.getMore(nodeIds[i], pos)) {
                this.transaction.relDelete(rel.getId());
            }
            this.transaction.nodeDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testRels3() throws Exception {
        int i;
        this.initializeStores(MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        this.transaction.createRelationshipTypeToken("relationshiptype1", relType1);
        long[] nodeIds = new long[8];
        for (i = 0; i < nodeIds.length; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeCreate(nodeIds[i]);
        }
        for (i = 0; i < nodeIds.length / 2; ++i) {
            this.transaction.relCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i * 2]);
        }
        long rel5 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel5, relType1, nodeIds[0], nodeIds[5]);
        long rel2 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel2, relType1, nodeIds[1], nodeIds[2]);
        long rel3 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel3, relType1, nodeIds[1], nodeIds[3]);
        long rel6 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel6, relType1, nodeIds[1], nodeIds[6]);
        long rel1 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel1, relType1, nodeIds[0], nodeIds[1]);
        long rel4 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel4, relType1, nodeIds[0], nodeIds[4]);
        long rel7 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel7, relType1, nodeIds[0], nodeIds[7]);
        this.commitTx();
        this.startTx();
        this.transaction.relDelete(rel7);
        this.transaction.relDelete(rel4);
        this.transaction.relDelete(rel1);
        this.transaction.relDelete(rel6);
        this.transaction.relDelete(rel3);
        this.transaction.relDelete(rel2);
        this.transaction.relDelete(rel5);
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testProps1() throws Exception {
        this.initializeStores(MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        long nodeId = this.nextId(Node.class);
        this.transaction.nodeCreate(nodeId);
        this.pStore.nextId();
        DefinedProperty prop = this.transaction.nodeAddProperty(nodeId, this.index("nisse"), (Object)new Integer(10));
        this.commitTx();
        this.ds.stop();
        this.initializeStores(MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        this.transaction.nodeChangeProperty(nodeId, prop.propertyKeyId(), (Object)new Integer(5));
        this.transaction.nodeRemoveProperty(nodeId, prop.propertyKeyId());
        this.transaction.nodeDelete(nodeId);
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testSetBlockSize() throws Exception {
        this.initializeStores(MapUtil.stringMap((String[])new String[]{"string_block_size", "62", "array_block_size", "302"}));
        Assert.assertEquals((long)70L, (long)this.pStore.getStringBlockSize());
        Assert.assertEquals((long)310L, (long)this.pStore.getArrayBlockSize());
        this.ds.stop();
    }

    @Test
    public void setVersion() throws Exception {
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        File storeDir = new File("target/test-data/set-version");
        new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)fileSystem).newImpermanentDatabase(storeDir.getAbsolutePath()).shutdown();
        Assert.assertEquals((long)1L, (long)NeoStore.setRecord((FileSystemAbstraction)fileSystem, (File)new File(storeDir, "neostore").getAbsoluteFile(), (NeoStore.Position)NeoStore.Position.LOG_VERSION, (long)10L));
        Assert.assertEquals((long)10L, (long)NeoStore.setRecord((FileSystemAbstraction)fileSystem, (File)new File(storeDir, "neostore").getAbsoluteFile(), (NeoStore.Position)NeoStore.Position.LOG_VERSION, (long)12L));
        Monitors monitors = new Monitors();
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(StoreFactory.configForStoreDir((Config)config, (File)storeDir), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), this.pageCache, (FileSystemAbstraction)fileSystem, StringLogger.DEV_NULL, monitors);
        NeoStore neoStore = sf.newNeoStore(false);
        Assert.assertEquals((long)12L, (long)neoStore.getCurrentLogVersion());
        neoStore.close();
    }

    @Test
    public void testSetLatestConstraintTx() throws Exception {
        Monitors monitors = new Monitors();
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(StoreFactory.configForStoreDir((Config)config, (File)this.dir.directory()), (IdGeneratorFactory)new DefaultIdGeneratorFactory(), this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get()), (FileSystemAbstraction)this.fs.get(), StringLogger.DEV_NULL, monitors);
        NeoStore neoStore = sf.newNeoStore(true);
        Assert.assertEquals((long)0L, (long)neoStore.getLatestConstraintIntroducingTx());
        neoStore.setLatestConstraintIntroducingTx(10L);
        Assert.assertEquals((long)10L, (long)neoStore.getLatestConstraintIntroducingTx());
        neoStore.flush();
        neoStore.close();
        neoStore = sf.newNeoStore(false);
        Assert.assertEquals((long)10L, (long)neoStore.getLatestConstraintIntroducingTx());
        neoStore.close();
    }

    @Test
    public void shouldInitializeTheTxIdToOne() {
        StoreFactory factory = new StoreFactory((FileSystemAbstraction)this.fs.get(), new File("graph.db/neostore"), this.pageCache, StringLogger.DEV_NULL, new Monitors());
        NeoStore neoStore = factory.newNeoStore(true);
        neoStore.close();
        neoStore = factory.newNeoStore(false);
        long lastCommittedTransactionId = neoStore.getLastCommittedTransactionId();
        neoStore.close();
        Assert.assertEquals((long)1L, (long)lastCommittedTransactionId);
    }

    @Test
    public void shouldAddUpgradeFieldsToTheNeoStoreIfNotPresent() throws IOException {
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        File neoStoreDir = new File("/tmp/graph.db/neostore").getAbsoluteFile();
        StoreFactory factory = new StoreFactory((FileSystemAbstraction)fileSystem, neoStoreDir, this.pageCache, StringLogger.DEV_NULL, new Monitors());
        NeoStore neoStore = factory.newNeoStore(true);
        neoStore.setCreationTime(3L);
        neoStore.setRandomNumber(4L);
        neoStore.setCurrentLogVersion(5L);
        neoStore.setLastCommittedAndClosedTransactionId(6L, 0L);
        neoStore.setStoreVersion(7L);
        neoStore.setGraphNextProp(8L);
        neoStore.setLatestConstraintIntroducingTx(9L);
        neoStore.rebuildCountStoreIfNeeded();
        neoStore.flush();
        neoStore.close();
        File file = new File(neoStoreDir, "neostore");
        try (StoreChannel channel = fileSystem.open(file, "rw");){
            byte[] trailer = UTF8.encode((String)CommonAbstractStore.buildTypeDescriptorAndVersion((String)neoStore.getTypeDescriptor()));
            channel.truncate(channel.size() - 18L);
            channel.position(channel.size() - (long)trailer.length);
            channel.write(ByteBuffer.wrap(trailer));
        }
        Assert.assertNotEquals((long)10L, (long)neoStore.getUpgradeTransaction()[0]);
        Assert.assertNotEquals((long)11L, (long)neoStore.getUpgradeTime());
        NeoStore.setRecord((FileSystemAbstraction)fileSystem, (File)file, (NeoStore.Position)NeoStore.Position.UPGRADE_TRANSACTION_ID, (long)10L);
        NeoStore.setRecord((FileSystemAbstraction)fileSystem, (File)file, (NeoStore.Position)NeoStore.Position.UPGRADE_TRANSACTION_CHECKSUM, (long)11L);
        NeoStore.setRecord((FileSystemAbstraction)fileSystem, (File)file, (NeoStore.Position)NeoStore.Position.UPGRADE_TIME, (long)12L);
        neoStore = factory.newNeoStore(false);
        Assert.assertEquals((long)3L, (long)neoStore.getCreationTime());
        Assert.assertEquals((long)4L, (long)neoStore.getRandomNumber());
        Assert.assertEquals((long)5L, (long)neoStore.getCurrentLogVersion());
        Assert.assertEquals((long)6L, (long)neoStore.getLastCommittedTransactionId());
        Assert.assertEquals((long)7L, (long)neoStore.getStoreVersion());
        Assert.assertEquals((long)8L, (long)neoStore.getGraphNextProp());
        Assert.assertEquals((long)9L, (long)neoStore.getLatestConstraintIntroducingTx());
        Assert.assertArrayEquals((long[])new long[]{10L, 11L}, (long[])neoStore.getUpgradeTransaction());
        Assert.assertEquals((long)12L, (long)neoStore.getUpgradeTime());
        neoStore.close();
    }

    private static class CountingPropertyReceiver
    implements TransactionRecordState.PropertyReceiver {
        private int count;

        private CountingPropertyReceiver() {
        }

        public void receive(DefinedProperty property, long propertyRecordId) {
            ++this.count;
        }
    }

    private static class MutableRelationshipLoadingPosition
    implements RelationshipLoadingPosition {
        private RelationshipLoadingPosition actual;

        MutableRelationshipLoadingPosition(RelationshipLoadingPosition actual) {
            this.actual = actual;
        }

        void setActual(RelationshipLoadingPosition actual) {
            this.actual = actual;
        }

        public long position(RelIdArray.DirectionWrapper direction, int[] types) {
            return this.actual.position(direction, types);
        }

        public long nextPosition(long position, RelIdArray.DirectionWrapper direction, int[] types) {
            return this.actual.nextPosition(position, direction, types);
        }

        public boolean hasMore(RelIdArray.DirectionWrapper direction, int[] types) {
            return this.actual.hasMore(direction, types);
        }

        public boolean atPosition(RelIdArray.DirectionWrapper direction, int type, long position) {
            return this.actual.atPosition(direction, type, position);
        }

        public void patchPosition(long nodeId, FunctionFromPrimitiveLongLongToPrimitiveLong<RuntimeException> next) {
            this.actual.patchPosition(nodeId, next);
        }

        public RelationshipLoadingPosition clone() {
            return new MutableRelationshipLoadingPosition(this.actual.clone());
        }
    }

    private static class MyPropertyKeyToken
    extends Token {
        private static Map<String, Token> stringToIndex = new HashMap<String, Token>();
        private static Map<Integer, Token> intToIndex = new HashMap<Integer, Token>();

        protected MyPropertyKeyToken(String key, int keyId) {
            super(key, keyId);
        }

        public static Iterable<Token> index(String key) {
            if (stringToIndex.containsKey(key)) {
                return Arrays.asList(stringToIndex.get(key));
            }
            return Collections.emptyList();
        }

        public static Token getIndexFor(int index) {
            return intToIndex.get(index);
        }

        public static void add(MyPropertyKeyToken index) {
            stringToIndex.put(index.name(), index);
            intToIndex.put(index.id(), index);
        }
    }
}

