/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.format.TestCursor;
import org.neo4j.kernel.impl.store.format.TestRecord;
import org.neo4j.kernel.impl.store.format.TestRecordFormat;
import org.neo4j.kernel.impl.store.standard.StoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreToolkit;

public class TestFormatWithHeader
implements StoreFormat<TestRecord, TestCursor> {
    private final int configuredRecordSize;
    private final TestRecordFormat recordFormat;

    public TestFormatWithHeader(int configuredRecordSize) {
        this.configuredRecordSize = configuredRecordSize;
        this.recordFormat = new TestRecordFormat();
    }

    public TestCursor createCursor(PagedFile file, StoreToolkit toolkit, int flags) {
        return new TestCursor(file, toolkit, this.recordFormat, flags);
    }

    public StoreFormat.RecordFormat<TestRecord> recordFormat() {
        return this.recordFormat;
    }

    public int recordSize(StoreChannel channel) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4);
        channel.read(buf, 0L);
        buf.flip();
        return buf.getInt();
    }

    public void createStore(StoreChannel channel) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(this.configuredRecordSize);
        buf.flip();
        channel.write(buf, 0L);
    }

    public int headerSize() {
        return 4;
    }

    public String version() {
        return "v0.1.0";
    }

    public String type() {
        return "MyFormatWithHeader";
    }
}

