/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.v2_2;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.store.format.v2_2.NodeStoreFormat_v2_2;
import org.neo4j.kernel.impl.store.format.v2_2.RecordFormatTest;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class NodeFormatTest
extends RecordFormatTest<NodeStoreFormat_v2_2, NodeRecord, NodeStoreFormat_v2_2.NodeRecordCursor> {
    public NodeFormatTest() {
        super(new NodeStoreFormat_v2_2());
    }

    @Test
    public void testDirectRecordSerialization() throws Exception {
        this.assertSerializes(new NodeRecord(12L, false, false, 0L, 0L, 0L));
        this.assertSerializes(new NodeRecord(12L, true, false, 13L, 14L, 1337L));
        this.assertSerializes(new NodeRecord(12L, true, true, 13L, 14L, 1337L));
        this.assertSerializes(new NodeRecord(12L, true, true, 13L, 14L, 0L));
        this.assertSerializes(new NodeRecord(12L, true, false, IdType.RELATIONSHIP.getMaxValue(), IdType.PROPERTY.getMaxValue(), IdType.LABEL_TOKEN.getMaxValue()));
        this.assertSerializes(new NodeRecord(12L, true, true, IdType.RELATIONSHIP.getMaxValue(), IdType.PROPERTY.getMaxValue(), 0x8000000000L));
    }

    @Test
    public void testCursorFieldReading() throws Exception {
        String reuseToString;
        boolean inUse;
        long firstRelationship;
        long recordId;
        NodeStoreFormat_v2_2.NodeRecordCursor cursor = ((NodeStoreFormat_v2_2)this.format).createCursor(this.pagedFile, this.storeToolkit, 0);
        NodeRecord record = new NodeRecord(12L, true, true, 1L, 2L, 3L);
        this.writeToPagedFile(record);
        cursor.position(12L);
        do {
            recordId = cursor.recordId();
            firstRelationship = cursor.firstRelationship();
            inUse = cursor.inUse();
            reuseToString = ((NodeRecord)cursor.reusedRecord()).toString();
        } while (cursor.shouldRetry());
        Assert.assertThat((Object)recordId, (Matcher)CoreMatchers.equalTo((Object)12L));
        Assert.assertThat((Object)firstRelationship, (Matcher)CoreMatchers.equalTo((Object)1L));
        Assert.assertThat((Object)inUse, (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)reuseToString, (Matcher)CoreMatchers.equalTo((Object)record.toString()));
    }
}

