/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.v2_2;

import java.io.File;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.format.v2_2.RelationshipGroupStoreFormat_v2_2;
import org.neo4j.kernel.impl.store.impl.StoreMatchers;
import org.neo4j.kernel.impl.store.impl.TestStoreIdGenerator;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.standard.StandardStore;
import org.neo4j.kernel.impl.store.standard.StoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreIdGenerator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class RelationshipGroupFormatComplianceTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    private StoreFactory storeFactory;
    private final File storeDir = new File("dir").getAbsoluteFile();
    private PageCache pageCache;

    @Before
    public void setup() {
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fsRule.get());
        Config config = StoreFactory.configForStoreDir((Config)new Config(), (File)this.storeDir);
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory();
        this.storeFactory = new StoreFactory(config, (IdGeneratorFactory)idGeneratorFactory, this.pageCache, (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL, new Monitors());
    }

    @Test
    public void readsRecords() throws Throwable {
        NeoStore neoStore = this.storeFactory.createNeoStore();
        RelationshipGroupStore groupStore = neoStore.getRelationshipGroupStore();
        RelationshipGroupRecord expectedRecord = new RelationshipGroupRecord(groupStore.nextId(), 12, 13L, 14L, 15L, 16L, true);
        groupStore.updateRecord(expectedRecord);
        neoStore.close();
        StandardStore<RelationshipGroupRecord, RelationshipGroupStoreFormat_v2_2.RelationshipGroupRecordCursor> store = this.newStore();
        store.init();
        store.start();
        Assert.assertThat(StoreMatchers.records(store), (Matcher)CoreMatchers.equalTo(Arrays.asList(expectedRecord)));
        store.stop();
        store.shutdown();
    }

    @Test
    public void writesRecords() throws Throwable {
        this.storeFactory.createNeoStore().close();
        StandardStore<RelationshipGroupRecord, RelationshipGroupStoreFormat_v2_2.RelationshipGroupRecordCursor> store = this.newStore();
        store.init();
        store.start();
        RelationshipGroupRecord expectedRecord = new RelationshipGroupRecord(store.allocate(), 12, 13L, 14L, 15L, 16L, true);
        store.write((Object)expectedRecord);
        store.stop();
        store.shutdown();
        RelationshipGroupStore legacyStore = this.storeFactory.newRelationshipGroupStore();
        RelationshipGroupRecord record = legacyStore.getRecord(expectedRecord.getId());
        Assert.assertThat((Object)record, (Matcher)CoreMatchers.equalTo((Object)expectedRecord));
        legacyStore.close();
    }

    private StandardStore<RelationshipGroupRecord, RelationshipGroupStoreFormat_v2_2.RelationshipGroupRecordCursor> newStore() {
        return new StandardStore((StoreFormat)new RelationshipGroupStoreFormat_v2_2(), new File(this.storeDir, "neostore.relationshipgroupstore.db"), (StoreIdGenerator)new TestStoreIdGenerator(), this.pageCache, (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL);
    }
}

