/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.impl;

import java.io.File;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.store.impl.TestStoreIdGenerator;
import org.neo4j.kernel.impl.store.impl.VersionedStoreFormat;
import org.neo4j.kernel.impl.store.standard.StandardStore;
import org.neo4j.kernel.impl.store.standard.StoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreIdGenerator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class StandardStoreVersioningTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    private PageCache pageCache;

    @Before
    public void setup() {
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fsRule.get());
    }

    @Test
    public void shouldThrowExceptionOnMismatchingVersion() throws Throwable {
        StandardStore onePointOhStore = new StandardStore((StoreFormat)new VersionedStoreFormat("v0.1.0"), new File("/store"), (StoreIdGenerator)new TestStoreIdGenerator(), this.pageCache, (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL);
        StandardStore twoPointOhStore = new StandardStore((StoreFormat)new VersionedStoreFormat("v0.2.0"), new File("/store"), (StoreIdGenerator)new TestStoreIdGenerator(), this.pageCache, (FileSystemAbstraction)this.fsRule.get(), StringLogger.DEV_NULL);
        onePointOhStore.start();
        onePointOhStore.stop();
        try {
            twoPointOhStore.start();
            TestCase.fail((String)"Should not have opened this store.");
        }
        catch (NotCurrentStoreVersionException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Was expecting store version [VersionedStoreFormat v0.2.0] but found [VersionedStoreFormat v0.1.0]. Store cannot be upgraded automatically. "));
        }
    }
}

