/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.function.IOFunction;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.kvstore.AbstractKeyValueStore;
import org.neo4j.kernel.impl.store.kvstore.DataInitializer;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.EntryUpdater;
import org.neo4j.kernel.impl.store.kvstore.HeaderField;
import org.neo4j.kernel.impl.store.kvstore.Headers;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.PreparedRotation;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.Resources;
import org.neo4j.kernel.impl.store.kvstore.Rotation;
import org.neo4j.kernel.impl.store.kvstore.RotationStrategy;
import org.neo4j.kernel.impl.store.kvstore.RotationTimeoutException;
import org.neo4j.kernel.impl.store.kvstore.RotationTimerFactory;
import org.neo4j.kernel.impl.store.kvstore.ValueUpdate;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.test.ThreadingRule;

public class AbstractKeyValueStoreTest {
    @Rule
    public final Resources the = new Resources(Resources.TestPath.FILE_IN_EXISTING_DIRECTORY);
    @Rule
    public final ThreadingRule threading = new ThreadingRule();
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private static final HeaderField<Long> TX_ID = new HeaderField<Long>(){

        public Long read(ReadableBuffer header) {
            return header.getLong(header.size() - 8);
        }

        public void write(Long value, WritableBuffer header) {
            header.putLong(header.size() - 8, value.longValue());
        }

        public String toString() {
            return "txId";
        }
    };

    @Test
    public void shouldStartAndStopStore() throws Exception {
        this.the.managed(new Store(new HeaderField[0]));
        this.the.lifeStarts();
        this.the.lifeShutsDown();
    }

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void shouldRotateStore() throws Exception {
        Store store = this.the.managed(new Store(new HeaderField[0]));
        store.prepareRotation(0L).rotate();
    }

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void shouldStoreEntries() throws Exception {
        Store store = this.the.managed(new Store(new HeaderField[0]));
        store.put("message", "hello world");
        store.put("age", "too old");
        Assert.assertEquals((Object)"hello world", (Object)store.get("message"));
        Assert.assertEquals((Object)"too old", (Object)store.get("age"));
        store.prepareRotation(0L).rotate();
        Assert.assertEquals((Object)"hello world", (Object)store.get("message"));
        Assert.assertEquals((Object)"too old", (Object)store.get("age"));
    }

    @Test
    public void shouldPickFileWithGreatestTransactionId() throws Exception {
        class Impl
        extends Store {
            Impl() {
                super(new HeaderField[]{TX_ID});
            }

            @Override
            <Value> Value initialHeader(HeaderField<Value> field) {
                if (field == TX_ID) {
                    return (Value)Long.valueOf(1L);
                }
                return super.initialHeader(field);
            }

            @Override
            protected int compareHeaders(Headers lhs, Headers rhs) {
                return Long.compare((Long)lhs.get(TX_ID), (Long)rhs.get(TX_ID));
            }

            @Override
            protected long version(Headers headers) {
                return (Long)headers.get(TX_ID);
            }

            @Override
            protected void updateHeaders(Headers.Builder headers, long version) {
                headers.put(TX_ID, (Object)version);
            }
        }
        Store store;
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            store = (Store)((Object)life.add((Object)new Impl()));
            for (long txId = 2L; txId <= 10L; ++txId) {
                ((EntryUpdater)store.updater(txId).get()).close();
                store.prepareRotation(txId).rotate();
            }
        }
        life = new Lifespan(new Lifecycle[0]);
        var2_2 = null;
        try {
            store = (Store)((Object)life.add((Object)new Impl()));
            Assert.assertEquals((long)10L, (long)((Long)store.headers().get(TX_ID)));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (life != null) {
                if (var2_2 != null) {
                    try {
                        life.close();
                    }
                    catch (Throwable x2) {
                        var2_2.addSuppressed(x2);
                    }
                } else {
                    life.close();
                }
            }
        }
    }

    @Test
    public void shouldNotPickCorruptStoreFile() throws Exception {
        ByteBuffer value;
        Store store = new Store(new HeaderField[]{TX_ID}){

            @Override
            <Value> Value initialHeader(HeaderField<Value> field) {
                if (field == TX_ID) {
                    return (Value)Long.valueOf(1L);
                }
                return super.initialHeader(field);
            }

            @Override
            protected int compareHeaders(Headers lhs, Headers rhs) {
                return Long.compare((Long)lhs.get(TX_ID), (Long)rhs.get(TX_ID));
            }
        };
        RotationStrategy rotation = store.rotationStrategy;
        File[] files = new File[10];
        Pair file = rotation.create(DataProvider.EMPTY_DATA_PROVIDER, 1L);
        files[0] = (File)file.first();
        int txId = 2;
        for (int i = 1; i < files.length; ++i) {
            KeyValueStoreFile old = (KeyValueStoreFile)file.other();
            final int data = txId;
            file = rotation.next((File)file.first(), Headers.headersBuilder().put(TX_ID, (Object)txId).headers(), AbstractKeyValueStoreTest.data(new Entry(){

                @Override
                public void write(WritableBuffer key, WritableBuffer value) {
                    key.putByte(0, (byte)102);
                    key.putByte(1, (byte)111);
                    key.putByte(2, (byte)111);
                    value.putInt(0, data);
                }
            }));
            old.close();
            files[i] = (File)file.first();
            txId <<= 1;
        }
        ((KeyValueStoreFile)file.other()).close();
        try (StoreChannel channel = this.the.fileSystem().open(files[9], "rw");){
            channel.position(16L);
            value = ByteBuffer.allocate(16);
            value.put((byte)0);
            value.flip();
            channel.writeAll(value);
        }
        channel = this.the.fileSystem().open(files[8], "rw");
        var5_6 = null;
        try {
            channel.position(32L);
            value = ByteBuffer.allocate(16);
            value.put((byte)17);
            value.flip();
            channel.writeAll(value);
        }
        catch (Throwable x2) {
            var5_6 = x2;
            throw x2;
        }
        finally {
            if (channel != null) {
                if (var5_6 != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable x2) {
                        var5_6.addSuppressed(x2);
                    }
                } else {
                    channel.close();
                }
            }
        }
        channel = this.the.fileSystem().open(files[7], "rw");
        var5_6 = null;
        try {
            channel.position(112L);
            value = ByteBuffer.allocate(16);
            value.putLong(0L);
            value.putLong(0L);
            value.flip();
            channel.writeAll(value);
        }
        catch (Throwable x2) {
            var5_6 = x2;
            throw x2;
        }
        finally {
            if (channel != null) {
                if (var5_6 != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable x2) {
                        var5_6.addSuppressed(x2);
                    }
                } else {
                    channel.close();
                }
            }
        }
        var5_6 = null;
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            life.add((Object)store);
            Assert.assertEquals((long)64L, (long)((Long)store.headers().get(TX_ID)));
        }
        catch (Throwable throwable) {
            var5_6 = throwable;
            throw throwable;
        }
    }

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void shouldRotateWithCorrectVersion() throws Exception {
        final Store store = this.the.managed(new Store(new HeaderField[]{TX_ID}){

            @Override
            <Value> Value initialHeader(HeaderField<Value> field) {
                if (field == TX_ID) {
                    return (Value)Long.valueOf(1L);
                }
                return super.initialHeader(field);
            }

            @Override
            protected void updateHeaders(Headers.Builder headers, long version) {
                headers.put(TX_ID, (Object)version);
            }

            @Override
            protected int compareHeaders(Headers lhs, Headers rhs) {
                return Long.compare((Long)lhs.get(TX_ID), (Long)rhs.get(TX_ID));
            }
        });
        IOFunction<Long, Void> update = new IOFunction<Long, Void>(){

            public Void apply(Long update) throws IOException {
                try (EntryUpdater updater = (EntryUpdater)store.updater(update).get();){
                    updater.apply((Object)("key " + update), store.value("value " + update));
                }
                return null;
            }
        };
        update.apply((Object)1L);
        PreparedRotation rotation = store.prepareRotation(2L);
        update.apply((Object)2L);
        rotation.rotate();
        Assert.assertEquals((long)2L, (long)((Long)store.headers().get(TX_ID)));
        store.prepareRotation(2L).rotate();
    }

    @Test
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void shouldBlockRotationUntilRequestedTransactionsAreApplied() throws Exception {
        final Store store = this.the.managed(new Store(new HeaderField[]{TX_ID}){

            @Override
            <Value> Value initialHeader(HeaderField<Value> field) {
                if (field == TX_ID) {
                    return (Value)Long.valueOf(1L);
                }
                return super.initialHeader(field);
            }

            @Override
            protected void updateHeaders(Headers.Builder headers, long version) {
                headers.put(TX_ID, (Object)version);
            }

            @Override
            protected int compareHeaders(Headers lhs, Headers rhs) {
                return Long.compare((Long)lhs.get(TX_ID), (Long)rhs.get(TX_ID));
            }
        });
        IOFunction<Long, Void> update = new IOFunction<Long, Void>(){

            public Void apply(Long update) throws IOException {
                try (EntryUpdater updater = (EntryUpdater)store.updater(update).get();){
                    updater.apply((Object)("key " + update), store.value("value " + update));
                }
                return null;
            }
        };
        update.apply((Object)1L);
        Future rotation = this.threading.executeAndAwait(store.rotation, 3L, new Predicate<Thread>(){

            public boolean accept(Thread thread) {
                switch (thread.getState()) {
                    case BLOCKED: 
                    case WAITING: 
                    case TIMED_WAITING: 
                    case TERMINATED: {
                        return true;
                    }
                }
                return false;
            }
        }, 100L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)rotation.isDone());
        TimeUnit.SECONDS.sleep(1L);
        Assert.assertFalse((boolean)rotation.isDone());
        update.apply((Object)3L);
        Assert.assertFalse((boolean)rotation.isDone());
        TimeUnit.SECONDS.sleep(1L);
        Assert.assertFalse((boolean)rotation.isDone());
        update.apply((Object)4L);
        Assert.assertFalse((boolean)rotation.isDone());
        TimeUnit.SECONDS.sleep(1L);
        Assert.assertFalse((boolean)rotation.isDone());
        update.apply((Object)2L);
        Assert.assertEquals((long)3L, (long)((Long)rotation.get()));
        Assert.assertEquals((long)3L, (long)((Long)store.headers().get(TX_ID)));
        store.rotation.apply((Object)4L);
    }

    @Test(timeout=2000L)
    @Resources.Life(value=Resources.InitialLifecycle.STARTED)
    public void shouldFailRotationAfterTimeout() throws IOException {
        Store store = this.the.managed(new Store(0L, new HeaderField[]{TX_ID}){

            @Override
            <Value> Value initialHeader(HeaderField<Value> field) {
                if (field == TX_ID) {
                    return (Value)Long.valueOf(1L);
                }
                return super.initialHeader(field);
            }

            @Override
            protected void updateHeaders(Headers.Builder headers, long version) {
                headers.put(TX_ID, (Object)version);
            }

            @Override
            protected int compareHeaders(Headers lhs, Headers rhs) {
                return Long.compare((Long)lhs.get(TX_ID), (Long)rhs.get(TX_ID));
            }
        });
        this.expectedException.expect(RotationTimeoutException.class);
        store.prepareRotation(10L).rotate();
    }

    static DataProvider data(final Entry ... data) {
        return new DataProvider(){
            int i;

            public boolean visit(WritableBuffer key, WritableBuffer value) throws IOException {
                if (this.i < data.length) {
                    data[this.i++].write(key, value);
                    return true;
                }
                return false;
            }

            public void close() throws IOException {
            }
        };
    }

    @Rotation(value=Rotation.Strategy.INCREMENTING)
    class Store
    extends AbstractKeyValueStore<String> {
        private final HeaderField<?>[] headerFields;
        final IOFunction<Long, Long> rotation;

        private Store(HeaderField<?> ... headerFields) {
            this(TimeUnit.MINUTES.toMillis(10L), headerFields);
        }

        private Store(long rotationTimeout, HeaderField<?> ... headerFields) {
            super(AbstractKeyValueStoreTest.this.the.fileSystem(), AbstractKeyValueStoreTest.this.the.pageCache(), AbstractKeyValueStoreTest.this.the.testPath(), null, new RotationTimerFactory(Clock.SYSTEM_CLOCK, rotationTimeout), 16, 16, headerFields);
            this.rotation = new IOFunction<Long, Long>(){

                public Long apply(Long version) throws IOException {
                    return Store.this.prepareRotation(version).rotate();
                }
            };
            this.headerFields = headerFields;
            this.setEntryUpdaterInitializer((DataInitializer)new DataInitializer<EntryUpdater<String>>(){

                public void initialize(EntryUpdater<String> stringEntryUpdater) {
                }

                public long initialVersion() {
                    return 0L;
                }
            });
        }

        protected Headers initialHeaders(long version) {
            Headers.Builder builder = Headers.headersBuilder();
            for (HeaderField<?> field : this.headerFields) {
                this.putHeader(builder, field);
            }
            return builder.headers();
        }

        private <Value> void putHeader(Headers.Builder builder, HeaderField<Value> field) {
            builder.put(field, this.initialHeader(field));
        }

        <Value> Value initialHeader(HeaderField<Value> field) {
            return null;
        }

        protected int compareHeaders(Headers lhs, Headers rhs) {
            return 0;
        }

        private <Value> void putField(Headers.Builder builder, HeaderField<Value> field, Object change) {
            builder.put(field, change);
        }

        protected void writeKey(String key, WritableBuffer buffer) {
            for (int i = 0; i < key.length(); ++i) {
                char c = key.charAt(i);
                if (c == '\u0000' || c >= '\u0080') {
                    throw new IllegalArgumentException("Only ASCII keys allowed.");
                }
                buffer.putByte(i, (byte)c);
            }
        }

        protected String readKey(ReadableBuffer key) {
            char c;
            StringBuilder result = new StringBuilder(16);
            for (int i = 0; i < key.size() && (c = (char)(0xFF & key.getByte(i))) != '\u0000'; ++i) {
                result.append(c);
            }
            return result.toString();
        }

        protected String fileTrailer() {
            return "And that's all folks.";
        }

        protected void updateHeaders(Headers.Builder headers, long version) {
        }

        protected long version(Headers headers) {
            try {
                String filename = this.currentFile().getName();
                return Integer.parseInt(filename.substring(filename.lastIndexOf(46) + 1));
            }
            catch (IllegalStateException e) {
                return 0L;
            }
        }

        protected void writeFormatSpecifier(WritableBuffer formatSpecifier) {
            formatSpecifier.putByte(0, (byte)-1);
            formatSpecifier.putByte(formatSpecifier.size() - 1, (byte)-1);
        }

        public void put(String key, String value) throws IOException {
            try (EntryUpdater updater = this.updater();){
                updater.apply((Object)key, this.value(value));
            }
        }

        ValueUpdate value(final String value) {
            return new ValueUpdate(){

                public void update(WritableBuffer target) {
                    Store.this.writeKey(value, target);
                }
            };
        }

        public String get(String key) throws IOException {
            return (String)this.lookup(key, (AbstractKeyValueStore.Reader)new AbstractKeyValueStore.Reader<String>(){

                protected String parseValue(ReadableBuffer value) {
                    return Store.this.readKey(value);
                }
            });
        }
    }

    static interface Entry {
        public void write(WritableBuffer var1, WritableBuffer var2);
    }
}

