/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.KeyValueWriter;
import org.neo4j.kernel.impl.store.kvstore.Metadata;
import org.neo4j.kernel.impl.store.kvstore.MetadataCollector;
import org.neo4j.kernel.impl.store.kvstore.StubCollector;

public class KeyValueWriterTest {
    private static final int ENTRIES_PER_PAGE = 256;
    private StubCollector collector = new StubCollector(256, new String[0]);
    private final StubWriter stub = new StubWriter();
    private KeyValueWriter writer = new KeyValueWriter((MetadataCollector)this.collector, (KeyValueWriter.Writer)this.stub);
    private final BigEndianByteArrayBuffer key = new BigEndianByteArrayBuffer(new byte[8]);
    private final BigEndianByteArrayBuffer value = new BigEndianByteArrayBuffer(new byte[8]);

    @After
    public void closeWriter() throws IOException {
        this.writer.close();
    }

    @Test
    public void shouldAcceptNoHeadersAndNoData() throws Exception {
        this.value.putByte(0, (byte)127);
        this.value.putByte(7, (byte)127);
        Assert.assertTrue((String)"format specifier", (boolean)this.writer.writeHeader(this.key, this.value));
        Assert.assertTrue((String)"end-of-header marker", (boolean)this.writer.writeHeader(this.key, this.value));
        Assert.assertTrue((String)"end marker + number of data items", (boolean)this.writer.writeHeader(this.key, this.value));
        this.writer.writeTrailer("all ok");
        this.stub.assertData(0, 0, 0, 0, 0, 0, 0, 0, 127, 0, 0, 0, 0, 0, 0, 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 108, 108, 32, 111, 107);
    }

    @Test
    public void shouldRequireNonZeroFormatSpecifier() throws Exception {
        Assert.assertFalse((String)"format-specifier", (boolean)this.writer.writeHeader(this.key, this.value));
    }

    @Test
    public void shouldRejectInvalidHeaderKeyWhenAssertionsAreEnabled() throws Exception {
        this.key.putByte(3, (byte)1);
        this.value.putByte(0, (byte)127);
        this.value.putByte(7, (byte)127);
        try {
            this.writer.writeHeader(this.key, this.value);
        }
        catch (AssertionError e) {
            Assert.assertEquals((Object)"key should have been cleared by previous call", (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    public void shouldRejectInvalidDataKey() throws Exception {
        this.value.putByte(0, (byte)127);
        this.value.putByte(7, (byte)127);
        this.writer.writeHeader(this.key, this.value);
        this.writer.writeHeader(this.key, this.value);
        try {
            this.writer.writeData(this.key, this.value);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"All-zero keys are not allowed.", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldRejectDataBeforeHeaders() throws Exception {
        this.key.putByte(2, (byte)119);
        try {
            this.writer.writeData(this.key, this.value);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"Cannot write data when expecting format specifier.", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldRejectDataAfterInsufficientHeaders() throws Exception {
        this.value.fill((byte)-1);
        Assert.assertTrue((boolean)this.writer.writeHeader(this.key, this.value));
        this.key.putByte(2, (byte)119);
        try {
            this.writer.writeData(this.key, this.value);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"Cannot write data when expecting header.", (Object)e.getMessage());
        }
    }

    @Test
    public void shouldNotOpenStoreFileIfWritingHasNotCompleted() throws Exception {
        for (int i = 0; i <= 10; ++i) {
            String[] headers;
            switch (i) {
                case 0: 
                case 1: 
                case 8: 
                case 9: 
                case 10: {
                    headers = new String[]{};
                    break;
                }
                case 2: {
                    headers = new String[]{"foo"};
                    break;
                }
                default: {
                    headers = new String[]{"foo", "bar"};
                }
            }
            this.resetWriter(headers);
            block12: for (int field = 1; field <= i; ++field) {
                switch (field) {
                    case 3: {
                        if (i >= 8) {
                            this.writer.writeHeader(this.key, this.value);
                        }
                    }
                    case 2: {
                        if (i >= 8) continue block12;
                    }
                    case 1: {
                        this.value.putByte(0, (byte)127);
                        this.value.putByte(7, (byte)127);
                        this.writer.writeHeader(this.key, this.value);
                        continue block12;
                    }
                    default: {
                        if (i >= 8 && field <= 8) continue block12;
                        this.key.putByte(this.key.size() - 1, (byte)field);
                        this.writer.writeData(this.key, this.value);
                    }
                }
            }
            try {
                this.writer.openStoreFile();
                Assert.fail((String)"expected exception");
                continue;
            }
            catch (IllegalStateException e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("Cannot open store file when "));
            }
        }
    }

    private void resetWriter(String ... header) {
        this.collector = new StubCollector(256, header);
        this.writer = new KeyValueWriter((MetadataCollector)this.collector, (KeyValueWriter.Writer)this.stub);
    }

    private static class StubWriter
    extends KeyValueWriter.Writer {
        IOException next;
        ByteArrayOutputStream data = new ByteArrayOutputStream();

        private StubWriter() {
        }

        void write(byte[] data) throws IOException {
            this.io();
            this.data.write(data);
        }

        KeyValueStoreFile open(Metadata metadata, int keySize, int valueSize) {
            return null;
        }

        void close() throws IOException {
            this.io();
        }

        void writeTrailer(String trailer) throws IOException {
            this.write(UTF8.encode((String)trailer));
        }

        public void assertData(byte ... expected) {
            Assert.assertArrayEquals((byte[])expected, (byte[])this.data.toByteArray());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void io() throws IOException {
            try {
                if (this.next != null) {
                    throw this.next;
                }
            }
            finally {
                this.next = null;
            }
        }
    }
}

