/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.StubCollector;

public class MetadataCollectorTest {
    private final BigEndianByteArrayBuffer key = new BigEndianByteArrayBuffer(new byte[4]);
    private final BigEndianByteArrayBuffer value = new BigEndianByteArrayBuffer(new byte[4]);

    @Test
    public void shouldComputePageCatalogue() throws Exception {
        StubCollector collector = new StubCollector(4, new String[0]);
        collector.visit(this.key, this.value);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 24);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 62);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 78);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 84);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 96);
        collector.visit(this.key, this.value);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 24, 0, 0, 0, 62, 0, 0, 0, 78, 0, 0, 0, 96}, (byte[])collector.pageCatalogue());
    }

    @Test
    public void shouldComputePageCatalogueOverThreePages() throws Exception {
        StubCollector collector = new StubCollector(4, new String[0]);
        collector.visit(this.key, this.value);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 24);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 62);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 78);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 84);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 96);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 128);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 133);
        collector.visit(this.key, this.value);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 24, 0, 0, 0, 62, 0, 0, 0, 78, 0, 0, 0, -128, 0, 0, 0, -123, 0, 0, 0, -123}, (byte[])collector.pageCatalogue());
    }

    @Test
    public void shouldComputePageCatalogueWhenHeaderCoversEntireFirstPage() throws Exception {
        StubCollector collector = new StubCollector(4, "a", "b", "c");
        this.value.putInt(0, -1);
        collector.visit(this.key, this.value);
        collector.visit(this.key, this.value);
        collector.visit(this.key, this.value);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 16);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 32);
        collector.visit(this.key, this.value);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 16, 0, 0, 0, 32}, (byte[])collector.pageCatalogue());
    }

    @Test
    public void shouldComputePageCatalogueWhenHeaderExceedsFirstPage() throws Exception {
        StubCollector collector = new StubCollector(4, "a", "b", "c", "d");
        this.value.putInt(0, -1);
        collector.visit(this.key, this.value);
        collector.visit(this.key, this.value);
        collector.visit(this.key, this.value);
        collector.visit(this.key, this.value);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 16);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 32);
        collector.visit(this.key, this.value);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 16, 0, 0, 0, 32}, (byte[])collector.pageCatalogue());
    }

    @Test
    public void shouldComputeCatalogueWhenSingleDataEntryInPage() throws Exception {
        StubCollector collector = new StubCollector(4, "a", "b");
        this.value.putInt(0, -1);
        collector.visit(this.key, this.value);
        collector.visit(this.key, this.value);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 16);
        collector.visit(this.key, this.value);
        this.key.putInt(0, 32);
        collector.visit(this.key, this.value);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 16, 0, 0, 0, 16, 0, 0, 0, 32, 0, 0, 0, 32}, (byte[])collector.pageCatalogue());
    }
}

