/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProvider;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.monitoring.SilentMigrationProgressMonitor;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;

public class StoreMigratorTest {
    private final SchemaIndexProvider schemaIndexProvider = new InMemoryIndexProvider();
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    public final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();

    private File createNeoStoreWithOlderVersion(String version) throws IOException {
        File storeDir = this.directory.directory().getAbsoluteFile();
        MigrationTestUtils.prepareSampleLegacyDatabase(version, this.fs, storeDir);
        return storeDir;
    }

    @Test
    public void shouldBeAbleToResumeMigration() throws Exception {
        File storeDirectory = this.createNeoStoreWithOlderVersion("v0.A.3");
        DevNullLoggingService logging = new DevNullLoggingService();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        StoreMigrator migrator = new StoreMigrator((MigrationProgressMonitor)new SilentMigrationProgressMonitor(), this.fs, (Logging)logging);
        File migrationDir = new File(storeDirectory, "upgrade");
        this.fs.mkdirs(migrationDir);
        Assert.assertTrue((boolean)migrator.needsMigration(storeDirectory));
        migrator.migrate(storeDirectory, migrationDir, this.schemaIndexProvider, pageCache);
        migrator.close();
        migrator = new StoreMigrator((MigrationProgressMonitor)new SilentMigrationProgressMonitor(), this.fs, (Logging)logging);
        migrator.moveMigratedFiles(migrationDir, storeDirectory);
        StoreFactory storeFactory = new StoreFactory(this.fs, storeDirectory, pageCache, logging.getMessagesLog(this.getClass()), new Monitors());
        storeFactory.newNeoStore(false).close();
    }
}

