/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;

public class StoreVersionCheckTest {
    @Test
    public void shouldReportMissingFileDoesNotHaveSpecifiedVersion() {
        File missingFile = new File("/you/will/never/find/me");
        StoreVersionCheck storeVersionCheck = new StoreVersionCheck((FileSystemAbstraction)new EphemeralFileSystemAbstraction());
        Assert.assertFalse((boolean)storeVersionCheck.hasVersion((File)missingFile, (String)"version").outcome.isSuccessful());
    }

    @Test
    public void shouldReportShortFileDoesNotHaveSpecifiedVersion() throws IOException {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        File shortFile = this.fileContaining(fs, "a");
        StoreVersionCheck storeVersionCheck = new StoreVersionCheck((FileSystemAbstraction)fs);
        Assert.assertFalse((boolean)storeVersionCheck.hasVersion((File)shortFile, (String)"version").outcome.isSuccessful());
    }

    @Test
    public void shouldReportFileWithIncorrectVersion() throws IOException {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        File shortFile = this.fileContaining(fs, "versionWhichIsIncorrect");
        StoreVersionCheck storeVersionCheck = new StoreVersionCheck((FileSystemAbstraction)fs);
        Assert.assertFalse((boolean)storeVersionCheck.hasVersion((File)shortFile, (String)"correctVersion 1").outcome.isSuccessful());
    }

    @Test
    public void shouldReportFileWithCorrectVersion() throws IOException {
        EphemeralFileSystemAbstraction fs = new EphemeralFileSystemAbstraction();
        File shortFile = this.fileContaining(fs, "correctVersion 1");
        StoreVersionCheck storeVersionCheck = new StoreVersionCheck((FileSystemAbstraction)fs);
        Assert.assertTrue((boolean)storeVersionCheck.hasVersion((File)shortFile, (String)"correctVersion 1").outcome.isSuccessful());
    }

    private File fileContaining(EphemeralFileSystemAbstraction fs, String content) throws IOException {
        File shortFile = new File("shortFile");
        OutputStream outputStream = fs.openAsOutputStream(shortFile, true);
        outputStream.write(content.getBytes());
        outputStream.close();
        return shortFile;
    }
}

