/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.kernel.impl.util.Cursors;

public class LogMatchers {
    public static List<LogEntry> logEntries(FileSystemAbstraction fileSystem, String logPath) throws IOException {
        StoreChannel fileChannel = fileSystem.open(new File(logPath), "r");
        ByteBuffer buffer = ByteBuffer.allocateDirect(713);
        LogHeader header = LogHeaderReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)fileChannel, (boolean)true);
        PhysicalLogVersionedStoreChannel versionedStoreChannel = new PhysicalLogVersionedStoreChannel(fileChannel, header.logVersion, header.logFormatVersion);
        ReadAheadLogChannel logChannel = new ReadAheadLogChannel((LogVersionedStoreChannel)versionedStoreChannel, LogVersionBridge.NO_MORE_CHANNELS, 4096);
        return Iterables.toList((Iterable)Cursors.iterable((IOCursor)new LogEntryCursor((ReadableVersionableLogChannel)logChannel)));
    }

    public static List<LogEntry> logEntries(FileSystemAbstraction fileSystem, File file) throws IOException {
        return LogMatchers.logEntries(fileSystem, file.getPath());
    }

    public static Matcher<List<LogEntry>> containsExactly(final Matcher<? extends LogEntry> ... matchers) {
        return new TypeSafeMatcher<List<LogEntry>>(){

            public boolean matchesSafely(List<LogEntry> item) {
                Iterator<LogEntry> actualEntries = item.iterator();
                for (Matcher matcher : matchers) {
                    if (actualEntries.hasNext()) {
                        LogEntry next = actualEntries.next();
                        if (matcher.matches((Object)next)) continue;
                        return false;
                    }
                    return false;
                }
                return !actualEntries.hasNext();
            }

            public void describeTo(Description description) {
                for (Matcher matcher : matchers) {
                    description.appendDescriptionOf((SelfDescribing)matcher).appendText(",\n");
                }
            }
        };
    }

    public static Matcher<? extends LogEntry> startEntry(final int masterId, final int localId) {
        return new TypeSafeMatcher<LogEntryStart>(){

            public boolean matchesSafely(LogEntryStart entry) {
                return entry != null && entry.getMasterId() == masterId && entry.getLocalId() == localId;
            }

            public void describeTo(Description description) {
                description.appendText("Start[xid=<Any Xid>,master=" + masterId + ",me=" + localId + ",time=<Any Date>]");
            }
        };
    }

    public static Matcher<? extends LogEntry> commitEntry(final long txId) {
        return new TypeSafeMatcher<OnePhaseCommit>(){

            public boolean matchesSafely(OnePhaseCommit onePC) {
                return onePC != null && onePC.getTxId() == txId;
            }

            public void describeTo(Description description) {
                description.appendText(String.format("Commit[txId=%d, <Any Date>]", txId));
            }
        };
    }

    public static Matcher<? extends LogEntry> commandEntry(final long key, final Class<? extends Command> commandClass) {
        return new TypeSafeMatcher<LogEntryCommand>(){

            public boolean matchesSafely(LogEntryCommand commandEntry) {
                if (commandEntry == null) {
                    return false;
                }
                Command command = commandEntry.getXaCommand();
                return command.getKey() == key && command.getClass().equals(commandClass);
            }

            public void describeTo(Description description) {
                description.appendText(String.format("Command[key=%d, cls=%s]", key, commandClass.getSimpleName()));
            }
        };
    }
}

