/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;

public class PhysicalTransactionCursorTest {
    private final ReadableVersionableLogChannel channel = (ReadableVersionableLogChannel)Mockito.mock(ReadableVersionableLogChannel.class);
    private final LogEntryReader<ReadableVersionableLogChannel> entryReader = (LogEntryReader)Mockito.mock(LogEntryReader.class);
    private static final LogEntry NULL_ENTRY = null;
    private static final LogEntryStart A_START_ENTRY = new LogEntryStart(0, 0, 0L, 0L, null, LogPosition.UNSPECIFIED);
    private static final LogEntryCommit A_COMMIT_ENTRY = new OnePhaseCommit(42L, 0L);
    private static final LogEntryCommand A_COMMAND_ENTRY = new LogEntryCommand((Command)new Command.NodeCommand());
    private final PhysicalTransactionCursor<ReadableVersionableLogChannel> cursor = new PhysicalTransactionCursor((ReadableLogChannel)this.channel, this.entryReader);

    @Test
    public void shouldCloseTheUnderlyingChannel() throws IOException {
        this.cursor.close();
        ((ReadableVersionableLogChannel)Mockito.verify((Object)this.channel, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void shouldReturnFalseWhenThereAreNoEntries() throws IOException {
        Mockito.when((Object)this.entryReader.readLogEntry((ReadableLogChannel)this.channel)).thenReturn((Object)NULL_ENTRY);
        boolean result = this.cursor.next();
        Assert.assertFalse((boolean)result);
        Assert.assertNull((Object)this.cursor.get());
    }

    @Test
    public void shouldReturnFalseWhenThereIsAStartEntryButNoCommitEntries() throws IOException {
        Mockito.when((Object)this.entryReader.readLogEntry((ReadableLogChannel)this.channel)).thenReturn((Object)A_START_ENTRY, (Object[])new LogEntry[]{NULL_ENTRY});
        boolean result = this.cursor.next();
        Assert.assertFalse((boolean)result);
        Assert.assertNull((Object)this.cursor.get());
    }

    @Test
    public void shouldCallTheVisitorWithTheFoundTransaction() throws IOException {
        Mockito.when((Object)this.entryReader.readLogEntry((ReadableLogChannel)this.channel)).thenReturn((Object)A_START_ENTRY, (Object[])new LogEntry[]{A_COMMAND_ENTRY, A_COMMIT_ENTRY});
        this.cursor.next();
        PhysicalTransactionRepresentation txRepresentation = new PhysicalTransactionRepresentation(Arrays.asList(A_COMMAND_ENTRY.getXaCommand()));
        Assert.assertEquals((Object)new CommittedTransactionRepresentation(A_START_ENTRY, (TransactionRepresentation)txRepresentation, A_COMMIT_ENTRY), (Object)this.cursor.get());
    }
}

