/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.helpers.Provider;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NeoStoreRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.command.CacheInvalidationTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.HighIdTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.IndexTransactionApplier;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.command.NeoStoreTransactionApplier;
import org.neo4j.unsafe.batchinsert.LabelScanWriter;

public class NeoTransactionStoreApplierTest {
    private final NeoStore neoStore = (NeoStore)Mockito.mock(NeoStore.class);
    private final IndexingService indexingService = (IndexingService)Mockito.mock(IndexingService.class);
    private final Provider<LabelScanWriter> labelScanStore = (Provider)Mockito.mock(Provider.class);
    private final CacheAccessBackDoor cacheAccess = (CacheAccessBackDoor)Mockito.mock(CacheAccessBackDoor.class);
    private final LockService lockService = (LockService)Mockito.mock(LockService.class);
    private final NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
    private final RelationshipStore relationshipStore = (RelationshipStore)Mockito.mock(RelationshipStore.class);
    private final PropertyStore propertyStore = (PropertyStore)Mockito.mock(PropertyStore.class);
    private final RelationshipGroupStore relationshipGroupStore = (RelationshipGroupStore)Mockito.mock(RelationshipGroupStore.class);
    private final RelationshipTypeTokenStore relationshipTypeTokenStore = (RelationshipTypeTokenStore)Mockito.mock(RelationshipTypeTokenStore.class);
    private final LabelTokenStore labelTokenStore = (LabelTokenStore)Mockito.mock(LabelTokenStore.class);
    private final PropertyKeyTokenStore propertyKeyTokenStore = (PropertyKeyTokenStore)Mockito.mock(PropertyKeyTokenStore.class);
    private final SchemaStore schemaStore = (SchemaStore)Mockito.mock(SchemaStore.class);
    private final DynamicArrayStore dynamicLabelStore = (DynamicArrayStore)Mockito.mock(DynamicArrayStore.class);
    private final int transactionId = 55555;
    private final DynamicRecord one = DynamicRecord.dynamicRecord((long)1L, (boolean)true);
    private final DynamicRecord two = DynamicRecord.dynamicRecord((long)2L, (boolean)true);
    private final DynamicRecord three = DynamicRecord.dynamicRecord((long)3L, (boolean)true);
    private WorkSync<Provider<LabelScanWriter>, IndexTransactionApplier.LabelUpdateWork> labelScanStoreSynchronizer = new WorkSync(this.labelScanStore);

    @Before
    public void setup() {
        Mockito.when((Object)this.neoStore.getNodeStore()).thenReturn((Object)this.nodeStore);
        Mockito.when((Object)this.neoStore.getRelationshipStore()).thenReturn((Object)this.relationshipStore);
        Mockito.when((Object)this.neoStore.getPropertyStore()).thenReturn((Object)this.propertyStore);
        Mockito.when((Object)this.neoStore.getRelationshipGroupStore()).thenReturn((Object)this.relationshipGroupStore);
        Mockito.when((Object)this.neoStore.getRelationshipTypeTokenStore()).thenReturn((Object)this.relationshipTypeTokenStore);
        Mockito.when((Object)this.neoStore.getLabelTokenStore()).thenReturn((Object)this.labelTokenStore);
        Mockito.when((Object)this.neoStore.getPropertyKeyTokenStore()).thenReturn((Object)this.propertyKeyTokenStore);
        Mockito.when((Object)this.neoStore.getSchemaStore()).thenReturn((Object)this.schemaStore);
        Mockito.when((Object)this.nodeStore.getDynamicLabelStore()).thenReturn((Object)this.dynamicLabelStore);
        Mockito.when((Object)this.lockService.acquireNodeLock(Matchers.anyLong(), (LockService.LockType)Matchers.any())).thenReturn((Object)LockService.NO_LOCK);
    }

    @Test
    public void shouldApplyNodeCommandToTheStore() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        NodeRecord before = new NodeRecord(11L);
        before.setLabelField(42L, Arrays.asList(this.one, this.two));
        NodeRecord after = new NodeRecord(12L);
        after.setInUse(true);
        after.setLabelField(42L, Arrays.asList(this.one, this.two, this.three));
        Command.NodeCommand command = new Command.NodeCommand().init(before, after);
        boolean result = applier.visitNodeCommand(command);
        Assert.assertFalse((boolean)result);
        ((LockService)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(command.getKey(), LockService.LockType.WRITE_LOCK);
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)1))).updateDynamicLabelRecords(Arrays.asList(this.one, this.two, this.three));
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.never())).removeNodeFromCache(command.getKey());
    }

    private NeoCommandHandler newApplier(boolean recovery) {
        NeoStoreTransactionApplier applier = new NeoStoreTransactionApplier(this.neoStore, this.cacheAccess, this.lockService, new LockGroup(), 55555L);
        if (recovery) {
            applier = new HighIdTransactionApplier((NeoCommandHandler)applier, this.neoStore);
            applier = new CacheInvalidationTransactionApplier((NeoCommandHandler)applier, this.neoStore, this.cacheAccess);
        }
        return applier;
    }

    @Test
    public void shouldApplyNodeCommandToTheStoreAndInvalidateTheCache() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        NodeRecord before = new NodeRecord(11L);
        before.setLabelField(42L, Arrays.asList(this.one, this.two));
        NodeRecord after = new NodeRecord(12L);
        after.setInUse(false);
        after.setLabelField(42L, Arrays.asList(this.one, this.two, this.three));
        Command.NodeCommand command = new Command.NodeCommand().init(before, after);
        boolean result = applier.visitNodeCommand(command);
        Assert.assertFalse((boolean)result);
        ((LockService)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(command.getKey(), LockService.LockType.WRITE_LOCK);
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)1))).updateDynamicLabelRecords(Arrays.asList(this.one, this.two, this.three));
    }

    @Test
    public void shouldApplyNodeCommandToTheStoreInRecoveryMode() throws IOException {
        NeoCommandHandler applier = this.newApplier(true);
        NodeRecord before = new NodeRecord(11L);
        before.setLabelField(42L, Arrays.asList(this.one, this.two));
        NodeRecord after = new NodeRecord(12L);
        after.setInUse(true);
        after.setLabelField(42L, Arrays.asList(this.one, this.two, this.three));
        Command.NodeCommand command = new Command.NodeCommand().init(before, after);
        boolean result = applier.visitNodeCommand(command);
        this.applyAndClose(applier);
        Assert.assertFalse((boolean)result);
        ((LockService)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(command.getKey(), LockService.LockType.WRITE_LOCK);
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(after.getId());
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
        ((DynamicArrayStore)Mockito.verify((Object)this.dynamicLabelStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(this.three.getId());
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)1))).updateDynamicLabelRecords(Arrays.asList(this.one, this.two, this.three));
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).removeNodeFromCache(command.getKey());
    }

    @Test
    public void shouldInvalidateTheCacheWhenTheNodeBecomesDense() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        NodeRecord before = new NodeRecord(11L);
        before.setLabelField(42L, Arrays.asList(this.one));
        before.setInUse(true);
        before.setDense(false);
        NodeRecord after = new NodeRecord(12L);
        after.setInUse(true);
        after.setDense(true);
        after.setLabelField(42L, Arrays.asList(this.one, this.two, this.three));
        Command.NodeCommand command = new Command.NodeCommand().init(before, after);
        boolean result = applier.visitNodeCommand(command);
        Assert.assertFalse((boolean)result);
        ((LockService)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(command.getKey(), LockService.LockType.WRITE_LOCK);
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
        ((NodeStore)Mockito.verify((Object)this.nodeStore, (VerificationMode)Mockito.times((int)1))).updateDynamicLabelRecords(Arrays.asList(this.one, this.two, this.three));
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).removeNodeFromCache(command.getKey());
    }

    @Test
    public void cacheShouldInvalidateOnlyOnceWhenNodeBecomesDense() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        NodeRecord before = new NodeRecord(11L);
        before.setLabelField(42L, Arrays.asList(this.one, this.two));
        before.setInUse(true);
        before.setDense(false);
        NodeRecord after = new NodeRecord(12L);
        after.setInUse(true);
        after.setDense(true);
        after.setLabelField(42L, Arrays.asList(this.one, this.three));
        Command.NodeCommand command = new Command.NodeCommand().init(before, after);
        applier.visitNodeCommand(command);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).removeNodeFromCache(command.getKey());
    }

    @Test
    public void shouldApplyRelationshipCommandToTheStore() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        RelationshipRecord record = new RelationshipRecord(12L, 3L, 4L, 5);
        record.setInUse(true);
        boolean result = applier.visitRelationshipCommand(new Command.RelationshipCommand().init(record));
        Assert.assertFalse((boolean)result);
        ((RelationshipStore)Mockito.verify((Object)this.relationshipStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.never())).removeRelationshipFromCache(record.getId());
    }

    @Test
    public void shouldApplyRelationshipCommandToTheStoreAndInvalidateTheCache() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        RelationshipRecord record = new RelationshipRecord(12L, 3L, 4L, 5);
        record.setInUse(false);
        boolean result = applier.visitRelationshipCommand(new Command.RelationshipCommand().init(record));
        Assert.assertFalse((boolean)result);
        ((RelationshipStore)Mockito.verify((Object)this.relationshipStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
    }

    @Test
    public void shouldApplyRelationshipCommandToTheStoreInRecovery() throws IOException {
        NeoCommandHandler applier = this.newApplier(true);
        RelationshipRecord record = new RelationshipRecord(12L, 3L, 4L, 5);
        record.setInUse(true);
        boolean result = applier.visitRelationshipCommand(new Command.RelationshipCommand().init(record));
        this.applyAndClose(applier);
        Assert.assertFalse((boolean)result);
        ((RelationshipStore)Mockito.verify((Object)this.relationshipStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(record.getId());
        ((RelationshipStore)Mockito.verify((Object)this.relationshipStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).removeRelationshipFromCache(record.getId());
    }

    @Test
    public void shouldApplyNodePropertyCommandToTheStore() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        PropertyRecord before = new PropertyRecord(11L);
        PropertyRecord after = new PropertyRecord(12L);
        after.setNodeId(42L);
        boolean result = applier.visitPropertyCommand(new Command.PropertyCommand().init(before, after));
        Assert.assertFalse((boolean)result);
        ((LockService)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(42L, LockService.LockType.WRITE_LOCK);
        ((PropertyStore)Mockito.verify((Object)this.propertyStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
    }

    @Test
    public void shouldApplyNodePropertyCommandToTheStoreInRecovery() throws IOException {
        NeoCommandHandler applier = this.newApplier(true);
        PropertyRecord before = new PropertyRecord(11L);
        PropertyRecord after = new PropertyRecord(12L);
        after.setNodeId(42L);
        boolean result = applier.visitPropertyCommand(new Command.PropertyCommand().init(before, after));
        this.applyAndClose(applier);
        Assert.assertFalse((boolean)result);
        ((LockService)Mockito.verify((Object)this.lockService, (VerificationMode)Mockito.times((int)1))).acquireNodeLock(42L, LockService.LockType.WRITE_LOCK);
        ((PropertyStore)Mockito.verify((Object)this.propertyStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(after.getId());
        ((PropertyStore)Mockito.verify((Object)this.propertyStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).removeNodeFromCache(after.getNodeId());
    }

    @Test
    public void shouldApplyRelPropertyCommandToTheStore() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        PropertyRecord before = new PropertyRecord(11L);
        PropertyRecord after = new PropertyRecord(12L);
        after.setRelId(42L);
        boolean result = applier.visitPropertyCommand(new Command.PropertyCommand().init(before, after));
        Assert.assertFalse((boolean)result);
        ((PropertyStore)Mockito.verify((Object)this.propertyStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
    }

    @Test
    public void shouldApplyRelPropertyCommandToTheStoreInRecovery() throws IOException {
        NeoCommandHandler applier = this.newApplier(true);
        PropertyRecord before = new PropertyRecord(11L);
        PropertyRecord after = new PropertyRecord(12L);
        after.setRelId(42L);
        boolean result = applier.visitPropertyCommand(new Command.PropertyCommand().init(before, after));
        this.applyAndClose(applier);
        Assert.assertFalse((boolean)result);
        ((PropertyStore)Mockito.verify((Object)this.propertyStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(12L);
        ((PropertyStore)Mockito.verify((Object)this.propertyStore, (VerificationMode)Mockito.times((int)1))).updateRecord(after);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).removeRelationshipFromCache(after.getRelId());
    }

    private void applyAndClose(NeoCommandHandler ... appliers) {
        for (NeoCommandHandler applier : appliers) {
            applier.apply();
        }
        for (NeoCommandHandler applier : appliers) {
            applier.close();
        }
    }

    @Test
    public void shouldApplyRelationshipGroupCommandToTheStore() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        RelationshipGroupRecord record = new RelationshipGroupRecord(42L, 1);
        boolean result = applier.visitRelationshipGroupCommand(new Command.RelationshipGroupCommand().init(record));
        Assert.assertFalse((boolean)result);
        ((RelationshipGroupStore)Mockito.verify((Object)this.relationshipGroupStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
    }

    @Test
    public void shouldApplyRelationshipGroupCommandToTheStoreInRecovery() throws IOException {
        NeoCommandHandler applier = this.newApplier(true);
        RelationshipGroupRecord record = new RelationshipGroupRecord(42L, 1);
        boolean result = applier.visitRelationshipGroupCommand(new Command.RelationshipGroupCommand().init(record));
        this.applyAndClose(applier);
        Assert.assertFalse((boolean)result);
        ((RelationshipGroupStore)Mockito.verify((Object)this.relationshipGroupStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(record.getId());
        ((RelationshipGroupStore)Mockito.verify((Object)this.relationshipGroupStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
    }

    @Test
    public void shouldApplyRelationshipTypeTokenCommandToTheStore() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(42);
        boolean result = applier.visitRelationshipTypeTokenCommand((Command.RelationshipTypeTokenCommand)new Command.RelationshipTypeTokenCommand().init((TokenRecord)record));
        Assert.assertFalse((boolean)result);
        ((RelationshipTypeTokenStore)Mockito.verify((Object)this.relationshipTypeTokenStore, (VerificationMode)Mockito.times((int)1))).updateRecord((TokenRecord)record);
    }

    @Test
    public void shouldApplyRelationshipTypeTokenCommandToTheStoreInRecovery() throws IOException {
        NeoCommandHandler applier = this.newApplier(true);
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(42);
        Command.RelationshipTypeTokenCommand command = (Command.RelationshipTypeTokenCommand)new Command.RelationshipTypeTokenCommand().init((TokenRecord)record);
        Token token = new Token("token", 21);
        Mockito.when((Object)this.relationshipTypeTokenStore.getToken((int)command.getKey())).thenReturn((Object)token);
        boolean result = applier.visitRelationshipTypeTokenCommand(command);
        this.applyAndClose(applier);
        Assert.assertFalse((boolean)result);
        ((RelationshipTypeTokenStore)Mockito.verify((Object)this.relationshipTypeTokenStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse((long)record.getId());
        ((RelationshipTypeTokenStore)Mockito.verify((Object)this.relationshipTypeTokenStore, (VerificationMode)Mockito.times((int)1))).updateRecord((TokenRecord)record);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addRelationshipTypeToken(token);
    }

    @Test
    public void shouldApplyLabelTokenCommandToTheStore() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        LabelTokenRecord record = new LabelTokenRecord(42);
        boolean result = applier.visitLabelTokenCommand((Command.LabelTokenCommand)new Command.LabelTokenCommand().init((TokenRecord)record));
        Assert.assertFalse((boolean)result);
        ((LabelTokenStore)Mockito.verify((Object)this.labelTokenStore, (VerificationMode)Mockito.times((int)1))).updateRecord((TokenRecord)record);
    }

    @Test
    public void shouldApplyLabelTokenCommandToTheStoreInRecovery() throws IOException {
        NeoCommandHandler applier = this.newApplier(true);
        LabelTokenRecord record = new LabelTokenRecord(42);
        Command.LabelTokenCommand command = (Command.LabelTokenCommand)new Command.LabelTokenCommand().init((TokenRecord)record);
        Token token = new Token("token", 21);
        Mockito.when((Object)this.labelTokenStore.getToken((int)command.getKey())).thenReturn((Object)token);
        boolean result = applier.visitLabelTokenCommand(command);
        this.applyAndClose(applier);
        Assert.assertFalse((boolean)result);
        ((LabelTokenStore)Mockito.verify((Object)this.labelTokenStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse((long)record.getId());
        ((LabelTokenStore)Mockito.verify((Object)this.labelTokenStore, (VerificationMode)Mockito.times((int)1))).updateRecord((TokenRecord)record);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addLabelToken(token);
    }

    @Test
    public void shouldApplyPropertyKeyTokenCommandToTheStore() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(42);
        boolean result = applier.visitPropertyKeyTokenCommand((Command.PropertyKeyTokenCommand)new Command.PropertyKeyTokenCommand().init((TokenRecord)record));
        Assert.assertFalse((boolean)result);
        ((PropertyKeyTokenStore)Mockito.verify((Object)this.propertyKeyTokenStore, (VerificationMode)Mockito.times((int)1))).updateRecord((TokenRecord)record);
    }

    @Test
    public void shouldApplyPropertyKeyTokenCommandToTheStoreInRecovery() throws IOException {
        NeoCommandHandler applier = this.newApplier(true);
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(42);
        Command.PropertyKeyTokenCommand command = (Command.PropertyKeyTokenCommand)new Command.PropertyKeyTokenCommand().init((TokenRecord)record);
        Token token = new Token("token", 21);
        Mockito.when((Object)this.propertyKeyTokenStore.getToken((int)command.getKey())).thenReturn((Object)token);
        boolean result = applier.visitPropertyKeyTokenCommand(command);
        this.applyAndClose(applier);
        Assert.assertFalse((boolean)result);
        ((PropertyKeyTokenStore)Mockito.verify((Object)this.propertyKeyTokenStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse((long)record.getId());
        ((PropertyKeyTokenStore)Mockito.verify((Object)this.propertyKeyTokenStore, (VerificationMode)Mockito.times((int)1))).updateRecord((TokenRecord)record);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addPropertyKeyToken(token);
    }

    @Test
    public void shouldApplyCreateIndexRuleSchemaRuleCommandToTheStore() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        IndexTransactionApplier indexApplier = new IndexTransactionApplier(this.indexingService, ValidatedIndexUpdates.NONE, this.labelScanStoreSynchronizer, this.cacheAccess);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setCreated();
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        IndexRule rule = IndexRule.indexRule((long)0L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("K", "X.Y"));
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand().init(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = applier.visitSchemaRuleCommand(command) & indexApplier.visitSchemaRuleCommand(command);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).createIndex(rule);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyCreateIndexRuleSchemaRuleCommandToTheStoreInRecovery() throws IOException {
        NeoCommandHandler applier = this.newApplier(true);
        NeoCommandHandler indexApplier = this.newIndexApplier(TransactionApplicationMode.EXTERNAL);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setCreated();
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        IndexRule rule = IndexRule.indexRule((long)0L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("K", "X.Y"));
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand().init(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = applier.visitSchemaRuleCommand(command) & indexApplier.visitSchemaRuleCommand(command);
        this.applyAndClose(applier, indexApplier);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(record.getId());
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).createIndex(rule);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyUpdateIndexRuleSchemaRuleCommandToTheStore() throws IOException, IndexNotFoundKernelException, IndexPopulationFailedKernelException, IndexActivationFailedKernelException {
        NeoCommandHandler applier = this.newApplier(false);
        NeoCommandHandler indexApplier = this.newIndexApplier(TransactionApplicationMode.INTERNAL);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        IndexRule rule = IndexRule.constraintIndexRule((long)0L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("K", "X.Y"), (Long)42L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand().init(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = applier.visitSchemaRuleCommand(command) & indexApplier.visitSchemaRuleCommand(command);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).activateIndex(rule.getId());
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyUpdateIndexRuleSchemaRuleCommandToTheStoreInRecovery() throws IOException, IndexNotFoundKernelException, IndexPopulationFailedKernelException, IndexActivationFailedKernelException {
        NeoCommandHandler applier = this.newApplier(true);
        NeoCommandHandler indexApplier = this.newIndexApplier(TransactionApplicationMode.EXTERNAL);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        IndexRule rule = IndexRule.constraintIndexRule((long)0L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("K", "X.Y"), (Long)42L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand().init(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = applier.visitSchemaRuleCommand(command) & indexApplier.visitSchemaRuleCommand(command);
        this.applyAndClose(applier, indexApplier);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(record.getId());
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).activateIndex(rule.getId());
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyUpdateIndexRuleSchemaRuleCommandToTheStoreThrowingIndexProblem() throws IOException, IndexNotFoundKernelException, IndexPopulationFailedKernelException, IndexActivationFailedKernelException {
        NeoCommandHandler applier = this.newIndexApplier(TransactionApplicationMode.INTERNAL);
        ((IndexingService)Mockito.doThrow((Throwable)new IndexNotFoundKernelException("")).when((Object)this.indexingService)).activateIndex(Matchers.anyLong());
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        IndexRule rule = IndexRule.constraintIndexRule((long)0L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("K", "X.Y"), (Long)42L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand().init(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        try {
            applier.visitSchemaRuleCommand(command);
            Assert.fail((String)"should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IndexNotFoundKernelException));
        }
    }

    @Test
    public void shouldApplyDeleteIndexRuleSchemaRuleCommandToTheStore() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        NeoCommandHandler indexApplier = this.newIndexApplier(TransactionApplicationMode.INTERNAL);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setInUse(false);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        IndexRule rule = IndexRule.indexRule((long)0L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("K", "X.Y"));
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand().init(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = applier.visitSchemaRuleCommand(command) & indexApplier.visitSchemaRuleCommand(command);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).dropIndex(rule);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).removeSchemaRuleFromCache(command.getKey());
    }

    @Test
    public void shouldApplyDeleteIndexRuleSchemaRuleCommandToTheStoreInRecovery() throws IOException {
        NeoCommandHandler applier = this.newApplier(true);
        NeoCommandHandler indexApplier = this.newIndexApplier(TransactionApplicationMode.RECOVERY);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setInUse(false);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        IndexRule rule = IndexRule.indexRule((long)0L, (int)1, (int)2, (SchemaIndexProvider.Descriptor)new SchemaIndexProvider.Descriptor("K", "X.Y"));
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand().init(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = applier.visitSchemaRuleCommand(command) & indexApplier.visitSchemaRuleCommand(command);
        this.applyAndClose(applier, indexApplier);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(record.getId());
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
        ((IndexingService)Mockito.verify((Object)this.indexingService, (VerificationMode)Mockito.times((int)1))).dropIndex(rule);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).removeSchemaRuleFromCache(command.getKey());
    }

    private NeoCommandHandler newIndexApplier(TransactionApplicationMode mode) {
        return new IndexTransactionApplier(this.indexingService, ValidatedIndexUpdates.NONE, this.labelScanStoreSynchronizer, this.cacheAccess);
    }

    @Test
    public void shouldApplyCreateUniquenessConstraintRuleSchemaRuleCommandToTheStore() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setCreated();
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        UniquenessConstraintRule rule = UniquenessConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)3L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand().init(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = applier.visitSchemaRuleCommand(command);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
        ((NeoStore)Mockito.verify((Object)this.neoStore, (VerificationMode)Mockito.times((int)1))).setLatestConstraintIntroducingTx(55555L);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyCreateUniquenessConstraintRuleSchemaRuleCommandToTheStoreInRecovery() throws IOException {
        NeoCommandHandler applier = this.newApplier(true);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setCreated();
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        UniquenessConstraintRule rule = UniquenessConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)3L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand().init(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = applier.visitSchemaRuleCommand(command);
        this.applyAndClose(applier);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(record.getId());
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
        ((NeoStore)Mockito.verify((Object)this.neoStore, (VerificationMode)Mockito.times((int)1))).setLatestConstraintIntroducingTx(55555L);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyUpdateUniquenessConstraintRuleSchemaRuleCommandToTheStore() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        UniquenessConstraintRule rule = UniquenessConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)3L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand().init(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = applier.visitSchemaRuleCommand(command);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
        ((NeoStore)Mockito.verify((Object)this.neoStore, (VerificationMode)Mockito.times((int)1))).setLatestConstraintIntroducingTx(55555L);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyUpdateUniquenessConstraintRuleSchemaRuleCommandToTheStoreInRecovery() throws IOException {
        NeoCommandHandler applier = this.newApplier(true);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        UniquenessConstraintRule rule = UniquenessConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)3L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand().init(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = applier.visitSchemaRuleCommand(command);
        this.applyAndClose(applier);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(record.getId());
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
        ((NeoStore)Mockito.verify((Object)this.neoStore, (VerificationMode)Mockito.times((int)1))).setLatestConstraintIntroducingTx(55555L);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).addSchemaRule((SchemaRule)rule);
    }

    @Test
    public void shouldApplyDeleteUniquenessConstraintRuleSchemaRuleCommandToTheStore() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setInUse(false);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        UniquenessConstraintRule rule = UniquenessConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)3L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand().init(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = applier.visitSchemaRuleCommand(command);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
        ((NeoStore)Mockito.verify((Object)this.neoStore, (VerificationMode)Mockito.never())).setLatestConstraintIntroducingTx(55555L);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).removeSchemaRuleFromCache(command.getKey());
    }

    @Test
    public void shouldApplyDeleteUniquenessConstraintRuleSchemaRuleCommandToTheStoreInRecovery() throws IOException {
        NeoCommandHandler applier = this.newApplier(true);
        DynamicRecord record = DynamicRecord.dynamicRecord((long)21L, (boolean)true);
        record.setInUse(false);
        List<DynamicRecord> recordsAfter = Arrays.asList(record);
        UniquenessConstraintRule rule = UniquenessConstraintRule.uniquenessConstraintRule((long)0L, (int)1, (int)2, (long)3L);
        Command.SchemaRuleCommand command = new Command.SchemaRuleCommand().init(Collections.emptyList(), recordsAfter, (SchemaRule)rule);
        boolean result = applier.visitSchemaRuleCommand(command);
        this.applyAndClose(applier);
        Assert.assertFalse((boolean)result);
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).setHighestPossibleIdInUse(record.getId());
        ((SchemaStore)Mockito.verify((Object)this.schemaStore, (VerificationMode)Mockito.times((int)1))).updateRecord(record);
        ((NeoStore)Mockito.verify((Object)this.neoStore, (VerificationMode)Mockito.never())).setLatestConstraintIntroducingTx(55555L);
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).removeSchemaRuleFromCache(command.getKey());
    }

    @Test
    public void shouldApplyNeoStoreCommandToTheStore() throws IOException {
        NeoCommandHandler applier = this.newApplier(false);
        NeoStoreRecord record = new NeoStoreRecord();
        record.setNextProp(42L);
        boolean result = applier.visitNeoStoreCommand(new Command.NeoStoreCommand().init(record));
        Assert.assertFalse((boolean)result);
        ((NeoStore)Mockito.verify((Object)this.neoStore, (VerificationMode)Mockito.times((int)1))).setGraphNextProp(record.getNextProp());
    }

    @Test
    public void shouldApplyNeoStoreCommandToTheStoreInRecovery() throws IOException {
        NeoCommandHandler applier = this.newApplier(true);
        NeoStoreRecord record = new NeoStoreRecord();
        record.setNextProp(42L);
        boolean result = applier.visitNeoStoreCommand(new Command.NeoStoreCommand().init(record));
        Assert.assertFalse((boolean)result);
        ((NeoStore)Mockito.verify((Object)this.neoStore, (VerificationMode)Mockito.times((int)1))).setGraphNextProp(record.getNextProp());
        ((CacheAccessBackDoor)Mockito.verify((Object)this.cacheAccess, (VerificationMode)Mockito.times((int)1))).removeGraphPropertiesFromCache();
    }
}

