/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.LogRotationImpl;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.transaction.DeadSimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogRotation;
import org.neo4j.kernel.impl.transaction.log.LogRotationControl;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.test.Barrier;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.OtherThreadRule;

public class LogRotationDeadlockTest {
    @Rule
    public final OtherThreadRule<Void> committer = new OtherThreadRule("COMMITTER");
    @Rule
    public final OtherThreadRule<Void> rotator = new OtherThreadRule("ROTATOR");

    @Test
    public void shouldNotDeadlockDuringRotation() throws Exception {
        DeadSimpleTransactionIdStore txIdStore = new DeadSimpleTransactionIdStore();
        LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
        Mockito.when((Object)logFile.getWriter()).thenReturn((Object)new InMemoryLogChannel());
        Logging logging = (Logging)Mockito.mock(Logging.class);
        Mockito.when((Object)logging.getMessagesLog((Class)Matchers.any())).thenReturn(Mockito.mock(StringLogger.class));
        final Barrier.Control inBetweenCommittedAndClosed = new Barrier.Control();
        LogRotationControl rotationControl = new LogRotationControl(txIdStore, (IndexingService)Mockito.mock(IndexingService.class), (LabelScanStore)Mockito.mock(LabelScanStore.class), Iterables.iterable((Object[])new IndexImplementation[0])){

            public void awaitAllTransactionsClosed() {
                inBetweenCommittedAndClosed.release();
                super.awaitAllTransactionsClosed();
            }
        };
        KernelHealth health = (KernelHealth)Mockito.mock(KernelHealth.class);
        LogRotationImpl rotation = new LogRotationImpl((LogRotation.Monitor)Mockito.mock(LogRotation.Monitor.class), logFile, rotationControl, health, logging);
        BatchingTransactionAppender appender = new BatchingTransactionAppender(logFile, (LogRotation)rotation, new TransactionMetadataCache(10, 10), txIdStore, (IdOrderingQueue)Mockito.mock(IdOrderingQueue.class), health){

            protected void forceAfterAppend(LogAppendEvent logAppendEvent) throws IOException {
                inBetweenCommittedAndClosed.reached();
                super.forceAfterAppend(logAppendEvent);
            }
        };
        LogicalTransactionStore txStore = (LogicalTransactionStore)Mockito.mock(LogicalTransactionStore.class);
        Mockito.when((Object)txStore.getAppender()).thenReturn((Object)appender);
        TransactionRepresentationCommitProcess commitProcess = new TransactionRepresentationCommitProcess(txStore, health, (TransactionIdStore)txIdStore, (TransactionRepresentationStoreApplier)Mockito.mock(TransactionRepresentationStoreApplier.class), (IndexUpdatesValidator)Mockito.mock(IndexUpdatesValidator.class));
        Future<Void> appendFuture = this.committer.execute(this.commitArbitraryTransaction((TransactionCommitProcess)commitProcess));
        inBetweenCommittedAndClosed.await();
        Mockito.when((Object)logFile.rotationNeeded()).thenReturn((Object)true);
        Future<Void> rotateFuture = this.rotator.execute(this.commitArbitraryTransaction((TransactionCommitProcess)commitProcess));
        appendFuture.get(100L, TimeUnit.SECONDS);
        rotateFuture.get(100L, TimeUnit.SECONDS);
    }

    private OtherThreadExecutor.WorkerCommand<Void, Void> commitArbitraryTransaction(final TransactionCommitProcess commitProcess) {
        return new OtherThreadExecutor.WorkerCommand<Void, Void>(){

            @Override
            public Void doWork(Void state) throws Exception {
                commitProcess.commit(LogRotationDeadlockTest.this.arbitraryTransaction(), new LockGroup(), CommitEvent.NULL, TransactionApplicationMode.INTERNAL);
                return null;
            }
        };
    }

    private TransactionRepresentation arbitraryTransaction() {
        TransactionRepresentation transaction = (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class);
        Mockito.when((Object)transaction.additionalHeader()).thenReturn((Object)new byte[0]);
        return transaction;
    }
}

