/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.CloseableVisitor;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.Recovery;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.DeadSimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogFileRecoverer;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogRotation;
import org.neo4j.kernel.impl.transaction.log.LogVersionRepository;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.TargetDirectory;

public class PhysicalLogicalTransactionStoreTest {
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    @Rule
    public TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTest(this.getClass());
    private File testDir;

    @Before
    public void setup() {
        this.testDir = this.dir.graphDbDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldOpenCleanStore() throws Exception {
        DeadSimpleTransactionIdStore transactionIdStore = new DeadSimpleTransactionIdStore(0L, 0L);
        TransactionMetadataCache positionCache = new TransactionMetadataCache(10, 1000);
        LifeSupport life = new LifeSupport();
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.testDir, "neostore.transaction.db", this.fs);
        PhysicalLogFile.Monitor monitor = (PhysicalLogFile.Monitor)new Monitors().newMonitor(PhysicalLogFile.Monitor.class, new String[0]);
        LogFile logFile = (LogFile)life.add((Object)new PhysicalLogFile(this.fs, logFiles, 1000L, (TransactionIdStore)transactionIdStore, (LogVersionRepository)Mockito.mock(LogVersionRepository.class), monitor, positionCache));
        life.add((Object)new PhysicalLogicalTransactionStore(logFile, LogRotation.NO_ROTATION, positionCache, (TransactionIdStore)transactionIdStore, IdOrderingQueue.BYPASS, (KernelHealth)Mockito.mock(KernelHealth.class)));
        try {
            life.start();
        }
        finally {
            life.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldOpenAndRecoverExistingData() throws Exception {
        DeadSimpleTransactionIdStore transactionIdStore = new DeadSimpleTransactionIdStore(0L, 0L);
        TransactionMetadataCache positionCache = new TransactionMetadataCache(10, 100);
        final byte[] additionalHeader = new byte[]{1, 2, 5};
        int masterId = 2;
        boolean authorId = true;
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = 4545L;
        long timeCommitted = 12355L;
        LifeSupport life = new LifeSupport();
        final PhysicalLogFiles logFiles = new PhysicalLogFiles(this.testDir, "neostore.transaction.db", this.fs);
        PhysicalLogFile.Monitor monitor = (PhysicalLogFile.Monitor)new Monitors().newMonitor(PhysicalLogFile.Monitor.class, new String[0]);
        LogFile logFile = (LogFile)life.add((Object)new PhysicalLogFile(this.fs, logFiles, 1000L, (TransactionIdStore)transactionIdStore, (LogVersionRepository)Mockito.mock(LogVersionRepository.class), monitor, positionCache));
        life.start();
        try {
            this.addATransactionAndRewind(logFile, positionCache, transactionIdStore, additionalHeader, 2, 1, 12345L, 4545L, 12355L);
        }
        finally {
            life.shutdown();
        }
        life = new LifeSupport();
        final AtomicInteger recoveredTransactions = new AtomicInteger();
        final LogFileRecoverer recoverer = new LogFileRecoverer((LogEntryReader)new VersionAwareLogEntryReader(), (CloseableVisitor)new CloseableVisitor<CommittedTransactionRepresentation, IOException>(){

            public boolean visit(CommittedTransactionRepresentation committedTx) throws IOException {
                TransactionRepresentation transaction = committedTx.getTransactionRepresentation();
                Assert.assertArrayEquals((byte[])additionalHeader, (byte[])transaction.additionalHeader());
                Assert.assertEquals((long)2L, (long)transaction.getMasterId());
                Assert.assertEquals((long)1L, (long)transaction.getAuthorId());
                Assert.assertEquals((long)12345L, (long)transaction.getTimeStarted());
                Assert.assertEquals((long)12355L, (long)transaction.getTimeCommitted());
                Assert.assertEquals((long)4545L, (long)transaction.getLatestCommittedTxWhenStarted());
                recoveredTransactions.incrementAndGet();
                return false;
            }

            public void close() throws IOException {
            }
        });
        logFile = (LogFile)life.add((Object)new PhysicalLogFile(this.fs, logFiles, 1000L, (TransactionIdStore)transactionIdStore, (LogVersionRepository)Mockito.mock(LogVersionRepository.class), monitor, positionCache));
        PhysicalLogicalTransactionStore store = new PhysicalLogicalTransactionStore(logFile, LogRotation.NO_ROTATION, positionCache, (TransactionIdStore)transactionIdStore, IdOrderingQueue.BYPASS, (KernelHealth)Mockito.mock(KernelHealth.class));
        life.add((Object)store);
        life.add((Object)new Recovery(new Recovery.SPI(){

            public void forceEverything() {
            }

            public long getCurrentLogVersion() {
                return 0L;
            }

            public Visitor<LogVersionedStoreChannel, IOException> getRecoverer() {
                return recoverer;
            }

            public LogVersionedStoreChannel getLogFile(long recoveryVersion) throws IOException {
                return PhysicalLogFile.openForVersion((PhysicalLogFiles)logFiles, (FileSystemAbstraction)PhysicalLogicalTransactionStoreTest.this.fs, (long)recoveryVersion);
            }
        }, (Recovery.Monitor)Mockito.mock(Recovery.Monitor.class)));
        try {
            life.start();
        }
        finally {
            life.shutdown();
        }
        Assert.assertEquals((long)1L, (long)recoveredTransactions.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldExtractMetadataFromExistingTransaction() throws Exception {
        DeadSimpleTransactionIdStore transactionIdStore = new DeadSimpleTransactionIdStore(0L, 0L);
        TransactionMetadataCache positionCache = new TransactionMetadataCache(10, 100);
        final byte[] additionalHeader = new byte[]{1, 2, 5};
        int masterId = 2;
        boolean authorId = true;
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = 4545L;
        long timeCommitted = 12355L;
        LifeSupport life = new LifeSupport();
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.testDir, "neostore.transaction.db", this.fs);
        PhysicalLogFile.Monitor monitor = (PhysicalLogFile.Monitor)new Monitors().newMonitor(PhysicalLogFile.Monitor.class, new String[0]);
        LogFile logFile = (LogFile)life.add((Object)new PhysicalLogFile(this.fs, logFiles, 1000L, (TransactionIdStore)transactionIdStore, (LogVersionRepository)Mockito.mock(LogVersionRepository.class), monitor, positionCache));
        life.start();
        try {
            this.addATransactionAndRewind(logFile, positionCache, transactionIdStore, additionalHeader, 2, 1, 12345L, 4545L, 12355L);
        }
        finally {
            life.shutdown();
        }
        life = new LifeSupport();
        final AtomicInteger recoveredTransactions = new AtomicInteger();
        LogFileRecoverer recoverer = new LogFileRecoverer((LogEntryReader)new VersionAwareLogEntryReader(), (CloseableVisitor)new CloseableVisitor<CommittedTransactionRepresentation, IOException>(){

            public boolean visit(CommittedTransactionRepresentation committedTx) throws IOException {
                TransactionRepresentation transaction = committedTx.getTransactionRepresentation();
                Assert.assertArrayEquals((byte[])additionalHeader, (byte[])transaction.additionalHeader());
                Assert.assertEquals((long)2L, (long)transaction.getMasterId());
                Assert.assertEquals((long)1L, (long)transaction.getAuthorId());
                Assert.assertEquals((long)12345L, (long)transaction.getTimeStarted());
                Assert.assertEquals((long)12355L, (long)transaction.getTimeCommitted());
                Assert.assertEquals((long)4545L, (long)transaction.getLatestCommittedTxWhenStarted());
                recoveredTransactions.incrementAndGet();
                return false;
            }

            public void close() throws IOException {
            }
        });
        logFile = (LogFile)life.add((Object)new PhysicalLogFile(this.fs, logFiles, 1000L, (TransactionIdStore)transactionIdStore, (LogVersionRepository)Mockito.mock(LogVersionRepository.class), monitor, positionCache));
        LogicalTransactionStore store = (LogicalTransactionStore)life.add((Object)new PhysicalLogicalTransactionStore(logFile, LogRotation.NO_ROTATION, positionCache, (TransactionIdStore)transactionIdStore, IdOrderingQueue.BYPASS, (KernelHealth)Mockito.mock(KernelHealth.class)));
        life.start();
        try {
            recoverer.visit((LogVersionedStoreChannel)PhysicalLogFile.openForVersion((PhysicalLogFiles)logFiles, (FileSystemAbstraction)this.fs, (long)0L));
            positionCache.clear();
            Assert.assertThat((Object)store.getMetadataFor(transactionIdStore.getLastCommittedTransactionId()).toString(), (Matcher)CoreMatchers.equalTo((Object)"TransactionMetadata[masterId=-1, authorId=-1, startPosition=LogPosition{logVersion=0, byteOffset=16}, checksum=0]"));
        }
        finally {
            life.shutdown();
        }
    }

    @Test
    public void shouldThrowNoSuchTransactionExceptionIfMetadataNotFound() throws Exception {
        LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
        TransactionMetadataCache cache = new TransactionMetadataCache(10, 10);
        TransactionIdStore txIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFile, LogRotation.NO_ROTATION, cache, txIdStore, IdOrderingQueue.BYPASS, (KernelHealth)Mockito.mock(KernelHealth.class));
        try {
            txStore.getMetadataFor(10L);
            Assert.fail((String)"Should have thrown");
        }
        catch (NoSuchTransactionException e) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowNoSuchTransactionExceptionIfLogFileIsMissing() throws Exception {
        LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
        TransactionIdStore txIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)logFile.getReader((LogPosition)Matchers.any(LogPosition.class))).thenThrow(new Class[]{FileNotFoundException.class});
        TransactionMetadataCache cache = new TransactionMetadataCache(10, 10);
        cache.cacheTransactionMetadata(10L, new LogPosition(2L, 130L), 1, 1, 100L);
        PhysicalLogicalTransactionStore txStore = new PhysicalLogicalTransactionStore(logFile, LogRotation.NO_ROTATION, cache, txIdStore, IdOrderingQueue.BYPASS, (KernelHealth)Mockito.mock(KernelHealth.class));
        try {
            txStore.getTransactions(10L);
            Assert.fail();
        }
        catch (NoSuchTransactionException e) {
            // empty catch block
        }
    }

    private void addATransactionAndRewind(LogFile logFile, TransactionMetadataCache positionCache, TransactionIdStore transactionIdStore, byte[] additionalHeader, int masterId, int authorId, long timeStarted, long latestCommittedTxWhenStarted, long timeCommitted) throws IOException {
        BatchingTransactionAppender appender = new BatchingTransactionAppender(logFile, LogRotation.NO_ROTATION, positionCache, transactionIdStore, IdOrderingQueue.BYPASS, (KernelHealth)Mockito.mock(KernelHealth.class));
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(this.singleCreateNodeCommand());
        transaction.setHeader(additionalHeader, masterId, authorId, timeStarted, latestCommittedTxWhenStarted, timeCommitted, -1);
        appender.append((TransactionRepresentation)transaction, LogAppendEvent.NULL);
    }

    private Collection<Command> singleCreateNodeCommand() {
        ArrayList<Command> commands = new ArrayList<Command>();
        Command.NodeCommand command = new Command.NodeCommand();
        long id = 0L;
        NodeRecord before = new NodeRecord(id);
        NodeRecord after = new NodeRecord(id);
        after.setInUse(true);
        command.init(before, after);
        commands.add((Command)command);
        return commands;
    }
}

