/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FrozenClock;
import org.neo4j.kernel.impl.transaction.log.IllegalLogFormatException;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.TransactionTimespanThreshold;

public class TransactionTimespanThresholdTest {
    private final File file = (File)Mockito.mock(File.class);
    private final LogFileInformation source = (LogFileInformation)Mockito.mock(LogFileInformation.class);
    private final long version = 4L;

    @Test
    public void shouldReturnFalseWhenTimeIsEqualOrAfterTheLowerLimit() throws IOException {
        TransactionTimespanThreshold threshold = new TransactionTimespanThreshold((Clock)new FrozenClock(1000L), TimeUnit.MILLISECONDS, 200L);
        Mockito.when((Object)this.source.getFirstStartRecordTimestamp(4L)).thenReturn((Object)800L);
        threshold.init();
        boolean result = threshold.reached(this.file, 4L, this.source);
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void shouldReturnReturnWhenTimeIsBeforeTheLowerLimit() throws IOException {
        TransactionTimespanThreshold threshold = new TransactionTimespanThreshold((Clock)new FrozenClock(1000L), TimeUnit.MILLISECONDS, 100L);
        Mockito.when((Object)this.source.getFirstStartRecordTimestamp(4L)).thenReturn((Object)800L);
        threshold.init();
        boolean result = threshold.reached(this.file, 4L, this.source);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void shouldReturnTrueIfTheLogHasAnOlderVersion() throws IOException {
        TransactionTimespanThreshold threshold = new TransactionTimespanThreshold((Clock)new FrozenClock(1000L), TimeUnit.MILLISECONDS, 100L);
        Mockito.when((Object)this.source.getFirstStartRecordTimestamp(4L)).thenThrow(new Throwable[]{new IllegalLogFormatException(4L, 3L)});
        threshold.init();
        boolean result = threshold.reached(this.file, 4L, this.source);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void shouldThrowIfTheLogHasANewerVersion() throws IOException {
        TransactionTimespanThreshold threshold = new TransactionTimespanThreshold((Clock)new FrozenClock(1000L), TimeUnit.MILLISECONDS, 100L);
        IllegalLogFormatException ex = new IllegalLogFormatException(4L, 5L);
        Mockito.when((Object)this.source.getFirstStartRecordTimestamp(4L)).thenThrow(new Throwable[]{ex});
        threshold.init();
        try {
            threshold.reached(this.file, 4L, this.source);
            Assert.fail((String)"should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)ex, (Object)e.getCause());
        }
    }

    @Test
    public void shouldThrowIfTheLogCannotBeRead() throws IOException {
        TransactionTimespanThreshold threshold = new TransactionTimespanThreshold((Clock)new FrozenClock(1000L), TimeUnit.MILLISECONDS, 100L);
        IOException ex = new IOException();
        Mockito.when((Object)this.source.getFirstStartRecordTimestamp(4L)).thenThrow(new Throwable[]{ex});
        threshold.init();
        try {
            threshold.reached(this.file, 4L, this.source);
            Assert.fail((String)"should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)ex, (Object)e.getCause());
        }
    }
}

