/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NeoStoreMocking;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContextSupplier;

public class NeoStoreTransactionContextTest {
    @Test
    public void shouldClearRecordSetsOnClose() throws Exception {
        NeoStore mockStore = NeoStoreMocking.mockNeoStore();
        NeoStoreTransactionContextSupplier supplier = new NeoStoreTransactionContextSupplier(mockStore);
        NeoStoreTransactionContext toClose = new NeoStoreTransactionContext(supplier, mockStore);
        toClose.getNodeRecords().create((Object)1L, null).forChangingData();
        toClose.getRelGroupRecords().create((Object)2L, (Object)1).forChangingData();
        Assert.assertEquals((long)1L, (long)toClose.getNodeRecords().changeSize());
        Assert.assertEquals((long)0L, (long)toClose.getPropertyRecords().changeSize());
        Assert.assertEquals((long)1L, (long)toClose.getRelGroupRecords().changeSize());
        toClose.close();
        Assert.assertEquals((long)0L, (long)toClose.getNodeRecords().changeSize());
        Assert.assertEquals((long)0L, (long)toClose.getRelGroupRecords().changeSize());
    }

    @Test
    public void shouldCallReleaseOnClose() throws Exception {
        NeoStore mockStore = NeoStoreMocking.mockNeoStore();
        NeoStoreTransactionContextSupplier supplier = (NeoStoreTransactionContextSupplier)Mockito.spy((Object)new NeoStoreTransactionContextSupplier(mockStore));
        NeoStoreTransactionContext toClose = new NeoStoreTransactionContext(supplier, mockStore);
        toClose.close();
        ((NeoStoreTransactionContextSupplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.times((int)1))).release((Object)toClose);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{supplier});
    }
}

