/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.IOException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.kernel.impl.transaction.state.RecoveryVisitor;

public class RecoveryVisitorTest {
    private final TransactionIdStore store = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
    private final TransactionRepresentationStoreApplier storeApplier = (TransactionRepresentationStoreApplier)Mockito.mock(TransactionRepresentationStoreApplier.class);
    private final IndexUpdatesValidator indexUpdatesValidator = (IndexUpdatesValidator)Mockito.mock(IndexUpdatesValidator.class, (Answer)Mockito.RETURNS_MOCKS);
    private final RecoveryVisitor.Monitor monitor = (RecoveryVisitor.Monitor)Mockito.mock(RecoveryVisitor.Monitor.class);
    private final LogEntryStart startEntry = new LogEntryStart(1, 2, 123L, 456L, "tx".getBytes(), new LogPosition(1L, 198L));
    private final LogEntryCommit commitEntry = new OnePhaseCommit(42L, 0L);

    @Test
    public void shouldNotSetLastCommittedAndClosedTransactionIdWhenNoRecoveryHappened() throws IOException {
        RecoveryVisitor visitor = new RecoveryVisitor(this.store, this.storeApplier, this.indexUpdatesValidator, this.monitor);
        visitor.close();
        ((TransactionIdStore)Mockito.verify((Object)this.store, (VerificationMode)Mockito.never())).setLastCommittedAndClosedTransactionId(Matchers.anyLong(), Matchers.anyLong());
    }

    @Test
    public void shouldApplyVisitedTransactionToTheStoreAndSetLastCommittedAndClosedTransactionId() throws IOException {
        RecoveryVisitor visitor = new RecoveryVisitor(this.store, this.storeApplier, this.indexUpdatesValidator, this.monitor);
        PhysicalTransactionRepresentation representation = new PhysicalTransactionRepresentation(Collections.emptySet());
        CommittedTransactionRepresentation transaction = new CommittedTransactionRepresentation(this.startEntry, (TransactionRepresentation)representation, this.commitEntry);
        boolean result = visitor.visit(transaction);
        Assert.assertFalse((boolean)result);
        ((TransactionRepresentationStoreApplier)Mockito.verify((Object)this.storeApplier, (VerificationMode)Mockito.times((int)1))).apply((TransactionRepresentation)Matchers.eq((Object)representation), (ValidatedIndexUpdates)Matchers.any(ValidatedIndexUpdates.class), (LockGroup)Matchers.any(LockGroup.class), Matchers.eq((long)this.commitEntry.getTxId()), (TransactionApplicationMode)Matchers.eq((Object)TransactionApplicationMode.RECOVERY));
        ((RecoveryVisitor.Monitor)Mockito.verify((Object)this.monitor)).transactionRecovered(this.commitEntry.getTxId());
        visitor.close();
        ((TransactionIdStore)Mockito.verify((Object)this.store, (VerificationMode)Mockito.times((int)1))).setLastCommittedAndClosedTransactionId(this.commitEntry.getTxId(), LogEntryStart.checksum((LogEntryStart)this.startEntry));
    }
}

