/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.transaction.state.RecordChanges;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;

public class WriteTransactionCommandOrderingTest {
    private final AtomicReference<List<String>> currentRecording = new AtomicReference();
    private final RecordingRelationshipStore relationshipStore = new RecordingRelationshipStore(this.currentRecording);
    private final RecordingNodeStore nodeStore = new RecordingNodeStore(this.currentRecording);
    private final RecordingPropertyStore propertyStore = new RecordingPropertyStore(this.currentRecording);
    private final NeoStore store = (NeoStore)Mockito.mock(NeoStore.class);

    public WriteTransactionCommandOrderingTest() {
        Mockito.when((Object)this.store.getPropertyStore()).thenReturn((Object)this.propertyStore);
        Mockito.when((Object)this.store.getNodeStore()).thenReturn((Object)this.nodeStore);
        Mockito.when((Object)this.store.getRelationshipStore()).thenReturn((Object)this.relationshipStore);
    }

    private static RelationshipRecord missingRelationship() {
        return new RelationshipRecord(-1L);
    }

    private static RelationshipRecord createdRelationship() {
        RelationshipRecord record = new RelationshipRecord(2L);
        record.setInUse(true);
        record.setCreated();
        return record;
    }

    private static RelationshipRecord inUseRelationship() {
        RelationshipRecord record = new RelationshipRecord(1L);
        record.setInUse(true);
        return record;
    }

    private static PropertyRecord missingProperty() {
        return new PropertyRecord(-1L);
    }

    private static PropertyRecord createdProperty() {
        PropertyRecord record = new PropertyRecord(2L);
        record.setInUse(true);
        record.setCreated();
        return record;
    }

    private static PropertyRecord inUseProperty() {
        PropertyRecord record = new PropertyRecord(1L);
        record.setInUse(true);
        return record;
    }

    private static NodeRecord missingNode() {
        return new NodeRecord(-1L, false, -1L, -1L);
    }

    private static NodeRecord createdNode() {
        NodeRecord record = new NodeRecord(2L, false, -1L, -1L);
        record.setInUse(true);
        record.setCreated();
        return record;
    }

    private static NodeRecord inUseNode() {
        NodeRecord record = new NodeRecord(1L, false, -1L, -1L);
        record.setInUse(true);
        return record;
    }

    private static String commandActionToken(AbstractBaseRecord record) {
        if (!record.inUse()) {
            return "deleted";
        }
        if (record.isCreated()) {
            return "created";
        }
        return "updated";
    }

    @Test
    public void shouldExecuteCommandsInTheSameOrderRegardlessOfItBeingRecoveredOrNot() throws Exception {
        TransactionRecordState tx = this.injectAllPossibleCommands();
        PhysicalTransactionRepresentation commands = this.transactionRepresentationOf(tx);
        commands.accept((Visitor)new NeoCommandHandler.HandlerVisitor((NeoCommandHandler)new OrderVerifyingCommandHandler()));
    }

    private PhysicalTransactionRepresentation transactionRepresentationOf(TransactionRecordState tx) throws TransactionFailureException {
        ArrayList commands = new ArrayList();
        tx.extractCommands(commands);
        return new PhysicalTransactionRepresentation(commands);
    }

    private TransactionRecordState injectAllPossibleCommands() {
        NeoStoreTransactionContext context = (NeoStoreTransactionContext)Mockito.mock(NeoStoreTransactionContext.class);
        RecordChanges labelTokenChanges = (RecordChanges)Mockito.mock(RecordChanges.class);
        RecordChanges relationshipTypeTokenChanges = (RecordChanges)Mockito.mock(RecordChanges.class);
        RecordChanges propertyKeyTokenChanges = (RecordChanges)Mockito.mock(RecordChanges.class);
        RecordChanges nodeRecordChanges = (RecordChanges)Mockito.mock(RecordChanges.class);
        RecordChanges relationshipRecordChanges = (RecordChanges)Mockito.mock(RecordChanges.class);
        RecordChanges propertyRecordChanges = (RecordChanges)Mockito.mock(RecordChanges.class);
        RecordChanges relationshipGroupChanges = (RecordChanges)Mockito.mock(RecordChanges.class);
        RecordChanges schemaRuleChanges = (RecordChanges)Mockito.mock(RecordChanges.class);
        Mockito.when((Object)context.getLabelTokenRecords()).thenReturn((Object)labelTokenChanges);
        Mockito.when((Object)context.getRelationshipTypeTokenRecords()).thenReturn((Object)relationshipTypeTokenChanges);
        Mockito.when((Object)context.getPropertyKeyTokenRecords()).thenReturn((Object)propertyKeyTokenChanges);
        Mockito.when((Object)context.getNodeRecords()).thenReturn((Object)nodeRecordChanges);
        Mockito.when((Object)context.getRelRecords()).thenReturn((Object)relationshipRecordChanges);
        Mockito.when((Object)context.getPropertyRecords()).thenReturn((Object)propertyRecordChanges);
        Mockito.when((Object)context.getRelGroupRecords()).thenReturn((Object)relationshipGroupChanges);
        Mockito.when((Object)context.getSchemaRuleChanges()).thenReturn((Object)schemaRuleChanges);
        LinkedList<RecordChanges.RecordChange> nodeChanges = new LinkedList<RecordChanges.RecordChange>();
        RecordChanges.RecordChange deletedNode = (RecordChanges.RecordChange)Mockito.mock(RecordChanges.RecordChange.class);
        Mockito.when((Object)deletedNode.getBefore()).thenReturn((Object)WriteTransactionCommandOrderingTest.inUseNode());
        Mockito.when((Object)deletedNode.forReadingLinkage()).thenReturn((Object)WriteTransactionCommandOrderingTest.missingNode());
        nodeChanges.add(deletedNode);
        RecordChanges.RecordChange createdNode = (RecordChanges.RecordChange)Mockito.mock(RecordChanges.RecordChange.class);
        Mockito.when((Object)createdNode.getBefore()).thenReturn((Object)WriteTransactionCommandOrderingTest.missingNode());
        Mockito.when((Object)createdNode.forReadingLinkage()).thenReturn((Object)WriteTransactionCommandOrderingTest.createdNode());
        nodeChanges.add(createdNode);
        RecordChanges.RecordChange updatedNode = (RecordChanges.RecordChange)Mockito.mock(RecordChanges.RecordChange.class);
        Mockito.when((Object)updatedNode.getBefore()).thenReturn((Object)WriteTransactionCommandOrderingTest.inUseNode());
        Mockito.when((Object)updatedNode.forReadingLinkage()).thenReturn((Object)WriteTransactionCommandOrderingTest.inUseNode());
        nodeChanges.add(updatedNode);
        Mockito.when((Object)nodeRecordChanges.changes()).thenReturn(nodeChanges);
        Mockito.when((Object)nodeRecordChanges.changeSize()).thenReturn((Object)3);
        Mockito.when((Object)labelTokenChanges.changes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)relationshipTypeTokenChanges.changes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)propertyKeyTokenChanges.changes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)relationshipRecordChanges.changes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)propertyRecordChanges.changes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)relationshipGroupChanges.changes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)schemaRuleChanges.changes()).thenReturn(Collections.emptyList());
        return new TransactionRecordState((NeoStore)Mockito.mock(NeoStore.class), (IntegrityValidator)Mockito.mock(IntegrityValidator.class), context);
    }

    private static class OrderVerifyingCommandHandler
    extends NeoCommandHandler.Adapter {
        private boolean nodeVisited;
        private boolean relationshipVisited;
        private boolean propertyVisited;
        private boolean created;
        private boolean updated;
        private boolean deleted;

        private OrderVerifyingCommandHandler() {
        }

        public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
            if (!this.nodeVisited) {
                this.created = false;
                this.updated = false;
                this.deleted = false;
            }
            this.nodeVisited = true;
            Assert.assertFalse((boolean)this.relationshipVisited);
            Assert.assertFalse((boolean)this.propertyVisited);
            switch (command.getMode()) {
                case CREATE: {
                    this.created = true;
                    Assert.assertFalse((boolean)this.updated);
                    Assert.assertFalse((boolean)this.deleted);
                    break;
                }
                case UPDATE: {
                    this.updated = true;
                    Assert.assertFalse((boolean)this.deleted);
                    break;
                }
                case DELETE: {
                    this.deleted = true;
                }
            }
            return false;
        }
    }

    private static class RecordingRelationshipStore
    extends RelationshipStore {
        private final AtomicReference<List<String>> currentRecording;

        public RecordingRelationshipStore(AtomicReference<List<String>> currentRecording) {
            super(null, new Config(), null, null, null, null, null, null);
            this.currentRecording = currentRecording;
        }

        public void updateRecord(RelationshipRecord record) {
            this.currentRecording.get().add(WriteTransactionCommandOrderingTest.commandActionToken((AbstractBaseRecord)record) + " relationship");
        }

        protected void checkStorage() {
        }

        protected void checkVersion() {
        }

        protected void loadStorage() {
        }
    }

    private static class RecordingNodeStore
    extends NodeStore {
        private final AtomicReference<List<String>> currentRecording;

        public RecordingNodeStore(AtomicReference<List<String>> currentRecording) {
            super(null, new Config(), null, null, null, null, null, null, null);
            this.currentRecording = currentRecording;
        }

        public void updateRecord(NodeRecord record) {
            this.currentRecording.get().add(WriteTransactionCommandOrderingTest.commandActionToken((AbstractBaseRecord)record) + " node");
        }

        protected void checkStorage() {
        }

        protected void checkVersion() {
        }

        protected void loadStorage() {
        }

        public NodeRecord getRecord(long id) {
            NodeRecord record = new NodeRecord(id, false, -1L, -1L);
            record.setInUse(true);
            return record;
        }
    }

    private static class RecordingPropertyStore
    extends PropertyStore {
        private final AtomicReference<List<String>> currentRecording;

        public RecordingPropertyStore(AtomicReference<List<String>> currentRecording) {
            super(null, new Config(), null, null, null, null, null, null, null, null, null);
            this.currentRecording = currentRecording;
        }

        public void updateRecord(PropertyRecord record) {
            this.currentRecording.get().add(WriteTransactionCommandOrderingTest.commandActionToken((AbstractBaseRecord)record) + " property");
        }

        protected void checkStorage() {
        }

        protected void checkVersion() {
        }

        protected void loadStorage() {
        }
    }
}

