/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.impl.util.CappedOperation;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.LogMarker;
import org.neo4j.test.TargetDirectory;

public class StringLoggerTest {
    private final FileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();
    @Rule
    public final TestName testName = new TestName();

    @Test
    public void makeSureLogsAreRotated() throws Exception {
        String path = "target/test-data/stringlogger";
        FileUtils.deleteRecursively((File)new File(path));
        File logFile = new File(path, "messages.log");
        File oldFile = new File(path, "messages.log.1");
        File oldestFile = new File(path, "messages.log.2");
        StringLogger logger = StringLogger.loggerDirectory((FileSystemAbstraction)this.fileSystem, (File)new File(path), (int)204800, (boolean)false);
        Assert.assertFalse((boolean)this.fileSystem.fileExists(oldFile));
        int counter = 0;
        String prefix = "Bogus message ";
        while (!this.fileSystem.fileExists(oldFile)) {
            logger.info(prefix + counter++, true);
        }
        int mark1 = counter - 1;
        logger.info(prefix + counter++, true);
        Assert.assertTrue((boolean)this.firstLineOfFile(oldFile).contains(prefix + "0"));
        Assert.assertTrue((boolean)((String)this.lastLineOfFile(oldFile).first()).contains(prefix + mark1));
        Assert.assertTrue((boolean)this.firstLineOfFile(logFile).contains(prefix + (counter - 1)));
        while (!this.fileSystem.fileExists(oldestFile)) {
            logger.info(prefix + counter++, true);
        }
        int mark2 = counter - 1;
        logger.info(prefix + counter++, true);
        Assert.assertTrue((boolean)this.firstLineOfFile(oldestFile).contains(prefix + "0"));
        Assert.assertTrue((boolean)((String)this.lastLineOfFile(oldestFile).first()).contains(prefix + mark1));
        Assert.assertTrue((boolean)this.firstLineOfFile(oldFile).contains(prefix + (mark1 + 1)));
        Assert.assertTrue((boolean)((String)this.lastLineOfFile(oldFile).first()).contains(prefix + mark2));
        Assert.assertTrue((boolean)this.firstLineOfFile(logFile).contains(prefix + (counter - 1)));
        long previousSize = 0L;
        while (true) {
            logger.info(prefix + counter++, true);
            if (this.fileSystem.getFileSize(logFile) < previousSize) break;
            previousSize = this.fileSystem.getFileSize(logFile);
        }
        Assert.assertFalse((boolean)this.fileSystem.fileExists(new File(path, "messages.log.3")));
        Assert.assertTrue((boolean)this.firstLineOfFile(oldestFile).contains(prefix + (mark1 + 1)));
        Assert.assertTrue((boolean)((String)this.lastLineOfFile(oldestFile).first()).contains(prefix + mark2));
    }

    @Test
    public void makeSureRotationDoesNotRecurse() throws Exception {
        String baseMessage = "base message";
        File target = TargetDirectory.forTest(StringLoggerTest.class).cleanDirectory("recursionTest");
        final StringLogger logger = StringLogger.loggerDirectory((FileSystemAbstraction)this.fileSystem, (File)target, (int)"base message".length(), (boolean)false);
        Runnable trigger = new Runnable(){

            @Override
            public void run() {
                logger.info("base message from trigger", true);
            }
        };
        logger.addRotationListener(trigger);
        logger.info("base message from main", true);
        File rotated = new File(target, "messages.log.1");
        Assert.assertTrue((String)"rotated file not present, should have been created", (boolean)this.fileSystem.fileExists(rotated));
        Pair<String, Integer> rotatedInfo = this.lastLineOfFile(rotated);
        Assert.assertTrue((String)"rotated file should have only stuff from main", (((String)rotatedInfo.first()).endsWith(" from main") && (Integer)rotatedInfo.other() == 1 ? 1 : 0) != 0);
        File current = new File(target, "messages.log");
        Assert.assertTrue((String)"should have created a new messages.log file", (boolean)this.fileSystem.fileExists(current));
        Pair<String, Integer> currentInfo = this.lastLineOfFile(current);
        Assert.assertTrue((String)"current file should have only stuff from trigger", (((String)currentInfo.first()).endsWith(" from trigger") && (Integer)currentInfo.other() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void shouldLogDebugMessagesIfToldTo() throws Exception {
        File target = TargetDirectory.forTest(StringLoggerTest.class).cleanDirectory("debug");
        StringLogger logger = StringLogger.loggerDirectory((FileSystemAbstraction)this.fileSystem, (File)target, (int)0x6400000, (boolean)true);
        String firstMessage = "First message";
        String secondMessage = "Second message";
        String thirdMessage = "Third message";
        logger.debug(firstMessage);
        logger.debug(secondMessage, (Throwable)new RuntimeException(thirdMessage));
        logger.close();
        File logFile = new File(target, "messages.log");
        Assert.assertTrue((String)("Should have contained " + firstMessage), (boolean)this.fileContains(logFile, this.stringContaining(firstMessage)));
        Assert.assertTrue((String)("Should have contained " + secondMessage), (boolean)this.fileContains(logFile, this.stringContaining(secondMessage)));
        Assert.assertTrue((String)("Should have contained " + thirdMessage), (boolean)this.fileContains(logFile, this.stringContaining(thirdMessage)));
        Assert.assertTrue((String)("Should have contained stack trace from " + thirdMessage), (boolean)this.fileContains(logFile, (Predicate<String>)Predicates.and((Predicate[])new Predicate[]{this.stringContaining("at "), this.stringContaining(this.testName.getMethodName())})));
    }

    @Test
    public void cappedLoggerShouldIgnoreSubsequentMessagesWithinTimeInterval() {
        StringBuffer buffer = new StringBuffer();
        StringLogger delegate = StringLogger.wrap((StringBuffer)buffer);
        FakeClock fakeClock = new FakeClock();
        StringLogger cappedLogger = StringLoggerTest.cappedLogger(delegate, (CappedOperation.Switch<String>)CappedOperation.time((Clock)fakeClock, (long)1L, (TimeUnit)TimeUnit.MILLISECONDS));
        fakeClock.forward(1L, TimeUnit.MILLISECONDS);
        cappedLogger.info("f1rst");
        cappedLogger.info("s3cond");
        fakeClock.forward(1L, TimeUnit.MILLISECONDS);
        cappedLogger.info("th1rd");
        String output = buffer.toString();
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"f1rst"));
        Assert.assertThat((Object)output, (Matcher)Matchers.containsString((String)"th1rd"));
        Assert.assertThat((Object)output, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"s3cond")));
    }

    private static StringLogger cappedLogger(final StringLogger delegate, final CappedOperation.Switch<String> capSwitch) {
        return new StringLogger(){

            protected void doDebug(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
                if (capSwitch.accept((Object)msg)) {
                    delegate.doDebug(msg, cause, flush, logMarker);
                    capSwitch.reset();
                }
            }

            public void info(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
                if (capSwitch.accept((Object)msg)) {
                    delegate.info(msg, cause, flush, logMarker);
                    capSwitch.reset();
                }
            }

            public void warn(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
                if (capSwitch.accept((Object)msg)) {
                    delegate.warn(msg, cause, flush, logMarker);
                    capSwitch.reset();
                }
            }

            public void error(String msg, Throwable cause, boolean flush, LogMarker logMarker) {
                if (capSwitch.accept((Object)msg)) {
                    delegate.error(msg, cause, flush, logMarker);
                    capSwitch.reset();
                }
            }

            public void logLongMessage(String msg, Visitor<StringLogger.LineLogger, RuntimeException> source, boolean flush) {
                if (capSwitch.accept((Object)msg)) {
                    delegate.logLongMessage(msg, source, flush);
                }
            }

            public void addRotationListener(Runnable listener) {
                delegate.addRotationListener(listener);
            }

            public void flush() {
                delegate.flush();
            }

            public void close() {
                delegate.close();
            }

            protected void logLine(String line) {
                if (capSwitch.accept((Object)line)) {
                    delegate.logLine(line);
                }
            }
        };
    }

    private Predicate<String> stringContaining(final String string) {
        return new Predicate<String>(){

            public boolean accept(String item) {
                return item.contains(string);
            }
        };
    }

    private String firstLineOfFile(File file) throws Exception {
        BufferedReader reader = new BufferedReader(this.fileSystem.openAsReader(file, Charset.defaultCharset().name()));
        String result = reader.readLine();
        reader.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fileContains(File file, Predicate<String> predicate) throws IOException {
        try (BufferedReader reader = new BufferedReader(this.fileSystem.openAsReader(file, Charset.defaultCharset().name()));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!predicate.accept((Object)line)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private Pair<String, Integer> lastLineOfFile(File file) throws Exception {
        int count = 0;
        BufferedReader reader = new BufferedReader(this.fileSystem.openAsReader(file, Charset.defaultCharset().name()));
        String line = null;
        String result = null;
        while ((line = reader.readLine()) != null) {
            result = line;
            ++count;
        }
        reader.close();
        return Pair.of((Object)result, (Object)count);
    }
}

