/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureVisitor;
import org.neo4j.kernel.impl.util.dbstructure.GraphDbStructureGuide;
import org.neo4j.test.ImpermanentDatabaseRule;

public class GraphDbStructureGuideTest {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    private GraphDatabaseService graph;
    private ThreadToStatementContextBridge bridge;
    private Transaction tx;

    @Test
    public void visitsLabelIds() throws Exception {
        DbStructureVisitor visitor = (DbStructureVisitor)Mockito.mock(DbStructureVisitor.class);
        int personLabelId = this.createLabel("Person");
        int partyLabelId = this.createLabel("Party");
        int animalLabelId = this.createLabel("Animal");
        this.accept(visitor);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitLabel(personLabelId, "Person");
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitLabel(partyLabelId, "Party");
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitLabel(animalLabelId, "Animal");
    }

    @Test
    public void visitsPropertyKeyIds() throws Exception {
        DbStructureVisitor visitor = (DbStructureVisitor)Mockito.mock(DbStructureVisitor.class);
        int nameId = this.createPropertyKey("name");
        int ageId = this.createPropertyKey("age");
        int osId = this.createPropertyKey("os");
        this.accept(visitor);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitPropertyKey(nameId, "name");
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitPropertyKey(ageId, "age");
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitPropertyKey(osId, "os");
    }

    @Test
    public void visitsRelationshipTypeIds() throws Exception {
        DbStructureVisitor visitor = (DbStructureVisitor)Mockito.mock(DbStructureVisitor.class);
        int knowsId = this.createRelTypeId("KNOWS");
        int lovesId = this.createRelTypeId("LOVES");
        int fawnsAtId = this.createRelTypeId("FAWNS_AT");
        this.accept(visitor);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelationshipType(knowsId, "KNOWS");
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelationshipType(lovesId, "LOVES");
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelationshipType(fawnsAtId, "FAWNS_AT");
    }

    @Test
    public void visitsIndexes() throws Exception {
        DbStructureVisitor visitor = (DbStructureVisitor)Mockito.mock(DbStructureVisitor.class);
        int labelId = this.createLabel("Person");
        int pkId = this.createPropertyKey("name");
        this.commitAndReOpen();
        IndexDescriptor descriptor = this.createSchemaIndex(labelId, pkId);
        this.accept(visitor);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitIndex(descriptor, ":Person(name)", 1.0);
    }

    @Test
    public void visitsUniqueConstraintsAndIndices() throws Exception {
        DbStructureVisitor visitor = (DbStructureVisitor)Mockito.mock(DbStructureVisitor.class);
        int labelId = this.createLabel("Person");
        int pkId = this.createPropertyKey("name");
        this.commitAndReOpen();
        UniquenessConstraint constraint = this.createUniqueConstraint(labelId, pkId);
        IndexDescriptor descriptor = new IndexDescriptor(labelId, pkId);
        this.accept(visitor);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitUniqueIndex(descriptor, ":Person(name)", 1.0);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitUniqueConstraint(constraint, "CONSTRAINT ON ( person:Person ) ASSERT person.name IS UNIQUE");
    }

    @Test
    public void visitsNodeCounts() throws Exception {
        DbStructureVisitor visitor = (DbStructureVisitor)Mockito.mock(DbStructureVisitor.class);
        int personLabelId = this.createLabeledNodes("Person", 40);
        int partyLabelId = this.createLabeledNodes("Party", 20);
        int animalLabelId = this.createLabeledNodes("Animal", 30);
        this.accept(visitor);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitAllNodesCount(90L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitNodeCount(personLabelId, "Person", 40L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitNodeCount(partyLabelId, "Party", 20L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitNodeCount(animalLabelId, "Animal", 30L);
    }

    @Test
    public void visitsRelCounts() throws Exception {
        DbStructureVisitor visitor = (DbStructureVisitor)Mockito.mock(DbStructureVisitor.class);
        int personLabelId = this.createLabeledNodes("Person", 40);
        int partyLabelId = this.createLabeledNodes("Party", 20);
        int knowsId = this.createRelTypeId("KNOWS");
        int lovesId = this.createRelTypeId("LOVES");
        long personNode = this.createLabeledNode(personLabelId);
        long partyNode = this.createLabeledNode(partyLabelId);
        this.createRel(personNode, knowsId, personNode);
        this.accept(visitor);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, knowsId, -1, "MATCH ()-[:KNOWS]->() RETURN count(*)", 1L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, lovesId, -1, "MATCH ()-[:LOVES]->() RETURN count(*)", 0L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, -1, -1, "MATCH ()-[]->() RETURN count(*)", 1L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(personLabelId, knowsId, -1, "MATCH (:Person)-[:KNOWS]->() RETURN count(*)", 1L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, knowsId, personLabelId, "MATCH ()-[:KNOWS]->(:Person) RETURN count(*)", 1L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(personLabelId, lovesId, -1, "MATCH (:Person)-[:LOVES]->() RETURN count(*)", 0L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, lovesId, personLabelId, "MATCH ()-[:LOVES]->(:Person) RETURN count(*)", 0L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(personLabelId, -1, -1, "MATCH (:Person)-[]->() RETURN count(*)", 1L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, -1, personLabelId, "MATCH ()-[]->(:Person) RETURN count(*)", 1L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(partyLabelId, knowsId, -1, "MATCH (:Party)-[:KNOWS]->() RETURN count(*)", 0L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, knowsId, partyLabelId, "MATCH ()-[:KNOWS]->(:Party) RETURN count(*)", 0L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(partyLabelId, lovesId, -1, "MATCH (:Party)-[:LOVES]->() RETURN count(*)", 0L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, lovesId, partyLabelId, "MATCH ()-[:LOVES]->(:Party) RETURN count(*)", 0L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(partyLabelId, -1, -1, "MATCH (:Party)-[]->() RETURN count(*)", 0L);
        ((DbStructureVisitor)Mockito.verify((Object)visitor)).visitRelCount(-1, -1, partyLabelId, "MATCH ()-[]->(:Party) RETURN count(*)", 0L);
    }

    private void createRel(long startId, int relTypeId, long endId) throws Exception {
        this.dataWrite().relationshipCreate(relTypeId, startId, endId);
    }

    private IndexDescriptor createSchemaIndex(int labelId, int pkId) throws Exception {
        return this.schemaWrite().indexCreate(labelId, pkId);
    }

    private UniquenessConstraint createUniqueConstraint(int labelId, int pkId) throws Exception {
        return this.schemaWrite().uniquenessConstraintCreate(labelId, pkId);
    }

    private int createLabeledNodes(String labelName, int amount) throws Exception {
        int labelId = this.createLabel(labelName);
        for (int i = 0; i < amount; ++i) {
            this.createLabeledNode(labelId);
        }
        return labelId;
    }

    private long createLabeledNode(int labelId) throws Exception {
        long nodeId = this.dataWrite().nodeCreate();
        this.dataWrite().nodeAddLabel(nodeId, labelId);
        return nodeId;
    }

    private int createLabel(String name) throws Exception {
        return this.dataWrite().labelGetOrCreateForName(name);
    }

    private int createPropertyKey(String name) throws Exception {
        return this.dataWrite().propertyKeyGetOrCreateForName(name);
    }

    private int createRelTypeId(String name) throws Exception {
        return this.dataWrite().relationshipTypeGetOrCreateForName(name);
    }

    @Before
    public void setUp() throws InvalidTransactionTypeKernelException {
        GraphDatabaseAPI api = this.dbRule.getGraphDatabaseAPI();
        this.graph = api;
        DependencyResolver dependencyResolver = api.getDependencyResolver();
        this.bridge = (ThreadToStatementContextBridge)dependencyResolver.resolveDependency(ThreadToStatementContextBridge.class);
        this.tx = this.graph.beginTx();
    }

    @After
    public void tearDown() {
        if (this.bridge.hasTransaction()) {
            this.statement().close();
            this.tx.failure();
            this.tx.close();
        }
    }

    private Statement statement() {
        return this.bridge.instance();
    }

    private ReadOperations read() {
        return this.statement().readOperations();
    }

    private DataWriteOperations dataWrite() throws Exception {
        return this.statement().dataWriteOperations();
    }

    private SchemaWriteOperations schemaWrite() throws Exception {
        return this.statement().schemaWriteOperations();
    }

    public void commitAndReOpen() {
        this.commit();
        this.tx = this.graph.beginTx();
    }

    public void accept(DbStructureVisitor visitor) {
        this.commitAndReOpen();
        this.graph.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
        this.commit();
        if (this.bridge.hasTransaction()) {
            throw new IllegalStateException("Dangling transaction before running visitable");
        }
        GraphDbStructureGuide analyzer = new GraphDbStructureGuide(this.graph);
        analyzer.accept(visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit() {
        try {
            this.statement().close();
            this.tx.success();
        }
        finally {
            this.tx.close();
        }
    }
}

