/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring.tracing;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.tracing.Tracers;

public class TracersTest {
    private StringLogger msgLog;
    private StringBuffer logBuffer;

    @Before
    public void setUp() {
        this.logBuffer = new StringBuffer();
        this.msgLog = StringLogger.wrap((StringBuffer)this.logBuffer);
        System.setProperty("org.neo4j.helpers.Service.printServiceLoaderStackTraces", "true");
    }

    @Test
    public void mustProduceNullImplementationsWhenRequested() throws Exception {
        Tracers tracers = new Tracers("null", this.msgLog);
        Assert.assertThat((Object)tracers.pageCacheTracer, (Matcher)Matchers.is((Object)PageCacheTracer.NULL));
        Assert.assertThat((Object)tracers.transactionTracer, (Matcher)Matchers.is((Object)TransactionTracer.NULL));
        this.assertNoWarning();
    }

    @Test
    public void mustProduceNullImplementationsWhenRequestedIgnoringCase() throws Exception {
        Tracers tracers = new Tracers("NuLl", this.msgLog);
        Assert.assertThat((Object)tracers.pageCacheTracer, (Matcher)Matchers.is((Object)PageCacheTracer.NULL));
        Assert.assertThat((Object)tracers.transactionTracer, (Matcher)Matchers.is((Object)TransactionTracer.NULL));
        this.assertNoWarning();
    }

    @Test
    public void mustProduceDefaultImplementationForNullConfiguration() throws Exception {
        Tracers tracers = new Tracers(null, this.msgLog);
        this.assertDefaultImplementation(tracers);
        this.assertNoWarning();
    }

    @Test
    public void mustProduceDefaultImplementationWhenRequested() throws Exception {
        Tracers tracers = new Tracers("default", this.msgLog);
        this.assertDefaultImplementation(tracers);
        this.assertNoWarning();
    }

    @Test
    public void mustProduceDefaultImplementationWhenRequestedIgnoringCase() throws Exception {
        Tracers tracers = new Tracers("DeFaUlT", this.msgLog);
        this.assertDefaultImplementation(tracers);
        this.assertNoWarning();
    }

    @Test
    public void mustProduceDefaultImplementationWhenRequestingUnknownImplementation() throws Exception {
        Tracers tracers = new Tracers("there's nothing like this", this.msgLog);
        this.assertDefaultImplementation(tracers);
        this.assertWarning();
    }

    private void assertDefaultImplementation(Tracers tracers) {
        Assert.assertThat((Object)tracers.pageCacheTracer, (Matcher)Matchers.instanceOf(DefaultPageCacheTracer.class));
        Assert.assertThat((Object)tracers.transactionTracer, (Matcher)Matchers.is((Object)TransactionTracer.NULL));
    }

    private void assertNoWarning() {
        Assert.assertThat((Object)this.logBuffer.toString(), (Matcher)Matchers.is((Object)""));
    }

    private void assertWarning() {
        Assert.assertThat((Object)this.logBuffer.toString(), (Matcher)Matchers.not((Matcher)Matchers.is((Object)"")));
    }
}

