/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.SubProcess;

public class SubProcessTest {
    private static final String MESSAGE = "message";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void canInvokeSubprocessMethod() throws Exception {
        Callable subprocess = (Callable)new TestingProcess().start(MESSAGE, new BreakPoint[0]);
        try {
            Assert.assertEquals((Object)MESSAGE, subprocess.call());
        }
        finally {
            SubProcess.stop(subprocess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void canDebugSubprocess() throws Exception {
        final AtomicBoolean called = new AtomicBoolean(false);
        Callable proc = (Callable)new TestingProcess().start(MESSAGE, new BreakPoint(TestingProcess.class, "call", new Class[0]){

            @Override
            protected void callback(DebugInterface debug) {
                called.set(true);
            }
        }.enable());
        try {
            Assert.assertEquals((Object)MESSAGE, proc.call());
            Assert.assertTrue((String)"breakpoint callback never reached", (boolean)called.get());
        }
        finally {
            SubProcess.stop(proc);
        }
    }

    @Ignore(value="not reliable - the processes do exit though")
    @Test
    public void subprocessShouldExitWhenParentProcessExits() throws Exception {
        CallbackImpl callback = new CallbackImpl();
        Object proc = new ParentProcess().start(callback, new BreakPoint[0]);
        Assert.assertTrue((String)"Subprocess didn't exit properly", (boolean)callback.isCalled(10, TimeUnit.SECONDS));
        SubProcess.kill(proc);
    }

    private static class ChildProcess
    extends SubProcess<Object, Handover> {
        private Callback callback;

        private ChildProcess() {
        }

        @Override
        protected synchronized void startup(Handover parameter) throws Throwable {
            this.callback = parameter.handOver();
        }

        @Override
        protected synchronized void shutdown(boolean normal) {
            try {
                this.callback.callBack();
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class ParentProcess
    extends SubProcess<Object, Callback> {
        private ParentProcess() {
        }

        @Override
        protected void startup(Callback parameter) throws Throwable {
            HandoverImpl handover = new HandoverImpl(parameter);
            new ChildProcess().start(handover, new BreakPoint[0]);
            handover.isCalled(5, TimeUnit.SECONDS);
            this.shutdown();
        }
    }

    private static class HandoverImpl
    extends UnicastRemoteObject
    implements Handover {
        private volatile boolean called = false;
        private final Callback callback;

        protected HandoverImpl(Callback callback) throws RemoteException {
            this.callback = callback;
        }

        @Override
        public Callback handOver() throws RemoteException {
            this.called = true;
            return this.callback;
        }

        boolean isCalled(int timeout, TimeUnit unit) throws InterruptedException {
            long end = System.currentTimeMillis() + unit.toMillis(timeout);
            while (!this.called && System.currentTimeMillis() < end) {
                Thread.sleep(1L);
            }
            return this.called;
        }
    }

    private static class CallbackImpl
    extends UnicastRemoteObject
    implements Callback {
        private volatile boolean called = false;

        protected CallbackImpl() throws RemoteException {
        }

        boolean isCalled(int timeout, TimeUnit unit) throws InterruptedException {
            long end = System.currentTimeMillis() + unit.toMillis(timeout);
            while (!this.called && System.currentTimeMillis() < end) {
                Thread.sleep(1L);
            }
            return this.called;
        }

        @Override
        public void callBack() {
            this.called = true;
        }
    }

    private static interface Handover
    extends Remote {
        public Callback handOver() throws RemoteException;
    }

    private static interface Callback
    extends Remote {
        public void callBack() throws RemoteException;
    }

    private static class TestingProcess
    extends SubProcess<Callable<String>, String>
    implements Callable<String> {
        private String message;
        private volatile transient boolean started = false;

        private TestingProcess() {
        }

        @Override
        protected void startup(String parameter) {
            this.message = parameter;
            this.started = true;
        }

        @Override
        public String call() throws Exception {
            while (!this.started) {
                Thread.sleep(1L);
            }
            return this.message;
        }
    }
}

