/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.test.GraphDatabaseServiceCleaner;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.tooling.GlobalGraphOperations;

public class TestImpermanentGraphDatabase {
    private ImpermanentGraphDatabase db;

    @Before
    public void createDb() {
        this.db = (ImpermanentGraphDatabase)new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @After
    public void tearDown() {
        this.db.shutdown();
    }

    @Test
    public void should_keep_data_between_start_and_shutdown() {
        this.createNode();
        Assert.assertEquals((String)"Expected one new node", (long)1L, (long)this.nodeCount());
    }

    @Test
    public void data_should_not_survive_shutdown() {
        this.createNode();
        this.db.shutdown();
        this.createDb();
        Assert.assertEquals((String)"Should not see anything.", (long)0L, (long)this.nodeCount());
    }

    @Test
    public void should_remove_all_data() {
        try (Transaction tx = this.db.beginTx();){
            DynamicRelationshipType relationshipType = DynamicRelationshipType.withName((String)"R");
            Node n1 = this.db.createNode();
            Node n2 = this.db.createNode();
            Node n3 = this.db.createNode();
            n1.createRelationshipTo(n2, (RelationshipType)relationshipType);
            n2.createRelationshipTo(n1, (RelationshipType)relationshipType);
            n3.createRelationshipTo(n1, (RelationshipType)relationshipType);
            tx.success();
        }
        GraphDatabaseServiceCleaner.cleanDatabaseContent((GraphDatabaseService)this.db);
        Assert.assertThat((Object)this.nodeCount(), (Matcher)Matchers.is((Object)0));
    }

    private int nodeCount() {
        Transaction transaction = this.db.beginTx();
        int count = IteratorUtil.count((Iterable)GlobalGraphOperations.at((GraphDatabaseService)this.db).getAllNodes());
        transaction.close();
        return count;
    }

    private void createNode() {
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode();
            tx.success();
        }
    }
}

