/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DoubleLatch {
    private static final int FIVE_MINUTES = 300000;
    private final CountDownLatch startSignal;
    private final CountDownLatch finishSignal;
    private final int numberOfContestants;

    public DoubleLatch() {
        this(1);
    }

    public DoubleLatch(int numberOfContestants) {
        this.numberOfContestants = numberOfContestants;
        this.startSignal = new CountDownLatch(numberOfContestants);
        this.finishSignal = new CountDownLatch(numberOfContestants);
    }

    public int getNumberOfContestants() {
        return this.numberOfContestants;
    }

    public void startAndAwaitFinish() {
        this.start();
        DoubleLatch.awaitLatch(this.finishSignal);
    }

    public void awaitStart() {
        DoubleLatch.awaitLatch(this.startSignal);
    }

    public void start() {
        this.startSignal.countDown();
        DoubleLatch.awaitLatch(this.startSignal);
    }

    public void finish() {
        this.finishSignal.countDown();
    }

    public void awaitFinish() {
        DoubleLatch.awaitLatch(this.finishSignal);
    }

    public static void awaitLatch(CountDownLatch latch) {
        long remaining;
        long deadline = System.currentTimeMillis() + 300000L;
        while ((remaining = deadline - System.currentTimeMillis()) >= 0L) {
            try {
                latch.await(remaining, TimeUnit.MILLISECONDS);
                return;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                new RuntimeException("Thread interrupted while waiting on latch", e).printStackTrace();
                Thread.yield();
            }
        }
        throw new RuntimeException("Failed to acquire latch");
    }

    public String toString() {
        return super.toString() + "[Start[" + this.startSignal.getCount() + "], Finish[" + this.finishSignal.getCount() + "]]";
    }
}

