/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.junit.rules.ExternalResource;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.DatabaseRule;

public class GraphTransactionRule
extends ExternalResource {
    private final DatabaseRule database;
    private Transaction tx;

    public GraphTransactionRule(DatabaseRule database) {
        this.database = database;
    }

    protected void before() throws Throwable {
        this.begin();
    }

    protected void after() {
        this.success();
        this.database.clearCache();
    }

    public Transaction current() {
        return this.tx;
    }

    public Transaction begin() {
        this.tx = this.database.getGraphDatabaseService().beginTx();
        return this.tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void success() {
        try {
            if (this.tx != null) {
                this.tx.success();
                this.tx.finish();
            }
        }
        finally {
            this.tx = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failure() {
        try {
            if (this.tx != null) {
                this.tx.failure();
                this.tx.finish();
            }
        }
        finally {
            this.tx = null;
        }
    }
}

