/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.helpers.Clock;

public class InputStreamAwaiter {
    private final InputStream input;
    private final byte[] bytes = new byte[1024];
    private final Clock clock;
    private static final String NEW_LINE = System.getProperty("line.separator");

    public InputStreamAwaiter(InputStream input) {
        this(Clock.SYSTEM_CLOCK, input);
    }

    public InputStreamAwaiter(Clock clock, InputStream input) {
        this.clock = clock;
        this.input = input;
    }

    public void awaitLine(String expectedLine, long timeout, TimeUnit unit) throws IOException, TimeoutException, InterruptedException {
        long deadline = this.clock.currentTimeMillis() + unit.toMillis(timeout);
        StringBuilder buffer = new StringBuilder();
        while (true) {
            String[] lines;
            if (this.input.available() > 0) {
                buffer.append(new String(this.bytes, 0, this.input.read(this.bytes)));
                continue;
            }
            for (String line : lines = buffer.toString().split(NEW_LINE)) {
                if (!expectedLine.equals(line)) continue;
                return;
            }
            Thread.sleep(10L);
            if (this.clock.currentTimeMillis() >= deadline) break;
        }
        throw new TimeoutException("Timed out waiting to read line: [" + expectedLine + "]. Seen input:\n\t" + buffer.toString().replaceAll("\n", "\n\t"));
    }
}

