/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerRule
extends ExternalResource {
    private Logger logger;
    private String testName;

    protected void before() throws Throwable {
        this.logger.info("Begin test:" + this.testName);
        super.before();
    }

    protected void after() {
        super.after();
        this.logger.info("Finished test:" + this.testName);
    }

    public Statement apply(Statement base, Description description) {
        this.testName = description.getDisplayName();
        this.logger = LoggerFactory.getLogger((Class)description.getTestClass());
        return super.apply(base, description);
    }

    public Logger getLogger() {
        return this.logger;
    }
}

