/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.lang.reflect.Array;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.helpers.ArrayUtil;

public class Randoms {
    public static final Configuration DEFAULT = new Default();
    public static final int CS_LOWERCASE_LETTERS = 1;
    public static final int CS_UPPERCASE_LETTERS = 2;
    public static final int CS_DIGITS = 3;
    public static final int CS_SYMBOLS = 4;
    public static final int CSA_LETTERS = 3;
    public static final int CSA_LETTERS_AND_DIGITS = 3;
    private final Random random;
    private final Configuration configuration;

    public Randoms() {
        this(ThreadLocalRandom.current(), DEFAULT);
    }

    public Randoms(Random random, Configuration configuration) {
        this.random = random;
        this.configuration = configuration;
    }

    public Randoms fork(Configuration configuration) {
        return new Randoms(this.random, configuration);
    }

    public Random random() {
        return this.random;
    }

    public int intBetween(int min, int max) {
        return min + this.random.nextInt(max - min + 1);
    }

    public String string() {
        return this.string(this.configuration.stringMinLength(), this.configuration.stringMaxLength(), this.configuration.stringCharacterSets());
    }

    public String string(int minLength, int maxLength, int characterSets) {
        char[] chars = new char[this.intBetween(minLength, maxLength)];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = this.character(characterSets);
        }
        return String.valueOf(chars);
    }

    public char character(int characterSets) {
        int bit;
        int setCount = Integer.bitCount(characterSets);
        while ((characterSets & (bit = 1 << this.random.nextInt(setCount))) == 0) {
        }
        switch (bit) {
            case 1: {
                return (char)this.intBetween(97, 122);
            }
            case 2: {
                return (char)this.intBetween(65, 90);
            }
            case 3: {
                return (char)this.intBetween(48, 57);
            }
            case 4: {
                return this.symbol();
            }
        }
        throw new IllegalArgumentException("Unknown character set " + bit);
    }

    public <T> T[] selection(T[] among, int min, int max, boolean allowDuplicates) {
        int length = min + this.random.nextInt(max - min);
        Object[] result = (Object[])Array.newInstance(among.getClass().getComponentType(), length);
        for (int i = 0; i < length; ++i) {
            T candidate;
            do {
                candidate = this.among(among);
            } while (!allowDuplicates && ArrayUtil.contains((Object[])result, candidate));
            result[i] = candidate;
        }
        return result;
    }

    public <T> T among(T[] among) {
        return among[this.random.nextInt(among.length)];
    }

    public Object propertyValue() {
        return this.propertyValue(this.propertyType(true));
    }

    private byte propertyType(boolean allowArrays) {
        return (byte)this.random.nextInt(allowArrays ? 10 : 9);
    }

    private Object propertyValue(byte type) {
        switch (type) {
            case 0: {
                return this.random.nextBoolean();
            }
            case 1: {
                return (byte)this.random.nextInt();
            }
            case 2: {
                return (short)this.random.nextInt();
            }
            case 3: {
                return Character.valueOf(this.character(3));
            }
            case 4: {
                return this.random.nextInt();
            }
            case 5: {
                return this.random.nextLong();
            }
            case 6: {
                return Float.valueOf(this.random.nextFloat());
            }
            case 7: {
                return this.random.nextDouble();
            }
            case 8: {
                return this.string();
            }
            case 9: {
                int length = this.intBetween(this.configuration.arrayMinLength(), this.configuration.arrayMaxLength());
                byte componentType = this.propertyType(false);
                Object itemType = this.propertyValue(componentType);
                Object array = Array.newInstance(itemType.getClass(), length);
                for (int i = 0; i < length; ++i) {
                    Array.set(array, i, this.propertyValue(componentType));
                }
                return array;
            }
        }
        throw new IllegalArgumentException("Unknown value type " + type);
    }

    private char symbol() {
        int range = this.random.nextInt(5);
        switch (range) {
            case 0: {
                return (char)this.intBetween(33, 47);
            }
            case 1: {
                return (char)this.intBetween(58, 64);
            }
            case 2: {
                return (char)this.intBetween(91, 96);
            }
            case 3: {
                return (char)this.intBetween(123, 126);
            }
            case 4: {
                return ' ';
            }
        }
        throw new IllegalArgumentException("Unknown symbol range " + range);
    }

    public static class Default
    implements Configuration {
        @Override
        public int stringMinLength() {
            return 5;
        }

        @Override
        public int stringMaxLength() {
            return 20;
        }

        @Override
        public int stringCharacterSets() {
            return 3;
        }

        @Override
        public int arrayMinLength() {
            return 1;
        }

        @Override
        public int arrayMaxLength() {
            return 10;
        }
    }

    public static interface Configuration {
        public int stringMinLength();

        public int stringMaxLength();

        public int stringCharacterSets();

        public int arrayMinLength();

        public int arrayMaxLength();
    }
}

