/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.subprocess;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.LocatableEvent;
import java.io.PrintStream;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.SubProcess;

public class DebugInterface {
    private final LocatableEvent event;
    private final SubProcess.DebugDispatch debug;

    DebugInterface(SubProcess.DebugDispatch debug, LocatableEvent event) {
        this.debug = debug;
        this.event = event;
    }

    public boolean matchCallingMethod(int offset, Class<?> owner, String method) {
        try {
            Location location = this.event.thread().frame(offset).location();
            if (owner != null && !owner.getName().equals(location.declaringType().name())) {
                return false;
            }
            return method == null || method.equals(location.method().name());
        }
        catch (IncompatibleThreadStateException e) {
            return false;
        }
    }

    public DebuggedThread thread() {
        return new DebuggedThread(this.debug, this.event.thread());
    }

    public void printStackTrace(PrintStream out) {
        this.thread().printStackTrace(out);
    }

    public Object getLocalVariable(String name) {
        try {
            StackFrame frame = this.event.thread().frame(0);
            return this.fromMirror(frame.getValue(frame.visibleVariableByName(name)));
        }
        catch (IncompatibleThreadStateException e) {
            throw new IllegalStateException(e);
        }
        catch (AbsentInformationException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setLocalVariable(String name, Object value) {
        try {
            StackFrame frame = this.event.thread().frame(0);
            LocalVariable local = frame.visibleVariableByName(name);
            frame.setValue(local, this.mirror(value));
        }
        catch (IncompatibleThreadStateException e) {
            throw new IllegalStateException(e);
        }
        catch (AbsentInformationException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidTypeException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotLoadedException e) {
            throw new IllegalStateException(e);
        }
    }

    private Value mirror(Object value) {
        VirtualMachine vm = this.event.virtualMachine();
        if (value == null) {
            return vm.mirrorOfVoid();
        }
        if (value instanceof String) {
            return vm.mirrorOf((String)value);
        }
        if (value instanceof Integer) {
            return vm.mirrorOf((Integer)value);
        }
        if (value instanceof Long) {
            return vm.mirrorOf((Long)value);
        }
        if (value instanceof Double) {
            return vm.mirrorOf((Double)value);
        }
        if (value instanceof Boolean) {
            return vm.mirrorOf((Boolean)value);
        }
        if (value instanceof Byte) {
            return vm.mirrorOf((Byte)value);
        }
        if (value instanceof Character) {
            return vm.mirrorOf(((Character)value).charValue());
        }
        if (value instanceof Short) {
            return vm.mirrorOf((Short)value);
        }
        if (value instanceof Float) {
            return vm.mirrorOf(((Float)value).floatValue());
        }
        throw new IllegalArgumentException("Cannot mirror: " + value);
    }

    private Object fromMirror(Value value) {
        if (value instanceof VoidValue) {
            return null;
        }
        if (value instanceof StringReference) {
            return ((StringReference)value).value();
        }
        if (value instanceof IntegerValue) {
            return ((IntegerValue)value).intValue();
        }
        if (value instanceof LongValue) {
            return ((LongValue)value).longValue();
        }
        if (value instanceof DoubleValue) {
            return ((DoubleValue)value).doubleValue();
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).booleanValue();
        }
        if (value instanceof ByteValue) {
            return ((ByteValue)value).byteValue();
        }
        if (value instanceof CharValue) {
            return Character.valueOf(((CharValue)value).charValue());
        }
        if (value instanceof ShortValue) {
            return ((ShortValue)value).shortValue();
        }
        if (value instanceof FloatValue) {
            return Float.valueOf(((FloatValue)value).floatValue());
        }
        return value.toString();
    }
}

