/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.PropertyEncoderStep;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPageCache;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;
import org.neo4j.unsafe.impl.batchimport.store.io.Monitor;

public class PropertyEncoderStepTest {
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private NeoStore neoStore;
    private BatchingPageCache pageCache;

    @Before
    public void setUpNeoStore() {
        File storeDir = new File("dir");
        this.pageCache = new BatchingPageCache((FileSystemAbstraction)this.fsRule.get(), 1000, 1, BatchingPageCache.SYNCHRONOUS, Monitor.NO_MONITOR);
        this.neoStore = new StoreFactory((FileSystemAbstraction)this.fsRule.get(), storeDir, (PageCache)this.pageCache, StringLogger.DEV_NULL, new Monitors()).createNeoStore();
    }

    @After
    public void closeNeoStore() throws IOException {
        this.neoStore.close();
        this.pageCache.close();
    }

    @Test
    public void shouldGrowPropertyBlocksArrayProperly() throws Exception {
        StageControl control = (StageControl)Mockito.mock(StageControl.class);
        BatchingTokenRepository.BatchingPropertyKeyTokenRepository tokens = new BatchingTokenRepository.BatchingPropertyKeyTokenRepository((TokenStore)this.neoStore.getPropertyKeyTokenStore(), 0);
        PropertyEncoderStep step = new PropertyEncoderStep(control, Configuration.DEFAULT, tokens, this.neoStore.getPropertyStore());
        Step downstream = (Step)Mockito.mock(Step.class);
        step.setDownstream(downstream);
        step.start(0);
        step.receive(0L, this.smallbatch());
        step.endOfUpstream();
        this.awaitCompleted((Step<?>)step, control);
        ((Step)Mockito.verify((Object)downstream)).receive(Matchers.anyLong(), Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{control});
    }

    private void awaitCompleted(Step<?> step, StageControl control) throws InterruptedException {
        while (!step.isCompleted()) {
            Thread.sleep(10L);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{control});
        }
    }

    private Batch<InputNode, NodeRecord> smallbatch() {
        return new Batch((Object[])new InputNode[]{new InputNode("source", 1L, 0L, (Object)"1", new Object[]{"key1", "value1", "key2", "value2", "key3", "value3", "key4", "value4", "key5", "value5"}, null, new String[]{"label1", "label2", "label3", "label4"}, null)});
    }
}

