/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.csv.reader.CharReadable;
import org.neo4j.csv.reader.Readables;
import org.neo4j.function.Factory;
import org.neo4j.function.Function;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputEntityDecorators;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.UpdateBehaviour;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactories;
import org.neo4j.unsafe.impl.batchimport.input.csv.ExternalPropertiesDecorator;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;

public class ExternalPropertiesDecoratorTest {
    @Test
    public void shouldCombineNodesWithExternalPropertiesFile() throws Exception {
        String propertyData = ":ID,email:string\n1,mattias@some.com\n1,mattiasp@someother.com\n3,chris@abc\n4,dude@yo";
        Configuration.Overriden config = this.config();
        IdType idType = IdType.STRING;
        ExternalPropertiesDecorator externalPropertiesDecorator = new ExternalPropertiesDecorator(DataFactories.data((Function)InputEntityDecorators.NO_NODE_DECORATOR, this.readable(propertyData)), DataFactories.defaultFormatNodeFileHeader(), (Configuration)config, idType, UpdateBehaviour.ADD);
        this.assertProperties((InputNode)externalPropertiesDecorator.apply((Object)this.node("1", "key", "value1")), "key", "value1", "email", new String[]{"mattias@some.com", "mattiasp@someother.com"});
        this.assertProperties((InputNode)externalPropertiesDecorator.apply((Object)this.node("2", "key", "value2")), "key", "value2");
        this.assertProperties((InputNode)externalPropertiesDecorator.apply((Object)this.node("3", "key", "value3")), "key", "value3", "email", "chris@abc");
        this.assertProperties((InputNode)externalPropertiesDecorator.apply((Object)this.node("4", "key", "value4")), "key", "value4", "email", "dude@yo");
    }

    @Test
    public void shouldCombineNodesWithExternalPropertyArraysFile() throws Exception {
        String propertyData = ":ID,email:string[]\n1,mattias@some.com;mattiasp@someother.com\n3,chris@abc\n4,dude@yo";
        Configuration.Overriden config = this.config();
        IdType idType = IdType.STRING;
        ExternalPropertiesDecorator externalPropertiesDecorator = new ExternalPropertiesDecorator(DataFactories.data((Function)InputEntityDecorators.NO_NODE_DECORATOR, this.readable(propertyData)), DataFactories.defaultFormatNodeFileHeader(), (Configuration)config, idType, UpdateBehaviour.ADD);
        this.assertProperties((InputNode)externalPropertiesDecorator.apply((Object)this.node("1", "key", "value1", "email", "existing")), "key", "value1", "email", new String[]{"existing", "mattias@some.com", "mattiasp@someother.com"});
        this.assertProperties((InputNode)externalPropertiesDecorator.apply((Object)this.node("2", "key", "value2")), "key", "value2");
        this.assertProperties((InputNode)externalPropertiesDecorator.apply((Object)this.node("3", "key", "value3")), "key", "value3", "email", new String[]{"chris@abc"});
        this.assertProperties((InputNode)externalPropertiesDecorator.apply((Object)this.node("4", "key", "value4")), "key", "value4", "email", new String[]{"dude@yo"});
    }

    private void assertProperties(InputNode decoratedNode, Object ... expectedKeyValuePairs) {
        Map expectedProperties = MapUtil.map((Object[])expectedKeyValuePairs);
        Map properties = MapUtil.map((Object[])decoratedNode.properties());
        Assert.assertEquals((String)properties.toString(), (long)expectedProperties.size(), (long)properties.size());
        for (Map.Entry expectedProperty : expectedProperties.entrySet()) {
            Object value = properties.get(expectedProperty.getKey());
            Assert.assertNotNull(value);
            Assert.assertEquals(expectedProperty.getValue().getClass(), value.getClass());
            if (value.getClass().isArray()) {
                Assert.assertArrayEquals((Object[])((Object[])expectedProperty.getValue()), (Object[])((Object[])value));
                continue;
            }
            Assert.assertEquals(expectedProperty.getValue(), value);
        }
    }

    private InputNode node(Object id, Object ... props) {
        return new InputNode("source", 1L, 0L, id, props, null, InputEntity.NO_LABELS, null);
    }

    private Factory<CharReadable> readable(final String data) {
        return new Factory<CharReadable>(){

            public CharReadable newInstance() {
                return Readables.wrap((Reader)new StringReader(data));
            }
        };
    }

    private Configuration.Overriden config() {
        return new Configuration.Overriden(Configuration.COMMAS){

            public int bufferSize() {
                return 1000;
            }
        };
    }
}

