/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStore;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPageCache;
import org.neo4j.unsafe.impl.batchimport.store.io.Monitor;

public class BatchingNeoStoreTest {
    @Rule
    public final EphemeralFileSystemRule fsr = new EphemeralFileSystemRule();
    private final File storeDir = new File("dir");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotOpenStoreWithNodesOrRelationshipsInIt() throws Exception {
        this.someDataInTheDatabase();
        try (BatchingPageCache pageCache = new BatchingPageCache((FileSystemAbstraction)this.fsr.get(), 10000, 1, BatchingPageCache.SYNCHRONOUS, Monitor.NO_MONITOR);){
            new BatchingNeoStore((FileSystemAbstraction)this.fsr.get(), this.storeDir, Configuration.DEFAULT, Monitor.NO_MONITOR, (Logging)new DevNullLoggingService(), new Monitors(), BatchingPageCache.SYNCHRONOUS, AdditionalInitialIds.EMPTY);
            Assert.fail((String)"Should fail on existing data");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void someDataInTheDatabase() {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fsr.get()).newImpermanentDatabase(this.storeDir.getAbsolutePath());
        try (Transaction tx = db.beginTx();){
            db.createNode().createRelationshipTo(db.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }
}

