/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.util.SimplePool;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.OtherThreadRule;

public class SimplePoolTest {
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule();

    @Test
    public void shouldWaitForFreeItem() throws Exception {
        final SimplePool pool = new SimplePool((Object[])this.items(2));
        Item first = (Item)pool.acquire();
        Assert.assertEquals((long)0L, (long)first.id);
        Item second = (Item)pool.acquire();
        Assert.assertEquals((long)1L, (long)second.id);
        Future<Item> thirdFuture = this.t2.execute(new OtherThreadExecutor.WorkerCommand<Void, Item>(){

            @Override
            public Item doWork(Void state) throws Exception {
                return (Item)pool.acquire();
            }
        });
        Assert.assertThat(this.t2, OtherThreadRule.isThreadState(Thread.State.TIMED_WAITING));
        pool.release((Object)first);
        Item third = thirdFuture.get();
        Assert.assertEquals((long)0L, (long)third.id);
    }

    @Test
    public void shouldNotRelyOnAcquireReleaseOrdering() {
        SimplePool pool = new SimplePool((Object[])this.items(2));
        Item first = (Item)pool.acquire();
        Item second = (Item)pool.acquire();
        pool.release((Object)second);
        Assert.assertNotEquals((Object)first, (Object)pool.acquire());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenNonPooledObjectIsReleased() {
        SimplePool pool = new SimplePool((Object[])this.items(2));
        pool.release((Object)new Item(42));
    }

    private Item[] items(int length) {
        Item[] items = new Item[length];
        for (int i = 0; i < length; ++i) {
            items[i] = new Item(i);
        }
        return items;
    }

    private static class Item {
        final int id;

        Item(int id) {
            this.id = id;
        }
    }
}

