/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntObjectVisitor;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongObjectVisitor;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.community.LockManagerImpl;
import org.neo4j.kernel.impl.locking.community.LockResource;
import org.neo4j.kernel.impl.locking.community.LockTransaction;

public class CommunityLockClient
implements Locks.Client {
    private final LockManagerImpl manager;
    private final LockTransaction lockTransaction = new LockTransaction();
    private final PrimitiveIntObjectMap<PrimitiveLongObjectMap<LockResource>> sharedLocks = Primitive.intObjectMap();
    private final PrimitiveIntObjectMap<PrimitiveLongObjectMap<LockResource>> exclusiveLocks = Primitive.intObjectMap();
    private final PrimitiveIntObjectVisitor<PrimitiveLongObjectMap<LockResource>, RuntimeException> typeReadReleaser = new PrimitiveIntObjectVisitor<PrimitiveLongObjectMap<LockResource>, RuntimeException>(){

        public boolean visited(int key, PrimitiveLongObjectMap<LockResource> value) throws RuntimeException {
            value.visitEntries(CommunityLockClient.this.readReleaser);
            return false;
        }
    };
    private final PrimitiveIntObjectVisitor<PrimitiveLongObjectMap<LockResource>, RuntimeException> typeWriteReleaser = new PrimitiveIntObjectVisitor<PrimitiveLongObjectMap<LockResource>, RuntimeException>(){

        public boolean visited(int key, PrimitiveLongObjectMap<LockResource> value) throws RuntimeException {
            value.visitEntries(CommunityLockClient.this.writeReleaser);
            return false;
        }
    };
    private final PrimitiveLongObjectVisitor<LockResource, RuntimeException> writeReleaser = new PrimitiveLongObjectVisitor<LockResource, RuntimeException>(){

        public boolean visited(long key, LockResource lockResource) throws RuntimeException {
            CommunityLockClient.this.manager.releaseWriteLock(lockResource, CommunityLockClient.this.lockTransaction);
            return false;
        }
    };
    private final PrimitiveLongObjectVisitor<LockResource, RuntimeException> readReleaser = new PrimitiveLongObjectVisitor<LockResource, RuntimeException>(){

        public boolean visited(long key, LockResource lockResource) throws RuntimeException {
            CommunityLockClient.this.manager.releaseReadLock(lockResource, CommunityLockClient.this.lockTransaction);
            return false;
        }
    };

    public CommunityLockClient(LockManagerImpl manager) {
        this.manager = manager;
    }

    @Override
    public void acquireShared(Locks.ResourceType resourceType, long ... resourceIds) {
        PrimitiveLongObjectMap<LockResource> localLocks = this.localShared(resourceType);
        for (long resourceId : resourceIds) {
            LockResource resource = (LockResource)localLocks.get(resourceId);
            if (resource != null) {
                resource.acquireReference();
                continue;
            }
            resource = new LockResource(resourceType, resourceId);
            this.manager.getReadLock(resource, this.lockTransaction);
            localLocks.put(resourceId, (Object)resource);
        }
    }

    @Override
    public void acquireExclusive(Locks.ResourceType resourceType, long ... resourceIds) {
        PrimitiveLongObjectMap<LockResource> localLocks = this.localExclusive(resourceType);
        for (long resourceId : resourceIds) {
            LockResource resource = (LockResource)localLocks.get(resourceId);
            if (resource != null) {
                resource.acquireReference();
                continue;
            }
            resource = new LockResource(resourceType, resourceId);
            this.manager.getWriteLock(resource, this.lockTransaction);
            localLocks.put(resourceId, (Object)resource);
        }
    }

    @Override
    public boolean tryExclusiveLock(Locks.ResourceType resourceType, long ... resourceIds) {
        PrimitiveLongObjectMap<LockResource> localLocks = this.localExclusive(resourceType);
        for (long resourceId : resourceIds) {
            LockResource resource = (LockResource)localLocks.get(resourceId);
            if (resource != null) {
                resource.acquireReference();
                continue;
            }
            resource = new LockResource(resourceType, resourceId);
            if (this.manager.tryWriteLock(resource, this.lockTransaction)) {
                localLocks.put(resourceId, (Object)resource);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean trySharedLock(Locks.ResourceType resourceType, long ... resourceIds) {
        PrimitiveLongObjectMap<LockResource> localLocks = this.localShared(resourceType);
        for (long resourceId : resourceIds) {
            LockResource resource = (LockResource)localLocks.get(resourceId);
            if (resource != null) {
                resource.acquireReference();
                continue;
            }
            resource = new LockResource(resourceType, resourceId);
            if (this.manager.tryReadLock(resource, this.lockTransaction)) {
                localLocks.put(resourceId, (Object)resource);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public void releaseShared(Locks.ResourceType resourceType, long ... resourceIds) {
        PrimitiveLongObjectMap<LockResource> localLocks = this.localShared(resourceType);
        for (long resourceId : resourceIds) {
            LockResource resource = (LockResource)localLocks.get(resourceId);
            if (resource.releaseReference() != 0) continue;
            localLocks.remove(resourceId);
            this.manager.releaseReadLock(new LockResource(resourceType, resourceId), this.lockTransaction);
        }
    }

    @Override
    public void releaseExclusive(Locks.ResourceType resourceType, long ... resourceIds) {
        PrimitiveLongObjectMap<LockResource> localLocks = this.localExclusive(resourceType);
        for (long resourceId : resourceIds) {
            LockResource resource = (LockResource)localLocks.get(resourceId);
            if (resource.releaseReference() != 0) continue;
            localLocks.remove(resourceId);
            this.manager.releaseWriteLock(new LockResource(resourceType, resourceId), this.lockTransaction);
        }
    }

    @Override
    public void releaseAllShared() {
        this.sharedLocks.visitEntries(this.typeReadReleaser);
        this.sharedLocks.clear();
    }

    @Override
    public void releaseAllExclusive() {
        this.exclusiveLocks.visitEntries(this.typeWriteReleaser);
        this.exclusiveLocks.clear();
    }

    @Override
    public void releaseAll() {
        this.releaseAllExclusive();
        this.releaseAllShared();
    }

    @Override
    public void close() {
        this.releaseAll();
    }

    @Override
    public int getLockSessionId() {
        return this.lockTransaction.getId();
    }

    private PrimitiveLongObjectMap<LockResource> localShared(Locks.ResourceType resourceType) {
        PrimitiveLongObjectMap map = (PrimitiveLongObjectMap)this.sharedLocks.get(resourceType.typeId());
        if (map == null) {
            map = Primitive.longObjectMap();
            this.sharedLocks.put(resourceType.typeId(), (Object)map);
        }
        return map;
    }

    private PrimitiveLongObjectMap<LockResource> localExclusive(Locks.ResourceType resourceType) {
        PrimitiveLongObjectMap map = (PrimitiveLongObjectMap)this.exclusiveLocks.get(resourceType.typeId());
        if (map == null) {
            map = Primitive.longObjectMap();
            this.exclusiveLocks.put(resourceType.typeId(), (Object)map);
        }
        return map;
    }

    public String toString() {
        return String.format("%s[%d]", this.getClass().getSimpleName(), this.getLockSessionId());
    }
}

