/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;

public class Loaders {
    public static RecordAccess.Loader<Long, NodeRecord, Void> nodeLoader(final NodeStore store) {
        return new RecordAccess.Loader<Long, NodeRecord, Void>(){

            @Override
            public NodeRecord newUnused(Long key, Void additionalData) {
                return Loaders.andMarkAsCreated(new NodeRecord(key, false, Record.NO_NEXT_RELATIONSHIP.intValue(), Record.NO_NEXT_PROPERTY.intValue()));
            }

            @Override
            public NodeRecord load(Long key, Void additionalData) {
                return store.getRecord(key);
            }

            @Override
            public void ensureHeavy(NodeRecord record) {
                store.ensureHeavy(record);
            }

            @Override
            public NodeRecord clone(NodeRecord nodeRecord) {
                return nodeRecord.clone();
            }
        };
    }

    public static RecordAccess.Loader<Long, PropertyRecord, PrimitiveRecord> propertyLoader(final PropertyStore store) {
        return new RecordAccess.Loader<Long, PropertyRecord, PrimitiveRecord>(){

            @Override
            public PropertyRecord newUnused(Long key, PrimitiveRecord additionalData) {
                PropertyRecord record = new PropertyRecord(key);
                this.setOwner(record, additionalData);
                return Loaders.andMarkAsCreated(record);
            }

            private void setOwner(PropertyRecord record, PrimitiveRecord owner) {
                if (owner != null) {
                    owner.setIdTo(record);
                }
            }

            @Override
            public PropertyRecord load(Long key, PrimitiveRecord additionalData) {
                PropertyRecord record = store.getRecord(key);
                this.setOwner(record, additionalData);
                return record;
            }

            @Override
            public void ensureHeavy(PropertyRecord record) {
                for (PropertyBlock block : record) {
                    store.ensureHeavy(block);
                }
            }

            @Override
            public PropertyRecord clone(PropertyRecord propertyRecord) {
                return propertyRecord.clone();
            }
        };
    }

    public static RecordAccess.Loader<Long, RelationshipRecord, Void> relationshipLoader(final RelationshipStore store) {
        return new RecordAccess.Loader<Long, RelationshipRecord, Void>(){

            @Override
            public RelationshipRecord newUnused(Long key, Void additionalData) {
                return Loaders.andMarkAsCreated(new RelationshipRecord(key));
            }

            @Override
            public RelationshipRecord load(Long key, Void additionalData) {
                return store.getRecord(key);
            }

            @Override
            public void ensureHeavy(RelationshipRecord record) {
            }

            @Override
            public RelationshipRecord clone(RelationshipRecord relationshipRecord) {
                throw new UnsupportedOperationException("Unexpected call to clone on a relationshipRecord");
            }
        };
    }

    public static RecordAccess.Loader<Long, RelationshipGroupRecord, Integer> relationshipGroupLoader(final RelationshipGroupStore store) {
        return new RecordAccess.Loader<Long, RelationshipGroupRecord, Integer>(){

            @Override
            public RelationshipGroupRecord newUnused(Long key, Integer type) {
                return Loaders.andMarkAsCreated(new RelationshipGroupRecord(key, type));
            }

            @Override
            public RelationshipGroupRecord load(Long key, Integer type) {
                return store.getRecord(key);
            }

            @Override
            public void ensureHeavy(RelationshipGroupRecord record) {
            }

            @Override
            public RelationshipGroupRecord clone(RelationshipGroupRecord record) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static RecordAccess.Loader<Long, Collection<DynamicRecord>, SchemaRule> schemaRuleLoader(final SchemaStore store) {
        return new RecordAccess.Loader<Long, Collection<DynamicRecord>, SchemaRule>(){

            @Override
            public Collection<DynamicRecord> newUnused(Long key, SchemaRule additionalData) {
                return store.allocateFrom(additionalData);
            }

            @Override
            public Collection<DynamicRecord> load(Long key, SchemaRule additionalData) {
                return store.getRecords(key);
            }

            @Override
            public void ensureHeavy(Collection<DynamicRecord> dynamicRecords) {
                for (DynamicRecord record : dynamicRecords) {
                    store.ensureHeavy(record);
                }
            }

            @Override
            public Collection<DynamicRecord> clone(Collection<DynamicRecord> dynamicRecords) {
                ArrayList<DynamicRecord> list = new ArrayList<DynamicRecord>(dynamicRecords.size());
                for (DynamicRecord record : dynamicRecords) {
                    list.add(record.clone());
                }
                return list;
            }
        };
    }

    public static RecordAccess.Loader<Integer, PropertyKeyTokenRecord, Void> propertyKeyTokenLoader(final TokenStore<PropertyKeyTokenRecord> store) {
        return new RecordAccess.Loader<Integer, PropertyKeyTokenRecord, Void>(){

            @Override
            public PropertyKeyTokenRecord newUnused(Integer key, Void additionalData) {
                return Loaders.andMarkAsCreated(new PropertyKeyTokenRecord(key));
            }

            @Override
            public PropertyKeyTokenRecord load(Integer key, Void additionalData) {
                return (PropertyKeyTokenRecord)store.getRecord(key);
            }

            @Override
            public void ensureHeavy(PropertyKeyTokenRecord record) {
                store.ensureHeavy(record);
            }

            @Override
            public PropertyKeyTokenRecord clone(PropertyKeyTokenRecord record) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static RecordAccess.Loader<Integer, LabelTokenRecord, Void> labelTokenLoader(final TokenStore<LabelTokenRecord> store) {
        return new RecordAccess.Loader<Integer, LabelTokenRecord, Void>(){

            @Override
            public LabelTokenRecord newUnused(Integer key, Void additionalData) {
                return Loaders.andMarkAsCreated(new LabelTokenRecord(key));
            }

            @Override
            public LabelTokenRecord load(Integer key, Void additionalData) {
                return (LabelTokenRecord)store.getRecord(key);
            }

            @Override
            public void ensureHeavy(LabelTokenRecord record) {
                store.ensureHeavy(record);
            }

            @Override
            public LabelTokenRecord clone(LabelTokenRecord record) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static RecordAccess.Loader<Integer, RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader(final TokenStore<RelationshipTypeTokenRecord> store) {
        return new RecordAccess.Loader<Integer, RelationshipTypeTokenRecord, Void>(){

            @Override
            public RelationshipTypeTokenRecord newUnused(Integer key, Void additionalData) {
                return Loaders.andMarkAsCreated(new RelationshipTypeTokenRecord(key));
            }

            @Override
            public RelationshipTypeTokenRecord load(Integer key, Void additionalData) {
                return (RelationshipTypeTokenRecord)store.getRecord(key);
            }

            @Override
            public void ensureHeavy(RelationshipTypeTokenRecord record) {
                store.ensureHeavy(record);
            }

            @Override
            public RelationshipTypeTokenRecord clone(RelationshipTypeTokenRecord record) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected static <RECORD extends AbstractBaseRecord> RECORD andMarkAsCreated(RECORD record) {
        record.setCreated();
        return record;
    }
}

