/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.logging;

import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.LogMarker;

public class ConsoleLogger {
    private final StringLogger realLogger;
    public static final ConsoleLogger DEV_NULL = new ConsoleLogger(StringLogger.DEV_NULL);

    public ConsoleLogger(StringLogger realLogger) {
        this.realLogger = realLogger;
    }

    public void log(String message) {
        this.realLogger.info(message, null, false, LogMarker.CONSOLE_MARK);
    }

    public void log(String format, Object ... parameters) {
        this.log(String.format(format, parameters));
    }

    public void warn(String message) {
        this.realLogger.warn(message, null, false, LogMarker.CONSOLE_MARK);
    }

    public void warn(String format, Object ... parameters) {
        this.warn(String.format(format, parameters));
    }

    @Deprecated
    public void warn(String message, Throwable warning) {
        this.realLogger.warn(message, warning, false, LogMarker.CONSOLE_MARK);
    }

    public void error(String message) {
        this.realLogger.error(message);
    }

    public void error(String format, Object ... parameters) {
        this.error(String.format(format, parameters));
    }

    @Deprecated
    public void error(String message, Throwable error) {
        this.realLogger.error(message, error, true, LogMarker.CONSOLE_MARK);
    }
}

