/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.cursor;

import java.util.Iterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.function.Consumer;
import org.neo4j.kernel.api.cursor.PropertyItem;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.cursor.TxAbstractPropertyCursor;
import org.neo4j.kernel.impl.util.VersionedHashMap;

public class TxAllPropertyCursor
extends TxAbstractPropertyCursor {
    private Iterator<DefinedProperty> added;

    public TxAllPropertyCursor(Consumer<TxAbstractPropertyCursor> instanceCache) {
        super(instanceCache);
    }

    @Override
    public Cursor<PropertyItem> init(Cursor<PropertyItem> cursor, VersionedHashMap<Integer, DefinedProperty> addedProperties, VersionedHashMap<Integer, DefinedProperty> changedProperties, VersionedHashMap<Integer, DefinedProperty> removedProperties) {
        this.cursor = cursor;
        this.addedProperties = addedProperties;
        this.changedProperties = changedProperties;
        this.removedProperties = removedProperties;
        return this;
    }

    public boolean next() {
        if (this.added == null) {
            while (this.cursor.next()) {
                Property property;
                int propertyKeyId = ((PropertyItem)this.cursor.get()).propertyKeyId();
                if (this.changedProperties != null && (property = (Property)this.changedProperties.get(propertyKeyId)) != null) {
                    this.property = (DefinedProperty)property;
                    return true;
                }
                if (this.removedProperties != null && this.removedProperties.containsKey(propertyKeyId)) continue;
                this.property = Property.property(propertyKeyId, ((PropertyItem)this.cursor.get()).value());
                return true;
            }
            if (this.addedProperties != null) {
                this.added = this.addedProperties.values().iterator();
            }
        }
        if (this.added != null && this.added.hasNext()) {
            this.property = this.added.next();
            return true;
        }
        this.property = null;
        return false;
    }

    @Override
    public void close() {
        this.added = null;
        super.close();
    }
}

