/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.OutputStream;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.logging.FormattedLogProvider;

public final class StandalonePageCacheFactory {
    private StandalonePageCacheFactory() {
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem) {
        return StandalonePageCacheFactory.createPageCache(fileSystem, new Config());
    }

    public static PageCache createPageCache(FileSystemAbstraction fileSystem, Config config) {
        Config baseConfig = new Config(MapUtil.stringMap(GraphDatabaseSettings.pagecache_memory.name(), "8M"));
        Config finalConfig = baseConfig.with(config.getParams());
        FormattedLogProvider logProvider = FormattedLogProvider.toOutputStream((OutputStream)System.err);
        ConfiguringPageCacheFactory pageCacheFactory = new ConfiguringPageCacheFactory(fileSystem, finalConfig, PageCacheTracer.NULL, logProvider.getLog(PageCache.class));
        return pageCacheFactory.getOrCreatePageCache();
    }
}

