/*
 * Copyright (c) 2002-2016 "Neo Technology,"
 * Network Engine for Objects in Lund AB [http://neotechnology.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.util.function.Function;

import org.neo4j.unsafe.impl.batchimport.input.InputEntity;

public interface Decorator<ENTITY extends InputEntity> extends Function<ENTITY,ENTITY>
{
    /**
     * @return whether or not this decorator is mutable. This is important because a state-less decorator
     * can be called from multiple parallel processing threads. A mutable decorator has to be called by
     * a single thread and may incur a performance penalty.
     */
    default boolean isMutable()
    {
        return false;
    }
}
