/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.AnnotationBasedConfigurationMigrator;
import org.neo4j.kernel.configuration.ConfigValues;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.logging.BufferingLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public class Config
implements DiagnosticsProvider,
Configuration {
    private final Map<String, String> params = new ConcurrentHashMap<String, String>();
    private final Iterable<Class<?>> settingsClasses;
    private final ConfigurationMigrator migrator;
    private final ConfigurationValidator validator;
    private ConfigValues settingsFunction;
    private final BufferingLog bufferedLog = new BufferingLog();
    private Log log = this.bufferedLog;

    public static Config empty() {
        return new Config();
    }

    public static Config defaults() {
        return new Config();
    }

    private Config() {
        this(new HashMap<String, String>());
    }

    public Config(Map<String, String> inputParams) {
        this(inputParams, Collections.emptyList());
    }

    public Config(Map<String, String> inputParams, Class<?> ... settingsClasses) {
        this(inputParams, Arrays.asList(settingsClasses));
    }

    public Config(Map<String, String> params, Iterable<Class<?>> settingsClasses) {
        this(Optional.empty(), params, (Map<String, String> settings) -> {}, (Map<String, String> classes) -> settingsClasses);
    }

    public Config(Optional<File> configFile, Map<String, String> overriddenSettings, Consumer<Map<String, String>> settingsPostProcessor, Function<Map<String, String>, Iterable<Class<?>>> settingClassesProvider) {
        Map<String, String> settings = this.initSettings(configFile, settingsPostProcessor, overriddenSettings);
        this.settingsClasses = settingClassesProvider.apply(settings);
        this.migrator = new AnnotationBasedConfigurationMigrator(this.settingsClasses);
        this.validator = new ConfigurationValidator(this.settingsClasses);
        this.replaceSettings(settings);
    }

    public Config with(Map<String, String> additionalConfig, Class<?> ... settingsClasses) {
        Map<String, String> newParams = this.getParams();
        newParams.putAll(additionalConfig);
        return new Config(newParams, Iterables.concat((Iterable[])new Iterable[]{this.settingsClasses, Arrays.asList(settingsClasses)}));
    }

    public Map<String, String> getParams() {
        return new HashMap<String, String>(this.params);
    }

    public <T> T get(Setting<T> setting) {
        return (T)setting.apply((Object)this.settingsFunction);
    }

    public <T> T view(Function<ConfigValues, T> projection) {
        return projection.apply(this.settingsFunction);
    }

    public Config augment(Map<String, String> changes) {
        Map<String, String> params = this.getParams();
        params.putAll(changes);
        this.replaceSettings(params);
        return this;
    }

    public Iterable<Class<?>> getSettingsClasses() {
        return this.settingsClasses;
    }

    public void setLogger(Log log) {
        if (this.log == this.bufferedLog) {
            this.bufferedLog.replayInto(log);
        }
        this.log = log;
    }

    @Override
    public String getDiagnosticsIdentifier() {
        return this.getClass().getName();
    }

    @Override
    public void acceptDiagnosticsVisitor(Object visitor) {
    }

    @Override
    public void dump(DiagnosticsPhase phase, Logger logger) {
        if (phase.isInitialization() || phase.isExplicitlyRequested()) {
            logger.log("Neo4j Kernel properties:");
            for (Map.Entry<String, String> param : this.params.entrySet()) {
                logger.log("%s=%s", new Object[]{param.getKey(), param.getValue()});
            }
        }
    }

    public String toString() {
        ArrayList<String> keys = new ArrayList<String>(this.params.keySet());
        Collections.sort(keys);
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        for (String key : keys) {
            output.put(key, this.params.get(key));
        }
        return output.toString();
    }

    private synchronized void replaceSettings(Map<String, String> newSettings) {
        Map<String, String> migratedSettings = this.migrator.apply(newSettings, this.log);
        this.validator.validate(migratedSettings);
        this.params.clear();
        this.params.putAll(migratedSettings);
        this.settingsFunction = new ConfigValues(this.params);
    }

    private Map<String, String> initSettings(Optional<File> configFile, Consumer<Map<String, String>> settingsPostProcessor, Map<String, String> overriddenSettings) {
        HashMap<String, String> settings = new HashMap<String, String>();
        configFile.ifPresent(file -> settings.putAll(this.loadFromFile((File)file)));
        settingsPostProcessor.accept(settings);
        settings.putAll(overriddenSettings);
        return settings;
    }

    private Map<String, String> loadFromFile(File file) {
        if (!file.exists()) {
            this.log.warn("Config file [%s] does not exist.", new Object[]{file});
            return new HashMap<String, String>();
        }
        try {
            return MapUtil.load((File)file);
        }
        catch (IOException e) {
            this.log.error("Unable to load config file [%s]: %s", new Object[]{file, e.getMessage()});
            return new HashMap<String, String>();
        }
    }
}

