/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordCursor;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.staging.AbstractStep;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class ReadNodeRecordsByCacheStep
extends AbstractStep<NodeRecord[]> {
    private final boolean denseNodes;
    private final NodeRelationshipCache cache;
    private final int batchSize;
    private final RecordCursor<NodeRecord> recordCursor;

    public ReadNodeRecordsByCacheStep(StageControl control, Configuration config, NodeStore nodeStore, NodeRelationshipCache cache, boolean denseNodes) {
        super(control, ">", config, new StatsProvider[0]);
        this.cache = cache;
        this.denseNodes = denseNodes;
        this.batchSize = config.batchSize();
        this.recordCursor = nodeStore.newRecordCursor(nodeStore.newRecord());
    }

    @Override
    public void start(int orderingGuarantees) {
        super.start(orderingGuarantees);
        this.recordCursor.acquire(0L, RecordLoad.NORMAL);
    }

    @Override
    public void close() throws Exception {
        this.recordCursor.close();
        super.close();
    }

    @Override
    public long receive(long ticket, NodeRecord[] batch) {
        new Thread(){

            @Override
            public void run() {
                ReadNodeRecordsByCacheStep.this.assertHealthy();
                try (NodeVisitor visitor = new NodeVisitor();){
                    ReadNodeRecordsByCacheStep.this.cache.visitChangedNodes(visitor, ReadNodeRecordsByCacheStep.this.denseNodes);
                }
                ReadNodeRecordsByCacheStep.this.endOfUpstream();
            }
        }.start();
        return 0L;
    }

    private class NodeVisitor
    implements NodeRelationshipCache.NodeChangeVisitor,
    AutoCloseable {
        private NodeRecord[] batch;
        private int cursor;
        private long time;

        private NodeVisitor() {
            this.batch = new NodeRecord[ReadNodeRecordsByCacheStep.this.batchSize];
            this.time = System.nanoTime();
        }

        @Override
        public void change(long nodeId, ByteArray array) {
            ReadNodeRecordsByCacheStep.this.recordCursor.next(nodeId);
            this.batch[this.cursor++] = ((NodeRecord)ReadNodeRecordsByCacheStep.this.recordCursor.get()).clone();
            if (this.cursor == ReadNodeRecordsByCacheStep.this.batchSize) {
                this.send();
                this.batch = new NodeRecord[ReadNodeRecordsByCacheStep.this.batchSize];
                this.cursor = 0;
            }
        }

        private void send() {
            ReadNodeRecordsByCacheStep.this.totalProcessingTime.add(System.nanoTime() - this.time);
            ReadNodeRecordsByCacheStep.this.downstream.receive(ReadNodeRecordsByCacheStep.this.doneBatches.getAndIncrement(), this.batch);
            this.time = System.nanoTime();
            ReadNodeRecordsByCacheStep.this.assertHealthy();
        }

        @Override
        public void close() {
            if (this.cursor > 0) {
                this.send();
            }
        }
    }
}

