/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Format;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.CalculateDenseNodesStage;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.CountingStoreUpdateMonitor;
import org.neo4j.unsafe.impl.batchimport.DeleteDuplicateNodesStage;
import org.neo4j.unsafe.impl.batchimport.IdMapperPreparationStage;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.MemoryUsageStatsProvider;
import org.neo4j.unsafe.impl.batchimport.NodeCountsStage;
import org.neo4j.unsafe.impl.batchimport.NodeFirstRelationshipStage;
import org.neo4j.unsafe.impl.batchimport.NodeStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipGroupDefragmenter;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkbackStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipTypeDistribution;
import org.neo4j.unsafe.impl.batchimport.SourceOrCachedInputIterable;
import org.neo4j.unsafe.impl.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class ParallelBatchImporter
implements BatchImporter {
    private final File storeDir;
    private final FileSystemAbstraction fileSystem;
    private final Configuration config;
    private final LogService logService;
    private final Log log;
    private final ExecutionMonitor executionMonitor;
    private final AdditionalInitialIds additionalInitialIds;
    private final Config dbConfig;
    private final RecordFormats recordFormats;
    private final PageCache pageCache;

    public ParallelBatchImporter(File storeDir, FileSystemAbstraction fileSystem, Configuration config, LogService logService, ExecutionMonitor executionMonitor, AdditionalInitialIds additionalInitialIds, Config dbConfig, RecordFormats recordFormats) {
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
        this.pageCache = null;
        this.config = config;
        this.logService = logService;
        this.dbConfig = dbConfig;
        this.recordFormats = recordFormats;
        this.log = logService.getInternalLogProvider().getLog(this.getClass());
        this.executionMonitor = executionMonitor;
        this.additionalInitialIds = additionalInitialIds;
    }

    public ParallelBatchImporter(File storeDir, FileSystemAbstraction fileSystem, PageCache pageCache, Configuration config, LogService logService, ExecutionMonitor executionMonitor, AdditionalInitialIds additionalInitialIds, Config dbConfig, RecordFormats recordFormats) {
        this.pageCache = pageCache;
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
        this.config = config;
        this.logService = logService;
        this.dbConfig = dbConfig;
        this.recordFormats = recordFormats;
        this.log = logService.getInternalLogProvider().getLog(this.getClass());
        this.executionMonitor = executionMonitor;
        this.additionalInitialIds = additionalInitialIds;
    }

    public ParallelBatchImporter(File storeDir, FileSystemAbstraction fileSystem, Configuration config, LogService logService, ExecutionMonitor executionMonitor, Config dbConfig) {
        this(storeDir, fileSystem, config, logService, ExecutionSupervisors.withDynamicProcessorAssignment(executionMonitor, config), AdditionalInitialIds.EMPTY, dbConfig, RecordFormatSelector.selectForConfig(dbConfig, (LogProvider)NullLogProvider.getInstance()));
    }

    @Override
    public void doImport(Input input) throws IOException {
        this.log.info("Import starting");
        long maxMemory = this.config.maxMemoryUsage();
        NodeRelationshipCache nodeRelationshipCache = null;
        NodeLabelsCache nodeLabelsCache = null;
        long startTime = System.currentTimeMillis();
        CountingStoreUpdateMonitor storeUpdateMonitor = new CountingStoreUpdateMonitor();
        try (BatchingNeoStores neoStore = this.getBatchingNeoStores();
             CountsAccessor.Updater countsUpdater = neoStore.getCountsStore().reset(neoStore.getLastCommittedTransactionId());
             InputCache inputCache = new InputCache(this.fileSystem, this.storeDir, this.recordFormats, this.config);){
            Collector badCollector = input.badCollector();
            IoMonitor writeMonitor = new IoMonitor(neoStore.getIoTracer());
            IdMapper idMapper = input.idMapper();
            IdGenerator idGenerator = input.idGenerator();
            nodeRelationshipCache = new NodeRelationshipCache(NumberArrayFactory.AUTO, this.config.denseNodeThreshold());
            MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(nodeRelationshipCache, idMapper);
            InputIterable<InputNode> nodes = input.nodes();
            InputIterable<InputRelationship> relationships = input.relationships();
            InputIterable<InputNode> cachedNodes = SourceOrCachedInputIterable.cachedForSure(nodes, inputCache.nodes("main", true));
            InputIterable<InputRelationship> cachedRelationships = SourceOrCachedInputIterable.cachedForSure(relationships, inputCache.relationships("main", false));
            RelationshipStore relationshipStore = neoStore.getRelationshipStore();
            Configuration nodeConfig = ParallelBatchImporter.configWithRecordsPerPageBasedBatchSize(this.config, neoStore.getNodeStore());
            NodeStage nodeStage = new NodeStage(nodeConfig, writeMonitor, nodes, idMapper, idGenerator, neoStore, inputCache, neoStore.getLabelScanStore(), storeUpdateMonitor, nodeRelationshipCache, memoryUsageStats);
            neoStore.startFlushingPageCache();
            this.executeStage(nodeStage);
            neoStore.stopFlushingPageCache();
            if (idMapper.needsPreparation()) {
                this.executeStage(new IdMapperPreparationStage(this.config, idMapper, cachedNodes, badCollector, memoryUsageStats));
                PrimitiveLongIterator duplicateNodeIds = badCollector.leftOverDuplicateNodesIds();
                if (duplicateNodeIds.hasNext()) {
                    this.executeStage(new DeleteDuplicateNodesStage(this.config, duplicateNodeIds, neoStore));
                }
            }
            Configuration relationshipConfig = ParallelBatchImporter.configWithRecordsPerPageBasedBatchSize(this.config, neoStore.getNodeStore());
            CalculateDenseNodesStage calculateDenseNodesStage = new CalculateDenseNodesStage(relationshipConfig, relationships, nodeRelationshipCache, idMapper, badCollector, inputCache, neoStore);
            this.executeStage(calculateDenseNodesStage);
            long availableMemory = maxMemory - this.totalMemoryUsageOf(nodeRelationshipCache, idMapper);
            this.importRelationships(nodeRelationshipCache, storeUpdateMonitor, neoStore, writeMonitor, idMapper, cachedRelationships, calculateDenseNodesStage.getDistribution(), availableMemory);
            long peakMemoryUsage = this.totalMemoryUsageOf(idMapper, nodeRelationshipCache);
            long highNodeId = nodeRelationshipCache.getHighNodeId();
            idMapper.close();
            idMapper = null;
            nodeRelationshipCache.close();
            nodeRelationshipCache = null;
            new RelationshipGroupDefragmenter(this.config, this.executionMonitor).run(Long.max(maxMemory, peakMemoryUsage), neoStore, highNodeId);
            nodeLabelsCache = new NodeLabelsCache(NumberArrayFactory.AUTO, neoStore.getLabelRepository().getHighId());
            memoryUsageStats = new MemoryUsageStatsProvider(nodeLabelsCache);
            this.executeStage(new NodeCountsStage(this.config, nodeLabelsCache, neoStore.getNodeStore(), neoStore.getLabelRepository().getHighId(), countsUpdater, memoryUsageStats));
            this.executeStage(new RelationshipCountsStage(this.config, nodeLabelsCache, relationshipStore, neoStore.getLabelRepository().getHighId(), neoStore.getRelationshipTypeRepository().getHighId(), countsUpdater, NumberArrayFactory.AUTO));
            long totalTimeMillis = System.currentTimeMillis() - startTime;
            this.executionMonitor.done(totalTimeMillis, String.format("%n", new Object[0]) + storeUpdateMonitor.toString() + String.format("%n", new Object[0]) + "Peak memory usage: " + Format.bytes(peakMemoryUsage));
            this.log.info("Import completed, took " + Format.duration(totalTimeMillis) + ". " + storeUpdateMonitor);
        }
        catch (Throwable t) {
            this.log.error("Error during import", t);
            throw (IOException)Exceptions.launderedException(IOException.class, (Throwable)t);
        }
        finally {
            if (nodeRelationshipCache != null) {
                nodeRelationshipCache.close();
            }
            if (nodeLabelsCache != null) {
                nodeLabelsCache.close();
            }
        }
    }

    private BatchingNeoStores getBatchingNeoStores() {
        if (this.pageCache == null) {
            return BatchingNeoStores.batchingNeoStores(this.fileSystem, this.storeDir, this.recordFormats, this.config, this.logService, this.additionalInitialIds, this.dbConfig);
        }
        return BatchingNeoStores.batchingNeoStoresWithExternalPageCache(this.fileSystem, this.pageCache, PageCacheTracer.NULL, this.storeDir, this.recordFormats, this.config, this.logService, this.additionalInitialIds, this.dbConfig);
    }

    private long totalMemoryUsageOf(MemoryStatsVisitor.Visitable ... users) {
        GatheringMemoryStatsVisitor total = new GatheringMemoryStatsVisitor();
        for (MemoryStatsVisitor.Visitable user : users) {
            user.acceptMemoryStatsVisitor(total);
        }
        return total.getHeapUsage() + total.getOffHeapUsage();
    }

    private void importRelationships(NodeRelationshipCache nodeRelationshipCache, CountingStoreUpdateMonitor storeUpdateMonitor, BatchingNeoStores neoStore, IoMonitor writeMonitor, IdMapper idMapper, InputIterable<InputRelationship> relationships, RelationshipTypeDistribution typeDistribution, long freeMemoryForDenseNodeCache) {
        long nextRelationshipId = 0L;
        Configuration relationshipConfig = ParallelBatchImporter.configWithRecordsPerPageBasedBatchSize(this.config, neoStore.getRelationshipStore());
        Configuration nodeConfig = ParallelBatchImporter.configWithRecordsPerPageBasedBatchSize(this.config, neoStore.getNodeStore());
        Iterator<Collection<Object>> rounds = nodeRelationshipCache.splitRelationshipTypesIntoRounds(typeDistribution.iterator(), freeMemoryForDenseNodeCache);
        int typesImported = 0;
        int round = 0;
        round = 0;
        while (rounds.hasNext()) {
            Collection<Object> typesToImportThisRound = rounds.next();
            boolean thisIsTheOnlyRound = round == 0 && !rounds.hasNext();
            nodeRelationshipCache.setForwardScan(true, true);
            String range = typesToImportThisRound.size() == 1 ? String.valueOf(typesImported + 1) : typesImported + 1 + "-" + (typesImported + typesToImportThisRound.size());
            String topic = " " + range + "/" + typeDistribution.getNumberOfRelationshipTypes();
            Predicate<InputRelationship> typeFilter = thisIsTheOnlyRound ? relationship -> true : relationship -> typesToImportThisRound.contains(relationship.typeAsObject());
            RelationshipStage relationshipStage = new RelationshipStage(topic, this.config, writeMonitor, typeFilter, (InputIterator<InputRelationship>)relationships.iterator(), idMapper, neoStore, nodeRelationshipCache, storeUpdateMonitor, nextRelationshipId);
            neoStore.startFlushingPageCache();
            this.executeStage(relationshipStage);
            neoStore.stopFlushingPageCache();
            int nodeTypes = thisIsTheOnlyRound ? 3 : 1;
            this.executeStage(new NodeFirstRelationshipStage(topic, nodeConfig, neoStore.getNodeStore(), neoStore.getTemporaryRelationshipGroupStore(), nodeRelationshipCache, nodeTypes));
            nodeRelationshipCache.setForwardScan(false, true);
            this.executeStage(new RelationshipLinkbackStage(topic, relationshipConfig, neoStore.getRelationshipStore(), nodeRelationshipCache, nextRelationshipId, relationshipStage.getNextRelationshipId(), nodeTypes));
            nextRelationshipId = relationshipStage.getNextRelationshipId();
            typesImported += typesToImportThisRound.size();
            ++round;
        }
        if (round > 1) {
            String topic = " Sparse";
            nodeRelationshipCache.setForwardScan(true, false);
            this.executeStage(new NodeFirstRelationshipStage(topic, nodeConfig, neoStore.getNodeStore(), neoStore.getTemporaryRelationshipGroupStore(), nodeRelationshipCache, 2));
            nodeRelationshipCache.setForwardScan(false, false);
            this.executeStage(new RelationshipLinkbackStage(topic, relationshipConfig, neoStore.getRelationshipStore(), nodeRelationshipCache, 0L, nextRelationshipId, 2));
        }
    }

    private static Configuration configWithRecordsPerPageBasedBatchSize(Configuration source, RecordStore<?> store) {
        return Configuration.withBatchSize(source, store.getRecordsPerPage() * 100);
    }

    private void executeStage(Stage stage) {
        ExecutionSupervisors.superviseExecution(this.executionMonitor, this.config, stage);
    }
}

