/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.constaints;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema.SchemaUtil;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;

public class NodeExistenceConstraintDescriptor
extends ConstraintDescriptor
implements LabelSchemaSupplier {
    private LabelSchemaDescriptor schema;

    NodeExistenceConstraintDescriptor(LabelSchemaDescriptor schema) {
        super(ConstraintDescriptor.Type.EXISTS);
        this.schema = schema;
    }

    @Override
    public LabelSchemaDescriptor schema() {
        return this.schema;
    }

    @Override
    public String prettyPrint(TokenNameLookup tokenNameLookup) {
        String labelName = this.escapeLabelOrRelTyp(tokenNameLookup.labelGetName(this.schema.getLabelId()));
        String nodeName = labelName.toLowerCase();
        String properties = SchemaUtil.niceProperties(tokenNameLookup, this.schema.getPropertyIds(), nodeName + ".", false);
        return String.format("CONSTRAINT ON ( %s:%s ) ASSERT exists(%s)", nodeName, labelName, properties);
    }
}

