/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInCompositeSchemaException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.constaints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.TwoPhaseNodeForRelationshipLocking;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.LockOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaStateOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.values.storable.Value;

public class LockingStatementOperations
implements EntityWriteOperations,
SchemaReadOperations,
SchemaWriteOperations,
SchemaStateOperations,
LockOperations {
    private final EntityReadOperations entityReadDelegate;
    private final EntityWriteOperations entityWriteDelegate;
    private final SchemaReadOperations schemaReadDelegate;
    private final SchemaWriteOperations schemaWriteDelegate;
    private final SchemaStateOperations schemaStateDelegate;

    public LockingStatementOperations(EntityReadOperations entityReadDelegate, EntityWriteOperations entityWriteDelegate, SchemaReadOperations schemaReadDelegate, SchemaWriteOperations schemaWriteDelegate, SchemaStateOperations schemaStateDelegate) {
        this.entityReadDelegate = entityReadDelegate;
        this.entityWriteDelegate = entityWriteDelegate;
        this.schemaReadDelegate = schemaReadDelegate;
        this.schemaWriteDelegate = schemaWriteDelegate;
        this.schemaStateDelegate = schemaStateDelegate;
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws ConstraintValidationException, EntityNotFoundException {
        this.sharedLabelLock(state, labelId);
        this.acquireExclusiveNodeLock(state, nodeId);
        state.assertOpen();
        return this.entityWriteDelegate.nodeAddLabel(state, nodeId, labelId);
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        this.acquireExclusiveNodeLock(state, nodeId);
        state.assertOpen();
        return this.entityWriteDelegate.nodeRemoveLabel(state, nodeId, labelId);
    }

    @Override
    public IndexDescriptor indexCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws AlreadyIndexedException, AlreadyConstrainedException, RepeatedPropertyInCompositeSchemaException {
        this.exclusiveLabelLock(state, descriptor.getLabelId());
        state.assertOpen();
        return this.schemaWriteDelegate.indexCreate(state, descriptor);
    }

    @Override
    public void indexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        this.exclusiveLabelLock(state, descriptor.schema().getLabelId());
        state.assertOpen();
        this.schemaWriteDelegate.indexDrop(state, descriptor);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        this.exclusiveLabelLock(state, descriptor.schema().getLabelId());
        state.assertOpen();
        this.schemaWriteDelegate.uniqueIndexDrop(state, descriptor);
    }

    @Override
    public <K, V> V schemaStateGetOrCreate(KernelStatement state, K key, Function<K, V> creator) {
        state.assertOpen();
        return this.schemaStateDelegate.schemaStateGetOrCreate(state, key, creator);
    }

    @Override
    public <K, V> V schemaStateGet(KernelStatement state, K key) {
        state.assertOpen();
        return this.schemaStateDelegate.schemaStateGet(state, key);
    }

    @Override
    public void schemaStateFlush(KernelStatement state) {
        state.assertOpen();
        this.schemaStateDelegate.schemaStateFlush(state);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(KernelStatement state, int labelId) {
        this.sharedLabelLock(state, labelId);
        state.assertOpen();
        return this.schemaReadDelegate.indexesGetForLabel(state, labelId);
    }

    @Override
    public IndexDescriptor indexGetForSchema(KernelStatement state, LabelSchemaDescriptor descriptor) {
        this.sharedLabelLock(state, descriptor.getLabelId());
        state.assertOpen();
        return this.schemaReadDelegate.indexGetForSchema(state, descriptor);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(KernelStatement state) {
        state.assertOpen();
        return Iterators.map(indexDescriptor -> {
            this.sharedLabelLock(state, indexDescriptor.schema().getLabelId());
            return indexDescriptor;
        }, this.schemaReadDelegate.indexesGetAll(state));
    }

    @Override
    public InternalIndexState indexGetState(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.sharedLabelLock(state, descriptor.schema().getLabelId());
        state.assertOpen();
        return this.schemaReadDelegate.indexGetState(state, descriptor);
    }

    @Override
    public SchemaIndexProvider.Descriptor indexGetProviderDescriptor(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.sharedLabelLock(state, descriptor.schema().getLabelId());
        state.assertOpen();
        return this.schemaReadDelegate.indexGetProviderDescriptor(state, descriptor);
    }

    @Override
    public PopulationProgress indexGetPopulationProgress(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.sharedLabelLock(state, descriptor.schema().getLabelId());
        state.assertOpen();
        return this.schemaReadDelegate.indexGetPopulationProgress(state, descriptor);
    }

    @Override
    public long indexSize(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.sharedLabelLock(state, descriptor.schema().getLabelId());
        state.assertOpen();
        return this.schemaReadDelegate.indexSize(state, descriptor);
    }

    @Override
    public double indexUniqueValuesPercentage(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        this.sharedLabelLock(state, descriptor.schema().getLabelId());
        state.assertOpen();
        return this.schemaReadDelegate.indexUniqueValuesPercentage(state, descriptor);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(KernelStatement state, IndexDescriptor index) {
        this.sharedLabelLock(state, index.schema().getLabelId());
        state.assertOpen();
        return this.schemaReadDelegate.indexGetOwningUniquenessConstraintId(state, index);
    }

    @Override
    public long indexGetCommittedId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        this.sharedLabelLock(state, index.schema().getLabelId());
        state.assertOpen();
        return this.schemaReadDelegate.indexGetCommittedId(state, index);
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.acquireExclusiveNodeLock(state, nodeId);
        state.assertOpen();
        this.entityWriteDelegate.nodeDelete(state, nodeId);
    }

    @Override
    public int nodeDetachDelete(KernelStatement state, long nodeId) throws KernelException {
        MutableInt count = new MutableInt();
        TwoPhaseNodeForRelationshipLocking locking = new TwoPhaseNodeForRelationshipLocking(this.entityReadDelegate, (ThrowingConsumer<Long, KernelException>)((ThrowingConsumer)relId -> {
            state.assertOpen();
            try {
                this.entityWriteDelegate.relationshipDelete(state, (long)relId);
                count.increment();
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
        }));
        locking.lockAllNodesAndConsumeRelationships(nodeId, state);
        state.assertOpen();
        this.entityWriteDelegate.nodeDetachDelete(state, nodeId);
        return count.intValue();
    }

    @Override
    public long nodeCreate(KernelStatement statement) {
        return this.entityWriteDelegate.nodeCreate(statement);
    }

    @Override
    public long relationshipCreate(KernelStatement state, int relationshipTypeId, long startNodeId, long endNodeId) throws EntityNotFoundException {
        this.sharedRelationshipTypeLock(state, relationshipTypeId);
        this.lockRelationshipNodes(state, startNodeId, endNodeId);
        return this.entityWriteDelegate.relationshipCreate(state, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public void relationshipDelete(KernelStatement state, long relationshipId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.entityReadDelegate.relationshipVisit(state, relationshipId, (relId, type, startNode, endNode) -> this.lockRelationshipNodes(state, startNode, endNode));
        this.acquireExclusiveRelationshipLock(state, relationshipId);
        state.assertOpen();
        this.entityWriteDelegate.relationshipDelete(state, relationshipId);
    }

    private void lockRelationshipNodes(KernelStatement state, long startNodeId, long endNodeId) {
        this.acquireExclusiveNodeLock(state, Math.min(startNodeId, endNodeId));
        if (startNodeId != endNodeId) {
            this.acquireExclusiveNodeLock(state, Math.max(startNodeId, endNodeId));
        }
    }

    @Override
    public NodeKeyConstraintDescriptor nodeKeyConstraintCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws CreateConstraintFailureException, AlreadyConstrainedException, AlreadyIndexedException, RepeatedPropertyInCompositeSchemaException {
        this.exclusiveLabelLock(state, descriptor.getLabelId());
        state.assertOpen();
        return this.schemaWriteDelegate.nodeKeyConstraintCreate(state, descriptor);
    }

    @Override
    public UniquenessConstraintDescriptor uniquePropertyConstraintCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws CreateConstraintFailureException, AlreadyConstrainedException, AlreadyIndexedException, RepeatedPropertyInCompositeSchemaException {
        this.exclusiveLabelLock(state, descriptor.getLabelId());
        state.assertOpen();
        return this.schemaWriteDelegate.uniquePropertyConstraintCreate(state, descriptor);
    }

    @Override
    public NodeExistenceConstraintDescriptor nodePropertyExistenceConstraintCreate(KernelStatement state, LabelSchemaDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException, RepeatedPropertyInCompositeSchemaException {
        this.exclusiveLabelLock(state, descriptor.getLabelId());
        state.assertOpen();
        return this.schemaWriteDelegate.nodePropertyExistenceConstraintCreate(state, descriptor);
    }

    @Override
    public RelExistenceConstraintDescriptor relationshipPropertyExistenceConstraintCreate(KernelStatement state, RelationTypeSchemaDescriptor descriptor) throws AlreadyConstrainedException, CreateConstraintFailureException, RepeatedPropertyInCompositeSchemaException {
        this.exclusiveRelationshipTypeLock(state, descriptor.getRelTypeId());
        state.assertOpen();
        return this.schemaWriteDelegate.relationshipPropertyExistenceConstraintCreate(state, descriptor);
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForSchema(KernelStatement state, SchemaDescriptor descriptor) {
        this.sharedOptimisticLock(state, descriptor.keyType(), descriptor.keyId());
        state.assertOpen();
        return this.schemaReadDelegate.constraintsGetForSchema(state, descriptor);
    }

    @Override
    public boolean constraintExists(KernelStatement state, ConstraintDescriptor descriptor) {
        SchemaDescriptor schema = descriptor.schema();
        this.sharedOptimisticLock(state, schema.keyType(), schema.keyId());
        state.assertOpen();
        return this.schemaReadDelegate.constraintExists(state, descriptor);
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForLabel(KernelStatement state, int labelId) {
        this.sharedLabelLock(state, labelId);
        state.assertOpen();
        return this.schemaReadDelegate.constraintsGetForLabel(state, labelId);
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(KernelStatement state, int typeId) {
        this.sharedRelationshipTypeLock(state, typeId);
        state.assertOpen();
        return this.schemaReadDelegate.constraintsGetForRelationshipType(state, typeId);
    }

    @Override
    public Iterator<ConstraintDescriptor> constraintsGetAll(KernelStatement state) {
        state.assertOpen();
        return Iterators.map(constraintDescriptor -> {
            SchemaDescriptor schema = constraintDescriptor.schema();
            this.acquireShared(state, schema.keyType(), schema.keyId());
            return constraintDescriptor;
        }, this.schemaReadDelegate.constraintsGetAll(state));
    }

    @Override
    public void constraintDrop(KernelStatement state, ConstraintDescriptor constraint) throws DropConstraintFailureException {
        SchemaDescriptor schema = constraint.schema();
        this.exclusiveOptimisticLock(state, schema.keyType(), schema.keyId());
        state.assertOpen();
        this.schemaWriteDelegate.constraintDrop(state, constraint);
    }

    @Override
    public Value nodeSetProperty(KernelStatement state, long nodeId, int propertyKeyId, Value value) throws ConstraintValidationException, EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.acquireExclusiveNodeLock(state, nodeId);
        state.assertOpen();
        return this.entityWriteDelegate.nodeSetProperty(state, nodeId, propertyKeyId, value);
    }

    @Override
    public Value nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.acquireExclusiveNodeLock(state, nodeId);
        state.assertOpen();
        return this.entityWriteDelegate.nodeRemoveProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Value relationshipSetProperty(KernelStatement state, long relationshipId, int propertyKeyId, Value value) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.acquireExclusiveRelationshipLock(state, relationshipId);
        state.assertOpen();
        return this.entityWriteDelegate.relationshipSetProperty(state, relationshipId, propertyKeyId, value);
    }

    @Override
    public Value relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException {
        this.acquireExclusiveRelationshipLock(state, relationshipId);
        state.assertOpen();
        return this.entityWriteDelegate.relationshipRemoveProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Value graphSetProperty(KernelStatement state, int propertyKeyId, Value value) {
        state.locks().optimistic().acquireExclusive(state.lockTracer(), ResourceTypes.GRAPH_PROPS, ResourceTypes.graphPropertyResource());
        state.assertOpen();
        return this.entityWriteDelegate.graphSetProperty(state, propertyKeyId, value);
    }

    @Override
    public Value graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        state.locks().optimistic().acquireExclusive(state.lockTracer(), ResourceTypes.GRAPH_PROPS, ResourceTypes.graphPropertyResource());
        state.assertOpen();
        return this.entityWriteDelegate.graphRemoveProperty(state, propertyKeyId);
    }

    @Override
    public void acquireExclusive(KernelStatement state, ResourceType resourceType, long ... ids) {
        state.locks().pessimistic().acquireExclusive(state.lockTracer(), resourceType, ids);
        state.assertOpen();
    }

    @Override
    public void acquireShared(KernelStatement state, ResourceType resourceType, long ... ids) {
        state.locks().pessimistic().acquireShared(state.lockTracer(), resourceType, ids);
        state.assertOpen();
    }

    @Override
    public void releaseExclusive(KernelStatement state, ResourceType type, long ... ids) {
        state.locks().pessimistic().releaseExclusive(type, ids);
        state.assertOpen();
    }

    @Override
    public void releaseShared(KernelStatement state, ResourceType type, long ... ids) {
        state.locks().pessimistic().releaseShared(type, ids);
        state.assertOpen();
    }

    @Override
    public String indexGetFailure(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.schemaReadDelegate.indexGetFailure(state, descriptor);
    }

    private void acquireExclusiveNodeLock(KernelStatement state, long nodeId) {
        if (!state.hasTxStateWithChanges() || !state.txState().nodeIsAddedInThisTx(nodeId)) {
            this.exclusiveOptimisticLock(state, ResourceTypes.NODE, nodeId);
        }
    }

    private void acquireExclusiveRelationshipLock(KernelStatement state, long relationshipId) {
        if (!state.hasTxStateWithChanges() || !state.txState().relationshipIsAddedInThisTx(relationshipId)) {
            this.exclusiveOptimisticLock(state, ResourceTypes.RELATIONSHIP, relationshipId);
        }
    }

    private void exclusiveLabelLock(KernelStatement state, long labelId) {
        this.exclusiveOptimisticLock(state, ResourceTypes.LABEL, labelId);
    }

    private void sharedLabelLock(KernelStatement state, long labelId) {
        this.sharedOptimisticLock(state, ResourceTypes.LABEL, labelId);
    }

    private void exclusiveRelationshipTypeLock(KernelStatement state, long typeId) {
        this.exclusiveOptimisticLock(state, ResourceTypes.RELATIONSHIP_TYPE, typeId);
    }

    private void sharedRelationshipTypeLock(KernelStatement state, long typeId) {
        this.sharedOptimisticLock(state, ResourceTypes.RELATIONSHIP_TYPE, typeId);
    }

    private void sharedOptimisticLock(KernelStatement statement, ResourceType resource, long resourceId) {
        statement.locks().optimistic().acquireShared(statement.lockTracer(), resource, resourceId);
    }

    private void exclusiveOptimisticLock(KernelStatement statement, ResourceType resource, long resourceId) {
        statement.locks().optimistic().acquireExclusive(statement.lockTracer(), resource, resourceId);
    }
}

